/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.calendar;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.List;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.AppointmentManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.user.calendar.CalendarPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.UrlTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarDialog
extends Modal<OmCalendar> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CalendarDialog.class);
    private CalendarPanel calendarPanel;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private BootstrapAjaxButton save;
    private BootstrapAjaxLink<String> delete;
    private UserCalendarForm form;
    private List<OmCalendar> cals;
    private int calIndex = 0;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private AppointmentManager apptManager;
    private DIALOG_TYPE type = DIALOG_TYPE.UPDATE_CALENDAR;
    private Appointment appointment = null;

    public CalendarDialog(String id, CalendarPanel calendarPanel, CompoundPropertyModel<OmCalendar> model) {
        super(id, model);
        this.calendarPanel = calendarPanel;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("calendar.dialogTitle"));
        this.form = new UserCalendarForm("calform", (IModel<OmCalendar>)this.getModel());
        this.add(new Component[]{this.form});
        this.save = new BootstrapAjaxButton("button", (IModel)new ResourceModel("144"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                switch (CalendarDialog.this.type) {
                    case UPDATE_CALENDAR: {
                        OmCalendar c = (OmCalendar)CalendarDialog.this.form.getModelObject();
                        c.setHref((String)CalendarDialog.this.form.url.getModelObject());
                        c.setOwner(CalendarDialog.this.userDao.get(c.getOwner().getId()));
                        HttpClient client = CalendarDialog.this.calendarPanel.getHttpClient();
                        HttpClientContext context = CalendarDialog.this.calendarPanel.getHttpClientContext();
                        if (Boolean.TRUE.equals(CalendarDialog.this.form.gcal.getModelObject())) {
                            c.setSyncType(OmCalendar.SyncType.GOOGLE_CALENDAR);
                            c.setToken((String)CalendarDialog.this.form.username.getModelObject());
                            if (c.getId() == null) {
                                CalendarDialog.this.calendarPanel.populateGoogleCalendar(c, (IPartialPageRequestHandler)target);
                            }
                        } else if (c.getId() == null && CalendarDialog.this.form.username.getModelObject() != null) {
                            CalendarDialog.this.apptManager.provideCredentials(context, c, (Credentials)new UsernamePasswordCredentials((String)CalendarDialog.this.form.username.getModelObject(), (String)CalendarDialog.this.form.pass.getModelObject()));
                        }
                        CalendarDialog.this.apptManager.createCalendar(client, context, c);
                        CalendarDialog.this.calendarPanel.refreshCalendars((IPartialPageRequestHandler)target);
                        CalendarDialog.this.calendarPanel.refresh((IPartialPageRequestHandler)target);
                        break;
                    }
                    case SYNC_CALENDAR: {
                        CalendarDialog.this.syncCalendar((OmCalendar)CalendarDialog.this.form.getModelObject(), (IPartialPageRequestHandler)target);
                        if (!CalendarDialog.this.setFormModelObject()) break;
                        CalendarDialog.this.setButtons((IPartialPageRequestHandler)target);
                        target.add(new Component[]{CalendarDialog.this.show((IPartialPageRequestHandler)target)});
                        break;
                    }
                    case UPDATE_APPOINTMENT: {
                        CalendarDialog.this.updateAppointment(CalendarDialog.this.appointment);
                        CalendarDialog.this.calendarPanel.refresh((IPartialPageRequestHandler)target);
                        break;
                    }
                    case DELETE_APPOINTMENT: {
                        CalendarDialog.this.deleteAppointment(CalendarDialog.this.appointment);
                        CalendarDialog.this.calendarPanel.refresh((IPartialPageRequestHandler)target);
                    }
                }
                CalendarDialog.this.clearFormModel((IPartialPageRequestHandler)target);
                target.add(new Component[]{CalendarDialog.this.feedback});
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{CalendarDialog.this.feedback});
            }
        };
        this.addButton((Component)this.save);
        this.save.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.delete = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("80")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget handler) {
                CalendarDialog.this.apptManager.deleteCalendar((OmCalendar)CalendarDialog.this.form.getModelObject());
                CalendarDialog.this.calendarPanel.refresh((IPartialPageRequestHandler)handler);
                CalendarDialog.this.calendarPanel.refreshCalendars((IPartialPageRequestHandler)handler);
            }
        };
        this.delete.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.addButton(this.delete.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))}));
        this.addButton((Component)OmModalCloseButton.of());
        super.onInitialize();
    }

    public void show(IPartialPageRequestHandler handler, DIALOG_TYPE type, Appointment a) {
        this.type = type;
        this.appointment = a;
        if (CalendarDialog.isOwner(a)) {
            if (this.setFormModelObject(a, handler)) {
                handler.add(new Component[]{this.show(handler)});
            } else {
                switch (type) {
                    case UPDATE_APPOINTMENT: {
                        this.updateAppointment(a);
                        break;
                    }
                    case DELETE_APPOINTMENT: {
                        this.deleteAppointment(a);
                        break;
                    }
                    case UPDATE_CALENDAR: 
                    case SYNC_CALENDAR: {
                        break;
                    }
                }
                this.calendarPanel.refresh(handler);
            }
        }
    }

    public void show(IPartialPageRequestHandler handler, DIALOG_TYPE type, OmCalendar c) {
        this.type = type;
        switch (type) {
            case UPDATE_CALENDAR: {
                this.setFormModelObject(c);
                this.setButtons(handler);
                this.show(handler);
                break;
            }
            case SYNC_CALENDAR: {
                if (this.setCalendarList(handler)) {
                    this.show(handler);
                    handler.add(new Component[]{this});
                    break;
                }
                this.calendarPanel.refresh(handler);
                break;
            }
            case UPDATE_APPOINTMENT: 
            case DELETE_APPOINTMENT: {
                break;
            }
        }
    }

    private void syncCalendar(OmCalendar c, IPartialPageRequestHandler handler) {
        HttpClient client = this.calendarPanel.getHttpClient();
        HttpClientContext context = this.calendarPanel.getHttpClientContext();
        if (this.form.username.getModelObject() != null) {
            this.apptManager.provideCredentials(context, c, (Credentials)new UsernamePasswordCredentials((String)this.form.username.getModelObject(), (String)this.form.pass.getModelObject()));
        }
        this.apptManager.syncItem(client, context, c);
        this.calendarPanel.refresh(handler);
        log.trace("Calendar {} Successfully synced.", (Object)c.getTitle());
    }

    private void deleteAppointment(Appointment a) {
        this.apptManager.deleteItem(this.calendarPanel.getHttpClient(), this.calendarPanel.getHttpClientContext(), a);
        this.appointment = null;
    }

    private void updateAppointment(Appointment a) {
        this.apptManager.updateItem(this.calendarPanel.getHttpClient(), this.calendarPanel.getHttpClientContext(), a);
        this.appointment = null;
    }

    private static boolean isOwner(Appointment object) {
        return object.getOwner() != null && WebSession.getUserId().equals(object.getOwner().getId());
    }

    private static boolean isOwner(OmCalendar object) {
        return object.getOwner() != null && WebSession.getUserId().equals(object.getOwner().getId());
    }

    private boolean setCalendarList(IPartialPageRequestHandler target) {
        this.type = DIALOG_TYPE.SYNC_CALENDAR;
        this.cals = this.apptManager.getCalendars(WebSession.getUserId());
        this.calendarPanel.getHttpClient();
        this.calIndex = 0;
        this.setButtons(target);
        return this.setFormModelObject();
    }

    private boolean setFormModelObject() {
        if (this.cals != null && !this.cals.isEmpty() && this.calIndex < this.cals.size()) {
            HttpClientContext context;
            OmCalendar calendar = this.cals.get(this.calIndex++);
            HttpClient client = this.calendarPanel.getHttpClient();
            if (!this.apptManager.testConnection(client, context = this.calendarPanel.getHttpClientContext(), calendar)) {
                this.form.setModelObject(calendar);
                this.form.url.setModelObject((Object)calendar.getHref());
                return true;
            }
            this.apptManager.syncItem(client, context, calendar);
            return this.setFormModelObject();
        }
        this.cals = null;
        return false;
    }

    private boolean setFormModelObject(Appointment a, IPartialPageRequestHandler target) {
        OmCalendar c = a.getCalendar();
        if (this.apptManager.testConnection(this.calendarPanel.getHttpClient(), this.calendarPanel.getHttpClientContext(), c)) {
            return false;
        }
        this.setFormModelObject(c);
        this.setButtons(target);
        return true;
    }

    private void setFormModelObject(OmCalendar c) {
        if (c != null) {
            this.form.setModelObject(c);
            this.form.url.setModelObject((Object)c.getHref());
            if (c.getSyncType() == OmCalendar.SyncType.GOOGLE_CALENDAR) {
                this.form.username.setDefaultModelObject((Object)c.getToken());
                this.form.gcal.setDefaultModelObject((Object)true);
            } else {
                this.form.gcal.setDefaultModelObject((Object)false);
            }
        }
    }

    public void setButtons(IPartialPageRequestHandler target) {
        switch (this.type) {
            case SYNC_CALENDAR: 
            case UPDATE_APPOINTMENT: 
            case DELETE_APPOINTMENT: {
                target.add(new Component[]{this.delete.setVisible(false), this.save.setVisible(true)});
                break;
            }
            case UPDATE_CALENDAR: {
                OmCalendar c = (OmCalendar)this.form.getModelObject();
                if (c.getId() == null) {
                    target.add(new Component[]{this.delete.setVisible(false)});
                } else {
                    target.add(new Component[]{this.delete.setVisible(CalendarDialog.isOwner(c))});
                }
                target.add(new Component[]{this.save.setVisible(CalendarDialog.isOwner(c))});
                break;
            }
        }
    }

    private void clearFormModel(IPartialPageRequestHandler handler) {
        this.form.clearInput();
        this.form.username.setModelObject(null);
        handler.add(new Component[]{this.form});
    }

    public static enum DIALOG_TYPE {
        UPDATE_CALENDAR,
        SYNC_CALENDAR,
        UPDATE_APPOINTMENT,
        DELETE_APPOINTMENT;

    }

    private class UserCalendarForm
    extends Form<OmCalendar> {
        private static final long serialVersionUID = 1L;
        private TextField<String> username;
        private PasswordTextField pass;
        RequiredTextField<String> title;
        private Label urlLabel;
        private Label userLabel;
        private Label passLabel;
        AjaxCheckBox gcal;
        UrlTextField url;

        public UserCalendarForm(String id, IModel<OmCalendar> model) {
            super(id, model);
            this.username = new TextField("login", (IModel)Model.of((Serializable)((Object)"")));
            this.pass = new PasswordTextField("password", (IModel)Model.of((Serializable)((Object)"")));
            this.title = new RequiredTextField("title");
            this.url = new UrlTextField("url", (IModel)Model.of((Serializable)((Object)"")), new UrlValidator(){
                private static final long serialVersionUID = 1L;

                public void validate(IValidatable<String> validatable) {
                    if (Boolean.FALSE.equals(UserCalendarForm.this.gcal.getModelObject())) {
                        super.validate(validatable);
                    }
                }
            }){
                private static final long serialVersionUID = 1L;

                protected String[] getInputTypes() {
                    return new String[]{"url", "text"};
                }
            };
            this.setOutputMarkupId(true);
        }

        protected void onInitialize() {
            this.urlLabel = new Label("urlLabel", (Serializable)((Object)this.getString("calendar.url")));
            this.userLabel = new Label("userLabel", (Serializable)((Object)this.getString("114")));
            this.passLabel = new Label("passLabel", (Serializable)((Object)this.getString("110")));
            this.add(new Component[]{this.title});
            this.add(new Component[]{CalendarDialog.this.feedback.setOutputMarkupId(true)});
            this.add(new Component[]{this.url.setRequired(true).setOutputMarkupId(true)});
            this.add(new Component[]{this.username.setOutputMarkupPlaceholderTag(true)});
            this.add(new Component[]{this.urlLabel.setOutputMarkupId(true)});
            this.add(new Component[]{this.pass.setRequired(false).setOutputMarkupPlaceholderTag(true)});
            this.add(new Component[]{this.userLabel.setOutputMarkupPlaceholderTag(true)});
            this.add(new Component[]{this.passLabel.setOutputMarkupPlaceholderTag(true)});
            this.gcal = new AjaxCheckBox("gcal", (IModel)Model.of((Serializable)Boolean.valueOf(false))){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    UserCalendarForm.this.setGCalVisibility((Boolean)this.getModelObject());
                    target.add(new Component[]{UserCalendarForm.this});
                }
            };
            this.add(new Component[]{this.gcal});
            super.onInitialize();
        }

        protected void onModelChanged() {
            OmCalendar calendar = (OmCalendar)this.getModelObject();
            switch (CalendarDialog.this.type) {
                case UPDATE_CALENDAR: {
                    this.title.setEnabled(true);
                    if (calendar.getId() != null) {
                        this.url.setEnabled(false);
                        this.pass.setEnabled(false);
                        this.username.setEnabled(false);
                        this.gcal.setEnabled(false);
                    } else {
                        this.gcal.setEnabled(true);
                        this.url.setEnabled(true);
                        this.pass.setEnabled(true);
                        this.username.setEnabled(true);
                    }
                    this.setGCalVisibility(calendar);
                    break;
                }
                case SYNC_CALENDAR: 
                case UPDATE_APPOINTMENT: 
                case DELETE_APPOINTMENT: {
                    this.title.setEnabled(false);
                    this.url.setEnabled(false);
                    this.username.setEnabled(true);
                    this.pass.setEnabled(true);
                    this.gcal.setEnabled(false);
                    this.setGCalVisibility(calendar);
                    break;
                }
            }
        }

        private void setGCalVisibility(OmCalendar calendar) {
            this.setGCalVisibility(calendar.getSyncType() == OmCalendar.SyncType.GOOGLE_CALENDAR);
        }

        private void setGCalVisibility(boolean isGoogleCalendar) {
            if (isGoogleCalendar) {
                this.gcal.setModelObject((Object)true);
                this.pass.setVisible(false);
                this.passLabel.setVisible(false);
                this.urlLabel.setDefaultModelObject((Object)this.getString("calendar.googleID"));
                this.url.setEnabled(true);
                this.userLabel.setDefaultModelObject((Object)this.getString("calendar.googleKey"));
                this.username.setEnabled(true);
            } else {
                this.gcal.setModelObject((Object)false);
                this.pass.setVisible(true);
                this.passLabel.setVisible(true);
                this.userLabel.setDefaultModelObject((Object)this.getString("114"));
                this.username.setModelObject(null);
                this.urlLabel.setDefaultModelObject((Object)this.getString("calendar.url"));
            }
            this.url.setLabel((IModel)Model.of((Serializable)((Object)((String)this.urlLabel.getDefaultModelObject()))));
            this.url.add(new Behavior[]{AttributeModifier.replace((String)"type", (Serializable)((Object)(Boolean.TRUE.equals(this.gcal.getModelObject()) ? "text" : "url")))});
        }

        protected void onValidate() {
            if (this.hasError()) {
                return;
            }
            switch (CalendarDialog.this.type) {
                case UPDATE_CALENDAR: {
                    if (((OmCalendar)this.getModelObject()).getId() != null || ((Boolean)this.gcal.getModelObject()).booleanValue()) {
                        return;
                    }
                }
                case SYNC_CALENDAR: 
                case UPDATE_APPOINTMENT: 
                case DELETE_APPOINTMENT: {
                    try {
                        OmCalendar calendar = (OmCalendar)this.getModelObject();
                        if (this.url.isEnabled()) {
                            calendar.setHref(this.url.getInput());
                        }
                        HttpClient client = CalendarDialog.this.calendarPanel.getHttpClient();
                        HttpClientContext context = CalendarDialog.this.calendarPanel.getHttpClientContext();
                        CalendarDialog.this.apptManager.provideCredentials(context, calendar, (Credentials)new UsernamePasswordCredentials(this.username.getInput(), this.pass.getInput()));
                        if (CalendarDialog.this.apptManager.testConnection(client, context, calendar)) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        log.error("Error executing the TestConnection", (Throwable)e);
                    }
                    this.error((Serializable)((Object)this.getString("calendar.error")));
                    break;
                }
            }
        }
    }
}

