/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.calendar;

import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.WysiwygEditor;
import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.service.calendar.caldav.AppointmentManager;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.GroupChoiceProvider;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.common.datetime.OmDateTimePicker;
import org.apache.openmeetings.web.pages.MainPage;
import org.apache.openmeetings.web.user.OmWysiwygToolbar;
import org.apache.openmeetings.web.user.calendar.CalendarDialog;
import org.apache.openmeetings.web.user.calendar.CalendarPanel;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.CalendarWebHelper;
import org.apache.openmeetings.web.util.RoomTypeDropDown;
import org.apache.openmeetings.web.util.UserMultiChoice;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.LambdaChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2MultiChoice;

public class AppointmentDialog
extends Modal<Appointment> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AppointmentDialog.class);
    private AppointmentForm form;
    private BootstrapAjaxButton save;
    private BootstrapAjaxLink<String> delete;
    private BootstrapAjaxLink<String> enterRoom;
    private final CalendarPanel calendarPanel;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final WebMarkupContainer sipContainer = new WebMarkupContainer("sip-container");
    private final RadioGroup<InviteeType> rdi = new RadioGroup("inviteeType", (IModel)Model.of((Serializable)((Object)InviteeType.USER)));
    private final Select2MultiChoice<Group> groups = new Select2MultiChoice("groups", (IModel)new CollectionModel(new ArrayList()), (ChoiceProvider)new GroupChoiceProvider());
    private final UserMultiChoice attendees = new UserMultiChoice("attendees", (IModel<Collection<User>>)new CollectionModel(new ArrayList()));
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private AppointmentDao apptDao;
    @SpringBean
    private GroupUserDao groupUserDao;
    @SpringBean
    private AppointmentManager apptManager;

    public AppointmentDialog(String id, CalendarPanel calendarPanel, CompoundPropertyModel<Appointment> model) {
        super(id, model);
        this.setMarkupId(id);
        log.debug(" -- AppointmentDialog -- Current model {}", this.getModel().getObject());
        this.calendarPanel = calendarPanel;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("815"));
        this.size(Modal.Size.Large);
        Component[] componentArray = new Component[1];
        this.form = new AppointmentForm("appForm", (IModel<Appointment>)this.getModel());
        componentArray[0] = this.form;
        this.add(componentArray);
        this.save = new BootstrapAjaxButton("button", (IModel)new ResourceModel("144"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                Appointment a = (Appointment)AppointmentDialog.this.form.getModelObject();
                a.setRoom(AppointmentDialog.this.form.createRoom ? AppointmentDialog.this.form.appRoom : (Room)AppointmentDialog.this.form.groom.getModelObject());
                List<MeetingMember> mms = a.getMeetingMembers() == null ? new ArrayList() : a.getMeetingMembers();
                HashSet<Long> currentIds = new HashSet<Long>();
                ArrayList<User> users = new ArrayList<User>();
                if (InviteeType.GROUP == AppointmentDialog.this.rdi.getModelObject()) {
                    for (Group g : (Collection)AppointmentDialog.this.groups.getModelObject()) {
                        for (GroupUser gu : AppointmentDialog.this.groupUserDao.get(g.getId().longValue(), 0L, Integer.MAX_VALUE)) {
                            User u = gu.getUser();
                            if (currentIds.contains(u.getId())) continue;
                            users.add(u);
                            currentIds.add(u.getId());
                        }
                    }
                } else {
                    users = new ArrayList((Collection)AppointmentDialog.this.attendees.getModelObject());
                    for (User u : users) {
                        if (u.getId() == null) continue;
                        currentIds.add(u.getId());
                    }
                }
                Iterator i = mms.iterator();
                while (i.hasNext()) {
                    MeetingMember m = (MeetingMember)i.next();
                    if (currentIds.contains(m.getUser().getId())) continue;
                    i.remove();
                }
                HashSet<Long> originalIds = new HashSet<Long>();
                for (MeetingMember m : mms) {
                    originalIds.add(m.getUser().getId());
                }
                for (User u : users) {
                    if (u.getId() != null && originalIds.contains(u.getId())) continue;
                    MeetingMember mm = new MeetingMember();
                    mm.setUser(u);
                    mm.setDeleted(false);
                    mm.setAppointment(a);
                    mms.add(mm);
                }
                a.setMeetingMembers(mms);
                a.setStart(CalendarWebHelper.getDate((LocalDateTime)AppointmentDialog.this.form.start.getModelObject()));
                a.setEnd(CalendarWebHelper.getDate((LocalDateTime)AppointmentDialog.this.form.end.getModelObject()));
                a.setCalendar((OmCalendar)AppointmentDialog.this.form.cals.getModelObject());
                if (a.getCalendar() != null) {
                    AppointmentDialog.this.calendarPanel.updatedeleteAppointment((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.UPDATE_APPOINTMENT, a);
                }
                AppointmentDialog.this.apptDao.update(a, WebSession.getUserId());
                target.add(new Component[]{AppointmentDialog.this.feedback});
                AppointmentDialog.this.calendarPanel.refresh((IPartialPageRequestHandler)target);
                AppointmentDialog.this.close((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{AppointmentDialog.this.feedback});
            }
        };
        this.addButton((Component)this.save);
        this.save.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.enterRoom = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Success, (IModel)new ResourceModel("lbl.enter")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget handler) {
                RoomEnterBehavior.roomEnter((MainPage)this.getPage(), (IPartialPageRequestHandler)handler, ((Appointment)AppointmentDialog.this.getModelObject()).getRoom().getId());
            }
        };
        this.addButton((Component)this.enterRoom);
        this.enterRoom.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.enterRoom.add(new Behavior[]{AttributeModifier.append((String)"data-bs-dismiss", (Serializable)((Object)"modal"))});
        this.delete = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("80")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget handler) {
                AppointmentDialog.this.deleteAppointment((IPartialPageRequestHandler)handler);
                AppointmentDialog.this.close((IPartialPageRequestHandler)handler);
            }
        };
        this.delete.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.addButton(this.delete.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))}));
        this.addButton((Component)OmModalCloseButton.of());
        super.onInitialize();
    }

    public void setModelObjectWithAjaxTarget(Appointment a, AjaxRequestTarget target) {
        this.form.setModelObject(a);
        this.form.start.setModelObject(CalendarWebHelper.getDateTime(a.getStart()));
        this.form.end.setModelObject(CalendarWebHelper.getDateTime(a.getEnd()));
        boolean isOwner = AppointmentDialog.isOwner(a);
        this.form.setEnabled(isOwner);
        log.debug(" -- setModelObjectWithAjaxTarget -- Current model {}", (Object)a);
        if (a.getId() != null) {
            this.delete.setVisible(isOwner);
            this.enterRoom.setVisible(a.getRoom() != null);
        } else {
            this.delete.setVisible(false);
            this.enterRoom.setVisible(false);
        }
        if (a.getRoom() != null) {
            this.sipContainer.replace((Component)new Label("room.confno", (Serializable)((Object)a.getRoom().getConfno()))).setVisible(a.getRoom().isSipEnabled());
        }
        this.save.setVisible(isOwner);
        target.add(new Component[]{this.form, this.delete, this.enterRoom, this.save});
        super.setModelObject((Object)a);
    }

    protected void deleteAppointment(IPartialPageRequestHandler handler) {
        Appointment a = (Appointment)this.getModelObject();
        this.apptDao.delete(a, WebSession.getUserId());
        this.calendarPanel.refresh(handler);
        if (a.getCalendar() != null && a.getHref() != null) {
            this.calendarPanel.updatedeleteAppointment(handler, CalendarDialog.DIALOG_TYPE.DELETE_APPOINTMENT, a);
        }
    }

    public static boolean isOwner(Appointment object) {
        return object.getOwner() != null && WebSession.getUserId().equals(object.getOwner().getId());
    }

    public static Room createAppRoom() {
        Room r = new Room();
        r.setAppointment(true);
        r.hide(Room.RoomElement.MICROPHONE_STATUS);
        if (r.getType() == null) {
            r.setType(Room.Type.CONFERENCE);
        }
        return r;
    }

    private static enum InviteeType {
        USER,
        GROUP;

    }

    private class AppointmentForm
    extends Form<Appointment> {
        private static final long serialVersionUID = 1L;
        private final boolean myRoomsAllowed;
        private boolean createRoom;
        private Room appRoom;
        private final OmDateTimePicker start;
        private final OmDateTimePicker end;
        private final PasswordTextField pwd;
        private final Label owner;
        private final WebMarkupContainer ownerPanel;
        private final WebMarkupContainer createRoomBlock;
        private final DropDownChoice<Room.Type> roomType;
        private final DropDownChoice<Room> groom;
        private DropDownChoice<OmCalendar> cals;
        private final WebMarkupContainer groupContainer;

        public AppointmentForm(String id, IModel<Appointment> model) {
            super(id, model);
            this.createRoom = true;
            this.appRoom = new Room();
            this.start = new OmDateTimePicker("start", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
            this.end = new OmDateTimePicker("end", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
            this.pwd = new PasswordTextField("password");
            this.owner = new Label("aowner", (IModel)Model.of((Serializable)((Object)"")));
            this.ownerPanel = new WebMarkupContainer("owner-row");
            this.createRoomBlock = new WebMarkupContainer("create-room-block", (IModel)new CompoundPropertyModel((Object)this.appRoom));
            this.roomType = new RoomTypeDropDown("type");
            this.groom = new DropDownChoice("groom", (IModel)Model.of((Serializable)new Room()), this.getRoomList(), (IChoiceRenderer)new ChoiceRenderer("name", "id"));
            this.cals = new DropDownChoice("calendar", (IModel)new LoadableDetachableModel<List<? extends OmCalendar>>(){
                private static final long serialVersionUID = 1L;

                protected List<? extends OmCalendar> load() {
                    return this.getCalendarList();
                }

                private List<OmCalendar> getCalendarList() {
                    return AppointmentDialog.this.apptManager.getCalendars(WebSession.getUserId());
                }
            }, (IChoiceRenderer)new ChoiceRenderer("title", "id"));
            this.groupContainer = new WebMarkupContainer("groupContainer");
            this.setOutputMarkupId(true);
            this.createRoom = this.myRoomsAllowed = OpenmeetingsVariables.isMyRoomsEnabled();
        }

        protected void onModelChanged() {
            super.onModelChanged();
            Appointment a = (Appointment)this.getModelObject();
            if (a.getReminder() == null) {
                a.setReminder(Appointment.Reminder.NONE);
            }
            if (a.getRoom() == null) {
                a.setRoom(AppointmentDialog.createAppRoom());
            }
            boolean bl = this.createRoom = this.myRoomsAllowed && a.getRoom().isAppointment();
            if (this.createRoom) {
                this.appRoom = a.getRoom();
            } else {
                this.groom.setModelObject((Object)a.getRoom());
                this.appRoom = AppointmentDialog.createAppRoom();
            }
            this.createRoomBlock.setDefaultModelObject((Object)this.appRoom);
            this.createRoomBlock.setEnabled(this.createRoom);
            this.groom.setEnabled(!this.createRoom);
            if (a.getId() == null) {
                Calendar from = WebSession.getCalendar();
                from.setTime(a.getStart());
                Calendar to = WebSession.getCalendar();
                to.setTime(a.getEnd());
                if (from.equals(to)) {
                    to.add(11, 1);
                    a.setEnd(to.getTime());
                }
                this.cals.setEnabled(true);
            } else {
                this.cals.setEnabled(false);
            }
            AppointmentDialog.this.rdi.setModelObject((Object)InviteeType.USER);
            AppointmentDialog.this.attendees.setModelObject(new ArrayList());
            if (a.getMeetingMembers() != null) {
                for (MeetingMember mm : a.getMeetingMembers()) {
                    ((Collection)AppointmentDialog.this.attendees.getModelObject()).add(mm.getUser());
                }
            }
            this.pwd.setEnabled(a.isPasswordProtected());
            this.owner.setDefaultModel((IModel)Model.of((Serializable)((Object)FormatHelper.formatUser((User)a.getOwner()))));
            this.ownerPanel.setVisible(!AppointmentDialog.isOwner(a));
        }

        protected void onInitialize() {
            this.add(new Component[]{AppointmentDialog.this.feedback.setOutputMarkupId(true)});
            this.add(new Component[]{this.ownerPanel.add(new Component[]{this.owner})});
            boolean showGroups = AuthLevelUtil.hasAdminLevel(WebSession.getRights()) || AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights());
            AppointmentDialog.this.groups.getSettings().setDropdownParent(AppointmentDialog.this.getMarkupId());
            this.add(new Component[]{AppointmentDialog.this.rdi.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    boolean groupsEnabled = InviteeType.GROUP == AppointmentDialog.this.rdi.getModelObject();
                    target.add(new Component[]{AppointmentDialog.this.groups.setEnabled(groupsEnabled), AppointmentDialog.this.attendees.setEnabled(!groupsEnabled)});
                }
            }})});
            this.groupContainer.add(new Component[]{AppointmentDialog.this.groups.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true), new Radio("group", (IModel)Model.of((Serializable)((Object)InviteeType.GROUP)))});
            if (showGroups) {
                AppointmentDialog.this.groups.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {})}).setEnabled(false);
            }
            AppointmentDialog.this.attendees.getSettings().setDropdownParent(AppointmentDialog.this.getMarkupId());
            AppointmentDialog.this.rdi.add(new Component[]{AppointmentDialog.this.attendees.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {})}), this.groupContainer.setVisible(showGroups)});
            AppointmentDialog.this.rdi.add(new Component[]{new Radio("user", (IModel)Model.of((Serializable)((Object)InviteeType.USER)))});
            this.add(new Component[]{new TextField("location")});
            OmWysiwygToolbar toolbar = new OmWysiwygToolbar("toolbarContainer");
            this.add(new Component[]{toolbar});
            this.add(new Component[]{new WysiwygEditor("description", (IWysiwygToolbar)toolbar)});
            this.add(new Component[]{new AjaxCheckBox("createRoom", (IModel)new PropertyModel((Object)this, "createRoom")){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    AppointmentForm.this.createRoom = (Boolean)this.getConvertedInput();
                    target.add(new Component[]{AppointmentForm.this.createRoomBlock.setEnabled(AppointmentForm.this.createRoom), AppointmentForm.this.groom.setEnabled(!AppointmentForm.this.createRoom)});
                }
            }.setVisible(this.myRoomsAllowed)});
            this.add(new Component[]{this.createRoomBlock.add(new Component[]{this.roomType, new CheckBox("moderated")}).setEnabled(this.createRoom).setVisible(this.myRoomsAllowed).setOutputMarkupId(true)});
            this.groom.setRequired(true).setEnabled(!this.createRoom).setOutputMarkupId(true);
            this.add(new Component[]{AppointmentDialog.this.sipContainer.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true)});
            AppointmentDialog.this.sipContainer.add(new Component[]{new Label("room.confno", (Serializable)((Object)""))}).setVisible(false);
            this.add(new Component[]{new DropDownChoice("reminder", List.of(Appointment.Reminder.values()), (IChoiceRenderer)new LambdaChoiceRenderer(Enum::name, (SerializableFunction & Serializable)art -> this.getString("appointment.reminder." + art.name())))});
            this.add(new Component[]{new AjaxCheckBox("passwordProtected"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    ((Appointment)AppointmentForm.this.getModelObject()).setPasswordProtected(((Boolean)this.getConvertedInput()).booleanValue());
                    AppointmentForm.this.pwd.setEnabled(((Appointment)AppointmentForm.this.getModelObject()).isPasswordProtected());
                    target.add(new Component[]{AppointmentForm.this.pwd});
                }
            }});
            this.pwd.setEnabled(((Appointment)this.getModelObject()).isPasswordProtected());
            this.pwd.setOutputMarkupId(true);
            this.add(new Component[]{this.pwd});
            this.add(new Component[]{this.cals.setNullValid(true).setLabel((IModel)Model.of((Serializable)((Object)"calendar"))).setOutputMarkupId(true)});
            AppointmentDialog.this.groups.setLabel((IModel)new ResourceModel("126"));
            this.add(new Component[]{new RequiredTextField("title").setLabel((IModel)new ResourceModel("572"))});
            this.add(new Component[]{this.start.setLabel((IModel<String>)new ResourceModel("label.start")).setRequired(true), this.end.setLabel((IModel<String>)new ResourceModel("label.end")).setRequired(true), this.groom.setLabel((IModel)new ResourceModel("406"))});
            super.onInitialize();
        }

        private List<Room> getRoomList() {
            ArrayList<Room> result = new ArrayList<Room>();
            result.addAll(AppointmentDialog.this.roomDao.getPublicRooms());
            for (GroupUser ou : AppointmentDialog.this.userDao.get(WebSession.getUserId()).getGroupUsers()) {
                result.addAll(AppointmentDialog.this.roomDao.getGroupRooms(ou.getGroup().getId().longValue()));
            }
            if (((Appointment)this.getModelObject()).getRoom() != null && ((Appointment)this.getModelObject()).getRoom().isAppointment()) {
                result.add(((Appointment)this.getModelObject()).getRoom());
            }
            return result;
        }

        protected void onValidate() {
            if (null != this.start.getConvertedInput() && null != this.end.getConvertedInput() && ((LocalDateTime)this.end.getConvertedInput()).isBefore((ChronoLocalDateTime)this.start.getConvertedInput())) {
                this.error((Serializable)((Object)this.getString("1592")));
            }
        }
    }
}

