/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user;

import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.WysiwygEditor;
import com.googlecode.wicket.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IInvitationManager;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.datetime.OmDateTimePicker;
import org.apache.openmeetings.web.user.OmWysiwygToolbar;
import org.apache.openmeetings.web.user.calendar.AppointmentDialog;
import org.apache.openmeetings.web.util.CalendarWebHelper;
import org.apache.openmeetings.web.util.RoomTypeDropDown;
import org.apache.openmeetings.web.util.UserMultiChoice;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class MessageDialog
extends Modal<PrivateMessage> {
    private static final long serialVersionUID = 1L;
    private final Form<PrivateMessage> form;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final WebMarkupContainer roomParamsBlock = new WebMarkupContainer("roomParamsBlock");
    private final WebMarkupContainer roomParams = new WebMarkupContainer("roomParams");
    private final OmDateTimePicker start = new OmDateTimePicker("start", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
    private final OmDateTimePicker end = new OmDateTimePicker("end", (IModel<LocalDateTime>)Model.of((Serializable)LocalDateTime.now()));
    private boolean isPrivate = false;
    private final IModel<Collection<User>> modelTo = new CollectionModel(new ArrayList());
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private AppointmentDao apptDao;
    @SpringBean
    private PrivateMessageDao msgDao;
    @SpringBean
    private IInvitationManager inviteManager;
    @SpringBean
    private MailHandler handler;

    public MessageDialog(String id, CompoundPropertyModel<PrivateMessage> model) {
        super(id, model);
        this.setMarkupId(id);
        this.form = new Form("form", this.getModel());
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("1209"));
        this.setUseCloseHandler(true);
        this.size(Modal.Size.Large);
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("218"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{MessageDialog.this.feedback});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                PrivateMessage m = (PrivateMessage)MessageDialog.this.getModelObject();
                m.setInserted(new Date());
                User owner = MessageDialog.this.userDao.get(WebSession.getUserId());
                if (m.isBookedRoom()) {
                    Room r = m.getRoom();
                    r.setName(m.getSubject());
                    r.setComment("");
                    r.setCapacity(100L);
                    r.setAppointment(true);
                    r.setAllowUserQuestions(true);
                    r = MessageDialog.this.roomDao.update(r, WebSession.getUserId());
                    Appointment a = new Appointment();
                    a.setTitle(m.getSubject());
                    a.setDescription(m.getMessage());
                    a.setRoom(r);
                    a.setStart(CalendarWebHelper.getDate((LocalDateTime)MessageDialog.this.start.getModelObject()));
                    a.setEnd(CalendarWebHelper.getDate((LocalDateTime)MessageDialog.this.end.getModelObject()));
                    ArrayList<MeetingMember> attendees = new ArrayList<MeetingMember>();
                    for (User to : (Collection)MessageDialog.this.modelTo.getObject()) {
                        MeetingMember mm = new MeetingMember();
                        mm.setUser(to);
                        mm.setDeleted(false);
                        mm.setAppointment(a);
                        attendees.add(mm);
                    }
                    a.setOwner(owner);
                    a.setMeetingMembers(attendees);
                    MessageDialog.this.apptDao.update(a, WebSession.getUserId(), false);
                    m.setRoom(r);
                } else {
                    m.setRoom(null);
                }
                for (User to : (Collection)MessageDialog.this.modelTo.getObject()) {
                    if (to.getId() == null) {
                        MessageDialog.this.userDao.update(to, WebSession.getUserId());
                    }
                    PrivateMessage p = new PrivateMessage(m);
                    p.setTo(to);
                    p.setFolderId(PrivateMessage.SENT_FOLDER_ID);
                    MessageDialog.this.msgDao.update(p, WebSession.getUserId());
                    p = new PrivateMessage(m);
                    p.setOwner(to);
                    p.setFolderId(PrivateMessage.INBOX_FOLDER_ID);
                    MessageDialog.this.msgDao.update(p, WebSession.getUserId());
                    if (to.getAddress() == null) continue;
                    String aLinkHTML = MessageDialog.this.isPrivate && to.getType() == User.Type.USER ? "<br/><br/><a href='" + Application.getContactsLink() + "'>" + Application.getString("1302", to.getLanguageId()) + "</a><br/>" : "";
                    Object invitationLink = "";
                    if (p.isBookedRoom()) {
                        Invitation i = MessageDialog.this.inviteManager.getInvitation(to, p.getRoom(), false, null, Invitation.Valid.PERIOD, owner, Long.valueOf(to.getLanguageId()), CalendarHelper.getDate((LocalDateTime)((LocalDateTime)MessageDialog.this.start.getModelObject()), (String)to.getTimeZoneId()), CalendarHelper.getDate((LocalDateTime)((LocalDateTime)MessageDialog.this.end.getModelObject()), (String)to.getTimeZoneId()), null);
                        invitationLink = Application.getInvitationLink(i, WebSession.get().getExtendedProperties().getBaseUrl());
                        invitationLink = invitationLink == null ? "" : "<br/>" + Application.getString("template.room.invitation.text", to.getLanguageId()) + "<br/><a href='" + (String)invitationLink + "'>" + Application.getString("504", to.getLanguageId()) + "</a><br/>";
                    }
                    String subj = p.getSubject() == null ? "" : p.getSubject();
                    MessageDialog.this.handler.send(to.getAddress().getEmail(), Application.getString("1301", to.getLanguageId()) + subj, (p.getMessage() == null ? "" : p.getMessage().replaceAll("\\<[^>]*+>", "")) + aLinkHTML + (String)invitationLink);
                }
                MessageDialog.this.close((IPartialPageRequestHandler)target);
                MessageDialog.this.onSend((IPartialPageRequestHandler)target);
            }
        });
        this.addButton((Component)OmModalCloseButton.of());
        this.form.add(new Component[]{this.feedback.setOutputMarkupId(true)});
        UserMultiChoice recepients = new UserMultiChoice("to", this.modelTo);
        recepients.getSettings().setDropdownParent(this.getMarkupId());
        this.form.add(new Component[]{recepients.setRequired(true)});
        this.form.add(new Component[]{new TextField("subject")});
        OmWysiwygToolbar toolbar = new OmWysiwygToolbar("toolbarContainer");
        this.form.add(new Component[]{toolbar});
        this.form.add(new Component[]{new WysiwygEditor("message", (IWysiwygToolbar)toolbar)});
        this.form.add(new Component[]{this.roomParamsBlock.setOutputMarkupId(true)});
        final CheckBox bookedRoom = new CheckBox("bookedRoom");
        this.form.add(new Component[]{bookedRoom.setOutputMarkupId(true).add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                PrivateMessage p;
                p.setBookedRoom(!(p = (PrivateMessage)MessageDialog.this.getModelObject()).isBookedRoom());
                MessageDialog.this.roomParams.setVisible(p.isBookedRoom());
                target.add(new Component[]{bookedRoom, MessageDialog.this.roomParamsBlock});
            }
        }})});
        bookedRoom.setVisible(OpenmeetingsVariables.isMyRoomsEnabled());
        this.roomParamsBlock.add(new Component[]{this.roomParams});
        this.roomParams.add(new Component[]{new RoomTypeDropDown("room.type")});
        this.roomParams.add(new Component[]{this.start});
        this.roomParams.add(new Component[]{this.end});
        this.add(new Component[]{this.form.setOutputMarkupId(true)});
        super.onInitialize();
    }

    public MessageDialog reset(boolean isPrivate) {
        LocalDateTime now = ZonedDateTime.now(CalendarWebHelper.getZoneId()).toLocalDateTime();
        this.start.setModelObject(now);
        this.end.setModelObject(now.plus(1L, ChronoUnit.HOURS));
        this.modelTo.setObject(new ArrayList());
        PrivateMessage p = new PrivateMessage();
        p.setFrom(this.userDao.get(WebSession.getUserId()));
        p.setOwner(p.getFrom());
        p.setIsRead(false);
        p.setFolderId(PrivateMessage.INBOX_FOLDER_ID);
        p.setRoom(AppointmentDialog.createAppRoom());
        this.setModelObject(p);
        this.roomParams.setVisible(((PrivateMessage)this.getModelObject()).isBookedRoom());
        this.form.setModelObject((Object)p);
        this.isPrivate = isPrivate;
        return this;
    }

    public void show(IPartialPageRequestHandler handler, Long userId) {
        ((PrivateMessage)this.getModelObject()).setTo(this.userDao.get(userId));
        this.show(handler);
    }

    public Modal<PrivateMessage> show(IPartialPageRequestHandler handler) {
        if (((PrivateMessage)this.getModel().getObject()).getTo() != null) {
            ((Collection)this.modelTo.getObject()).add(((PrivateMessage)this.getModel().getObject()).getTo());
        }
        handler.add(new Component[]{this.form});
        return super.show(handler);
    }

    protected void onSend(IPartialPageRequestHandler handler) {
    }

    protected void onDetach() {
        this.modelTo.detach();
        super.onDetach();
    }
}

