/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public class GroupChoiceProvider
extends ChoiceProvider<Group> {
    private static final long serialVersionUID = 1L;
    public static final long PAGE_SIZE = 5L;
    @SpringBean
    private GroupDao groupDao;
    @SpringBean
    private UserDao userDao;

    public GroupChoiceProvider() {
        Injector.get().inject((Object)this);
    }

    public void query(String term, int page, Response<Group> response) {
        long count;
        if (AuthLevelUtil.hasAdminLevel(WebSession.getRights())) {
            count = this.groupDao.count(term);
            response.addAll((Collection)this.groupDao.get(term, (long)page * 5L, 5L, null));
        } else if (AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights())) {
            response.addAll((Collection)this.groupDao.adminGet(term, WebSession.getUserId(), (long)page * 5L, 5L, null));
            count = this.groupDao.adminCount(term, WebSession.getUserId());
        } else {
            User u = this.userDao.get(WebSession.getUserId());
            for (GroupUser ou : u.getGroupUsers()) {
                if (!Strings.isEmpty((String)term) && !ou.getGroup().getName().toLowerCase(Locale.ROOT).contains(term.toLowerCase(Locale.ROOT))) continue;
                response.add((Object)ou.getGroup());
            }
            count = u.getGroupUsers().size();
        }
        response.setHasMore(Boolean.valueOf((long)page * 5L + (long)response.getResults().size() < count));
    }

    public Collection<Group> toChoices(Collection<String> ids) {
        ArrayList<Group> c = new ArrayList<Group>();
        for (String id : ids) {
            c.add(this.groupDao.get(Long.valueOf(id)));
        }
        return c;
    }

    public String getDisplayValue(Group choice) {
        return choice.getName();
    }

    public String getIdValue(Group choice) {
        Long id = choice.getId();
        return id == null ? null : "" + id;
    }
}

