/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusDisplayConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusIconConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusLocalizationConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusRestrictionsConfig;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class TempusDominusConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final IKey<Boolean> AllowInputToggle = TempusDominusConfig.newKey((String)"allowInputToggle", (Object)false);
    private static final IKey<Json.RawValue> Container = TempusDominusConfig.newKey((String)"container", null);
    private static final IKey<Boolean> DateRange = TempusDominusConfig.newKey((String)"dateRange", (Object)false);
    private static final IKey<Json.RawValue> DefaultDate = TempusDominusConfig.newKey((String)"defaultDate", null);
    private static final IKey<TempusDominusDisplayConfig> Display = TempusDominusConfig.newKey((String)"display", null);
    private static final IKey<Boolean> KeepInvalid = TempusDominusConfig.newKey((String)"keepInvalid", (Object)false);
    private static final IKey<Map<String, Object>> Meta = TempusDominusConfig.newKey((String)"meta", null);
    private static final IKey<Boolean> MultipleDates = TempusDominusConfig.newKey((String)"multipleDates", (Object)false);
    private static final IKey<String> MultipleDatesSeparator = TempusDominusConfig.newKey((String)"multipleDatesSeparator", null);
    private static final IKey<Boolean> PromptTimeOnDateChange = TempusDominusConfig.newKey((String)"promptTimeOnDateChange", (Object)false);
    private static final IKey<Integer> PromptTimeOnDateChangeTransitionDelay = TempusDominusConfig.newKey((String)"promptTimeOnDateChangeTransitionDelay", null);
    private static final IKey<TempusDominusRestrictionsConfig> Restrictions = TempusDominusConfig.newKey((String)"restrictions", null);
    private static final IKey<Integer> Stepping = TempusDominusConfig.newKey((String)"stepping", null);
    private static final IKey<Boolean> UseCurrent = TempusDominusConfig.newKey((String)"useCurrent", (Object)true);
    private static final IKey<Json.RawValue> ViewDate = TempusDominusConfig.newKey((String)"viewDate", null);
    private TempusDominusLocalizationConfig localization = new TempusDominusLocalizationConfig();

    public TempusDominusConfig() {
        this.put(Display, (Object)new TempusDominusDisplayConfig());
        this.put(Restrictions, (Object)new TempusDominusRestrictionsConfig());
    }

    public <T extends Temporal> TempusDominusConfig withClass(Class<T> clazz) {
        this.withDisplay(cfg -> cfg.withClass(clazz));
        this.withLocalization(cfg -> cfg.withClass(clazz));
        return this;
    }

    public TempusDominusConfig withAllowInputToggle(boolean allow) {
        this.put(AllowInputToggle, allow);
        return this;
    }

    public TempusDominusConfig withContainer(String container) {
        this.put(Container, new Json.RawValue(container));
        return this;
    }

    public TempusDominusConfig withDateRange(boolean dateRange) {
        this.put(DateRange, dateRange);
        return this;
    }

    public <T extends Temporal> TempusDominusConfig withDefaultDate(T defDate) {
        this.put(DefaultDate, TempusDominusConfig.createJsDate(defDate));
        return this;
    }

    public TempusDominusConfig withDefaultDate(Date defDate) {
        this.put(DefaultDate, TempusDominusConfig.createJsDate(defDate));
        return this;
    }

    public TempusDominusConfig withDisplay(Consumer<TempusDominusDisplayConfig> cfgUpdater) {
        cfgUpdater.accept((TempusDominusDisplayConfig)((Object)this.get(Display)));
        return this;
    }

    public TempusDominusConfig withIcons(Consumer<TempusDominusIconConfig> cfgUpdater) {
        ((TempusDominusDisplayConfig)((Object)this.get(Display))).withIcons(cfgUpdater);
        return this;
    }

    public TempusDominusConfig withKeepInvalid(boolean keep) {
        this.put(KeepInvalid, keep);
        return this;
    }

    public TempusDominusConfig withLocalization(Consumer<TempusDominusLocalizationConfig> cfgUpdater) {
        cfgUpdater.accept(this.localization);
        return this;
    }

    public TempusDominusConfig withMeta(Map<String, Object> map) {
        this.put(Meta, map);
        return this;
    }

    public TempusDominusConfig withMultipleDates(boolean multiple) {
        this.put(MultipleDates, multiple);
        return this;
    }

    public TempusDominusConfig withMultipleDatesSeparator(String separator) {
        this.put(MultipleDatesSeparator, separator);
        return this;
    }

    public TempusDominusConfig withPromptTimeOnDateChange(boolean prompt) {
        this.put(PromptTimeOnDateChange, prompt);
        return this;
    }

    public TempusDominusConfig withPromptTimeOnDateChangeTransitionDelay(int delay) {
        this.put(PromptTimeOnDateChangeTransitionDelay, delay);
        return this;
    }

    public TempusDominusConfig withRestrictions(Consumer<TempusDominusRestrictionsConfig> cfgUpdater) {
        cfgUpdater.accept((TempusDominusRestrictionsConfig)((Object)this.get(Restrictions)));
        return this;
    }

    public TempusDominusConfig withStepping(int step) {
        this.put(Stepping, step);
        return this;
    }

    public TempusDominusConfig withUseCurrent(boolean use) {
        this.put(UseCurrent, use);
        return this;
    }

    public <T extends Temporal> TempusDominusConfig withViewDate(T date) {
        this.put(ViewDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public TempusDominusConfig withViewDate(Date date) {
        this.put(ViewDate, TempusDominusConfig.createJsDate(date));
        return this;
    }

    public String getFormat() {
        return this.localization.getFormat();
    }

    public Locale getLocale() {
        return this.localization.getLocale();
    }

    TempusDominusLocalizationConfig getLocalization() {
        return this.localization;
    }

    public static <U> String formatDateISO(U date) {
        String strDate = null;
        if (date instanceof Date) {
            strDate = DateTimeFormatter.ISO_INSTANT.format(((Date)date).toInstant());
        } else if (date instanceof LocalTime) {
            strDate = DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)date);
        } else if (date instanceof LocalDate) {
            strDate = DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)date);
        } else if (date instanceof LocalDateTime) {
            strDate = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)date);
        } else if (date instanceof ZonedDateTime) {
            strDate = DateTimeFormatter.ISO_ZONED_DATE_TIME.format((ZonedDateTime)date);
        } else if (date instanceof String) {
            strDate = (String)date;
        }
        return strDate;
    }

    static <U> Json.RawValue createJsDate(U date) {
        String strDate = TempusDominusConfig.formatDateISO(date);
        return strDate == null ? null : new Json.RawValue("new Date('" + strDate + "')");
    }
}

