/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.wicket.util.string.Strings;
import org.slf4j.LoggerFactory;

public class OMContextListener
implements ServletContextListener {
    private static final String LOG_DIR_PROP = "current_openmeetings_log_dir";
    private static final String CTX_NAME_PROP = "current_openmeetings_context_name";

    public void contextInitialized(ServletContextEvent event) {
        String ctx = OMContextListener.pathToName(event);
        System.setProperty(CTX_NAME_PROP, ctx);
        if (Strings.isEmpty((String)System.getProperty(LOG_DIR_PROP))) {
            System.setProperty(LOG_DIR_PROP, "logs");
        }
        System.setProperty("webapp.contextPath", String.format("/%s", ctx));
        try {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            this.tryConfigure(configurator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tryConfigure(JoranConfigurator configurator) throws JoranException, IOException {
        InputStream cfgIs2;
        boolean configured = false;
        try {
            cfgIs2 = this.getClass().getResourceAsStream("/logback-test.xml");
            try {
                if (cfgIs2 != null) {
                    configurator.doConfigure(cfgIs2);
                    configured = true;
                }
            }
            finally {
                if (cfgIs2 != null) {
                    cfgIs2.close();
                }
            }
        }
        catch (Exception cfgIs2) {
            // empty catch block
        }
        if (!configured) {
            cfgIs2 = this.getClass().getResourceAsStream("/logback-config.xml");
            try {
                configurator.doConfigure(cfgIs2);
            }
            finally {
                if (cfgIs2 != null) {
                    cfgIs2.close();
                }
            }
        }
    }

    private static String pathToName(ServletContextEvent event) {
        String contextName = event.getServletContext().getContextPath().replace("/", "");
        if ("".equals(contextName)) {
            contextName = "root";
        }
        return contextName;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

