/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy.cglib;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.apache.wicket.Application;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.proxy.IProxyFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.proxy.objenesis.IInstantiator;

public class CglibProxyFactory
implements IProxyFactory {
    private static final int CGLIB_CALLBACK_NO_OVERRIDE = 0;
    private static final int CGLIB_CALLBACK_HANDLER = 1;
    private static final IInstantiator INSTANTIATOR = IInstantiator.getInstantiator();

    @Override
    public <T> T createProxy(Class<T> type, IProxyTargetLocator locator) {
        LazyInitProxyFactory.CGLibInterceptor handler = new LazyInitProxyFactory.CGLibInterceptor(type, locator);
        Callback[] callbacks = new Callback[]{SerializableNoOpCallback.INSTANCE, handler};
        Enhancer e = new Enhancer();
        e.setClassLoader(CglibProxyFactory.resolveClassLoader());
        e.setInterfaces(new Class[]{Serializable.class, ILazyInitProxy.class, LazyInitProxyFactory.IWriteReplace.class});
        e.setSuperclass(type);
        e.setCallbackFilter(NoOpForProtectedMethodsCGLibCallbackFilter.INSTANCE);
        e.setNamingPolicy((NamingPolicy)WicketNamingPolicy.INSTANCE);
        if (!CglibProxyFactory.hasNoArgConstructor(type)) {
            e.setCallbackTypes(new Class[]{callbacks[0].getClass(), callbacks[1].getClass()});
            Object instance = INSTANTIATOR.newInstance(e.createClass());
            ((Factory)instance).setCallbacks(callbacks);
            return instance;
        }
        e.setCallbacks(callbacks);
        return (T)e.create();
    }

    private static ClassLoader resolveClassLoader() {
        ClassLoader classLoader = null;
        if (Application.exists()) {
            classLoader = Application.get().getApplicationSettings().getClassResolver().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static boolean hasNoArgConstructor(Class<?> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static class SerializableNoOpCallback
    implements NoOp,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final NoOp INSTANCE = new SerializableNoOpCallback();

        private SerializableNoOpCallback() {
        }
    }

    private static class NoOpForProtectedMethodsCGLibCallbackFilter
    implements CallbackFilter {
        private static final CallbackFilter INSTANCE = new NoOpForProtectedMethodsCGLibCallbackFilter();

        private NoOpForProtectedMethodsCGLibCallbackFilter() {
        }

        public int accept(Method method) {
            if (Modifier.isProtected(method.getModifiers())) {
                return 0;
            }
            return 1;
        }
    }

    private static class WicketNamingPolicy
    extends DefaultNamingPolicy {
        public static final WicketNamingPolicy INSTANCE = new WicketNamingPolicy();

        private WicketNamingPolicy() {
        }

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            int lastIdxOfDot = prefix.lastIndexOf(46);
            String packageName = prefix.substring(0, lastIdxOfDot);
            String className = prefix.substring(lastIdxOfDot + 1);
            String newPrefix = packageName + ".Wicket_Proxy_" + className;
            return super.getClassName(newPrefix, source, key, names);
        }
    }
}

