/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.calendar.AppointmentDTO;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.mapper.CalendarMapper;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.InternalServiceException;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.AppointmentDTOListWrapper;
import org.apache.openmeetings.webservice.schema.AppointmentDTOWrapper;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="calendarWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.CalendarWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="CalendarService")
@Path(value="/calendar")
public class CalendarWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(CalendarWebService.class);
    @Autowired
    private AppointmentDao dao;
    @Autowired
    private CalendarMapper calMapper;

    @GET
    @Path(value="/{start}/{end}")
    @Operation(description="Load appointments by a start / end range for the current SID", responses={@ApiResponse(responseCode="200", description="list of appointments in range", content={@Content(schema=@Schema(implementation=AppointmentDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<AppointmentDTO> range(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="start time") @PathParam(value="start") @WebParam(name="start") Calendar start, @Parameter(required=true, description="end time") @PathParam(value="end") @WebParam(name="end") Calendar end) throws ServiceException {
        log.debug("range : startdate - {} , enddate - {}", (Object)start.getTime(), (Object)end.getTime());
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> AppointmentDTO.list((List)this.dao.getInRange(sd.getUserId(), start.getTime(), end.getTime())));
    }

    @GET
    @Path(value="/{userid}/{start}/{end}")
    @Operation(description="Load appointments by a start / end range for the userId", responses={@ApiResponse(responseCode="200", description="list of appointments in range", content={@Content(schema=@Schema(implementation=AppointmentDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<AppointmentDTO> rangeForUser(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the userId the calendar events should be loaded") @PathParam(value="userid") @WebParam(name="userid") long userid, @Parameter(required=true, description="start time") @PathParam(value="start") @WebParam(name="start") Calendar start, @Parameter(required=true, description="end time") @PathParam(value="end") @WebParam(name="end") Calendar end) throws ServiceException {
        log.debug("rangeForUser : startdate - {} , enddate - {}", (Object)start.getTime(), (Object)end.getTime());
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> AppointmentDTO.list((List)this.dao.getInRange(Long.valueOf(userid), start.getTime(), end.getTime())));
    }

    @GET
    @Path(value="/next")
    @Operation(description="Get the next Calendar event for the current USER of the SID", responses={@ApiResponse(responseCode="200", description="next Calendar event", content={@Content(schema=@Schema(implementation=AppointmentDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public AppointmentDTO next(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid) throws ServiceException {
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> {
            Appointment a = this.dao.getNext(sd.getUserId(), new Date());
            return a == null ? null : new AppointmentDTO(a);
        });
    }

    @GET
    @Path(value="/next/{userid}")
    @Operation(description="Get the next Calendar event for userId", responses={@ApiResponse(responseCode="200", description="next Calendar event", content={@Content(schema=@Schema(implementation=AppointmentDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public AppointmentDTO nextForUser(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the userId the calendar events should be loaded") @PathParam(value="userid") @WebParam(name="userid") long userid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Appointment a = this.dao.getNext(Long.valueOf(userid), new Date());
            return a == null ? null : new AppointmentDTO(a);
        });
    }

    @GET
    @Path(value="/room/{roomid}")
    @Operation(description="Load a calendar event by its room id", responses={@ApiResponse(responseCode="200", description="calendar event by its room id", content={@Content(schema=@Schema(implementation=AppointmentDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public AppointmentDTO getByRoom(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="id of appointment special room") @PathParam(value="roomid") @WebParam(name="roomid") long roomid) throws ServiceException {
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> {
            Appointment a = this.dao.getByRoom(sd.getUserId(), Long.valueOf(roomid));
            return a == null ? null : new AppointmentDTO(a);
        });
    }

    @GET
    @Path(value="/title/{title}")
    @Operation(description="Search a calendar event for the current SID", responses={@ApiResponse(responseCode="200", description="calendar event list", content={@Content(schema=@Schema(implementation=AppointmentDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<AppointmentDTO> getByTitle(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the search string") @PathParam(value="title") @WebParam(name="title") String title) throws ServiceException {
        return this.performCall(sid, User.Right.ROOM, (Sessiondata sd) -> AppointmentDTO.list((List)this.dao.searchByTitle(sd.getUserId(), title)));
    }

    @WebMethod
    @POST
    @Path(value="/")
    @Operation(description="Create an appointment", responses={@ApiResponse(responseCode="200", description="appointment saved", content={@Content(schema=@Schema(implementation=AppointmentDTOWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public AppointmentDTO save(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="calendar event") @FormParam(value="appointment") @WebParam(name="appointment") AppointmentDTO appointment) throws ServiceException {
        log.debug("save SID: {}", (Object)sid);
        return this.performCall(sid, (Sessiondata sd) -> {
            User u = this.userDao.get(sd.getUserId());
            if (!AuthLevelUtil.hasUserLevel((Set)u.getRights())) {
                log.error("save: not authorized");
                return false;
            }
            return AuthLevelUtil.hasWebServiceLevel((Set)u.getRights()) || appointment.getOwner() == null || appointment.getOwner().getId().equals(u.getId());
        }, (Sessiondata sd) -> {
            User u = this.userDao.get(sd.getUserId());
            Appointment a = this.calMapper.get(appointment, u);
            if (a.getRoom().getId() != null) {
                if (a.getRoom().isAppointment()) {
                    a.getRoom().setIspublic(false);
                } else {
                    a.setRoom(this.roomDao.get(a.getRoom().getId()));
                }
            }
            return new AppointmentDTO(this.dao.update(a, u.getId()));
        });
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(description="Delete a calendar event\n\n If the given sid is from an Administrator or Web-Service USER, the USER\n can delete any appointment.\n If the sid is assigned to a regular USER, he can only delete appointments\n where he is also the owner/creator of the appointment", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the id to delete") @PathParam(value="id") @WebParam(name="id") Long id) throws ServiceException {
        Appointment a = this.dao.get(id);
        return this.performCall(sid, (Sessiondata sd) -> {
            Set<User.Right> rights = this.getRights(sd.getUserId());
            if (AuthLevelUtil.hasWebServiceLevel(rights) || AuthLevelUtil.hasAdminLevel(rights)) {
                return true;
            }
            return AuthLevelUtil.hasUserLevel(rights) && a.isOwner(sd.getUserId());
        }, (Sessiondata sd) -> {
            if (a == null) {
                throw new InternalServiceException("Bad id");
            }
            this.dao.delete(a, sd.getUserId());
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }
}

