/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.notifier;

import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.apache.openmeetings.core.notifier.INotifier;
import org.apache.openmeetings.core.notifier.NotifierService;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IInvitationManager;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.service.mail.template.subject.AppointmentReminderTemplate;
import org.apache.openmeetings.service.mail.template.subject.SubjectEmailTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailNotifier
implements INotifier {
    @Autowired
    private NotifierService notifier;
    @Autowired
    private IInvitationManager invitationManager;

    @PostConstruct
    private void register() {
        this.notifier.addNotifier((INotifier)this);
    }

    public void notify(User u, Appointment a, Invitation inv) throws Exception {
        TimeZone tz = TimezoneUtil.getTimeZone((User)u);
        SubjectEmailTemplate t = AppointmentReminderTemplate.get(u, a, tz);
        this.invitationManager.sendInvitationLink(inv, Invitation.MessageType.CREATE, t.getSubject(), t.getEmail(), false, null);
    }
}

