/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.mail.template.subject;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.service.mail.template.OmTextLabel;
import org.apache.openmeetings.service.mail.template.subject.SubjectEmailTemplate;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RecordingExpiringTemplate
extends SubjectEmailTemplate {
    private static final long serialVersionUID = 1L;
    private final Recording rec;
    private long remainingDays;
    private final User u;
    @SpringBean
    protected RoomDao roomDao;

    private RecordingExpiringTemplate(User u, Recording rec, long remainingDays) {
        super(LocaleHelper.getLocale((User)u));
        this.u = u;
        this.rec = rec;
        this.remainingDays = remainingDays;
    }

    public static SubjectEmailTemplate get(User u, Recording rec, long remainingDays) {
        ApplicationHelper.ensureApplication((Long)u.getLanguageId());
        return new RecordingExpiringTemplate(u, rec, remainingDays).create();
    }

    protected void onInitialize() {
        super.onInitialize();
        String app = OpenmeetingsVariables.getApplicationName();
        this.add(new Component[]{new Label("greetings", (Serializable)((Object)this.getString("template.recording.expiring.greetings", this.locale, this.u.getFirstname())))});
        this.add(new Component[]{new Label("body", (Serializable)((Object)this.getString("template.recording.expiring.body", this.locale, app, String.valueOf(this.remainingDays))))});
        this.add(new Component[]{new Label("footer", (Serializable)((Object)this.getString("template.recording.expiring.footer", this.locale, app))).setEscapeModelStrings(false)});
    }

    @Override
    Fragment getSubjectFragment() {
        Fragment f = new Fragment("container", "subject", (MarkupContainer)this);
        Room room = this.roomDao.get(this.rec.getRoomId());
        f.add(new Component[]{new OmTextLabel("prefix", this.getString("template.recording.expiring.subj.prefix", this.locale, new String[0])), new OmTextLabel("room", room == null ? null : this.getString("template.recording.expiring.subj.room", this.locale, room.getName())).setVisible(room != null)});
        return f;
    }
}

