/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static void compactOrClear(ByteBuffer bb) {
        if (bb.hasRemaining()) {
            bb.compact();
        } else {
            BufferUtil.upcast(bb).clear();
        }
    }

    public static Buffer upcast(Buffer buf) {
        return buf;
    }

    public static void put(ByteBuffer dst, ByteBuffer src) {
        if (src.remaining() <= dst.remaining()) {
            dst.put(src);
        } else {
            int srcOldLimit = src.limit();
            BufferUtil.upcast(src).limit(src.position() + dst.remaining());
            dst.put(src);
            BufferUtil.upcast(src).limit(srcOldLimit);
        }
    }
}

