/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.ldap;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.CursorLdapReferralException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.openmeetings.core.converter.ImageConverter;
import org.apache.openmeetings.core.ldap.LdapOptions;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.StoredFile;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LdapLoginManager {
    private static final Logger log = LoggerFactory.getLogger(LdapLoginManager.class);
    private static final String WARN_REFERRAL = "Referral LDAP entry found, ignore it";
    private static final String CONFIGKEY_LDAP_KEY_LOGIN = "ldap_user_attr_login";
    private static final String CONFIGKEY_LDAP_KEY_LASTNAME = "ldap_user_attr_lastname";
    private static final String CONFIGKEY_LDAP_KEY_FIRSTNAME = "ldap_user_attr_firstname";
    private static final String CONFIGKEY_LDAP_KEY_MAIL = "ldap_user_attr_mail";
    private static final String CONFIGKEY_LDAP_KEY_STREET = "ldap_user_attr_street";
    private static final String CONFIGKEY_LDAP_KEY_ADDITIONAL_NAME = "ldap_user_attr_additionalname";
    private static final String CONFIGKEY_LDAP_KEY_FAX = "ldap_user_attr_fax";
    private static final String CONFIGKEY_LDAP_KEY_ZIP = "ldap_user_attr_zip";
    private static final String CONFIGKEY_LDAP_KEY_COUNTRY = "ldap_user_attr_country";
    private static final String CONFIGKEY_LDAP_KEY_TOWN = "ldap_user_attr_town";
    private static final String CONFIGKEY_LDAP_KEY_PHONE = "ldap_user_attr_phone";
    private static final String CONFIGKEY_LDAP_KEY_GROUP = "ldap_group_attr";
    public static final String CONFIGKEY_LDAP_KEY_PICTURE = "ldap_user_attr_picture";
    private static final String LDAP_KEY_LOGIN = "uid";
    private static final String LDAP_KEY_LASTNAME = "sn";
    private static final String LDAP_KEY_FIRSTNAME = "givenName";
    private static final String LDAP_KEY_MAIL = "mail";
    private static final String LDAP_KEY_STREET = "streetAddress";
    private static final String LDAP_KEY_ADDITIONAL_NAME = "description";
    private static final String LDAP_KEY_FAX = "facsimileTelephoneNumber";
    private static final String LDAP_KEY_ZIP = "postalCode";
    private static final String LDAP_KEY_COUNTRY = "co";
    private static final String LDAP_KEY_TOWN = "l";
    private static final String LDAP_KEY_PHONE = "telephoneNumber";
    private static final String LDAP_KEY_TIMEZONE = "timezone";
    private static final String LDAP_KEY_GROUP = "memberOf";
    @Autowired
    private LdapConfigDao ldapConfigDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private ImageConverter imageConverter;

    private static void bindAdmin(LdapConnection conn, LdapOptions options) throws LdapException {
        if (!Strings.isEmpty((String)options.adminDn)) {
            conn.bind(options.adminDn, options.adminPasswd);
        } else {
            conn.bind();
        }
    }

    private static Attribute getAttr(Properties config, Entry entry, String aliasCode, String defaultAlias) {
        String alias = config.getProperty(aliasCode, "");
        if (Strings.isEmpty((String)alias)) {
            alias = defaultAlias;
        }
        return Strings.isEmpty((String)alias) ? null : entry.get(alias);
    }

    private static String getStringAttr(Properties config, Entry entry, String aliasCode, String defaultAlias) throws LdapInvalidAttributeValueException {
        Attribute a = LdapLoginManager.getAttr(config, entry, aliasCode, defaultAlias);
        return a == null ? null : a.getString();
    }

    private static String getLogin(Properties config, Entry entry) throws LdapInvalidAttributeValueException {
        return LdapLoginManager.getStringAttr(config, entry, CONFIGKEY_LDAP_KEY_LOGIN, LDAP_KEY_LOGIN);
    }

    private User doLogin(LdapWorker w, String login, String passwd, Long domainId) throws Exception {
        User u = null;
        boolean authenticated = true;
        Dn userDn = null;
        Entry entry = null;
        switch (w.options.type) {
            case SEARCHANDBIND: {
                Map.Entry<Dn, Entry> search = LdapLoginManager.searchAndBind(w, login, passwd);
                userDn = search.getKey();
                entry = search.getValue();
                break;
            }
            case SIMPLEBIND: {
                userDn = new Dn(new String[]{String.format(w.options.userDn, login)});
                w.conn.bind(userDn, passwd);
                break;
            }
            default: {
                authenticated = false;
            }
        }
        u = authenticated ? this.userDao.getByLogin(login, User.Type.LDAP, domainId) : this.userDao.login(login, passwd);
        log.debug("getByLogin:: authenticated ? {}, login = '{}', domain = {}, user = {}", new Object[]{authenticated, login, domainId, u});
        if (u == null && Provisionning.AUTOCREATE != w.options.prov) {
            log.error("User not found in OM DB and Provisionning.AUTOCREATE was not set");
            throw OmException.BAD_CREDENTIALS;
        }
        if (authenticated && entry == null) {
            if (w.options.useAdminForAttrs) {
                LdapLoginManager.bindAdmin(w.conn, w.options);
            }
            entry = w.conn.lookup(userDn);
        }
        switch (w.options.prov) {
            case AUTOUPDATE: 
            case AUTOCREATE: {
                u = w.getUser(entry, u);
                if (w.options.syncPasswd) {
                    u.updatePassword(passwd);
                }
                u = this.userDao.update(u, null);
                u = w.setUserPicture(entry, u);
                break;
            }
        }
        return u;
    }

    public User login(String inLogin, String passwd, Long domainId) throws OmException {
        log.debug("LdapLoginmanager.doLdapLogin");
        if (!this.userDao.validLogin(inLogin)) {
            log.error("Invalid login provided");
            return null;
        }
        User u = null;
        try (LdapWorker w = new LdapWorker(domainId);){
            String login = w.options.useLowerCase ? inLogin.toLowerCase(Locale.ROOT) : inLogin;
            u = this.doLogin(w, login, passwd, domainId);
        }
        catch (LdapAuthenticationException ae) {
            log.error("Not authenticated.", (Throwable)ae);
            throw OmException.BAD_CREDENTIALS;
        }
        catch (OmException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new OmException((Throwable)e);
        }
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map.Entry<Dn, Entry> searchAndBind(LdapWorker w, String login, String passwd) throws LdapException, CursorException, OmException, IOException {
        Dn userDn = null;
        Entry entry = null;
        LdapLoginManager.bindAdmin(w.conn, w.options);
        Dn baseDn = new Dn(new String[]{w.options.searchBase});
        String searchQ = String.format(w.options.searchQuery, login);
        try (EntryCursorImpl cursor = new EntryCursorImpl(w.conn.search(new SearchRequestImpl().setBase(baseDn).setFilter(searchQ).setScope(w.options.scope).addAttributes(new String[]{"*"}).setDerefAliases(w.options.derefMode)));){
            while (cursor.next()) {
                try {
                    Entry e = (Entry)cursor.get();
                    if (userDn != null) {
                        log.error("more than 1 user found in LDAP");
                        throw OmException.UNKNOWN;
                    }
                    userDn = e.getDn();
                    if (!w.options.useAdminForAttrs) continue;
                    entry = e;
                }
                catch (CursorLdapReferralException cle) {
                    log.warn(WARN_REFERRAL);
                }
            }
        }
        if (userDn == null) {
            log.error("NONE users found in LDAP");
            throw OmException.BAD_CREDENTIALS;
        }
        w.conn.bind(userDn, passwd);
        return new AbstractMap.SimpleEntry<Dn, Object>(userDn, entry);
    }

    public void importUsers(Long domainId, boolean print) throws OmException {
        try (LdapWorker w = new LdapWorker(domainId);){
            LdapLoginManager.bindAdmin(w.conn, w.options);
            Dn baseDn = new Dn(new String[]{w.options.searchBase});
            try (EntryCursorImpl cursor = new EntryCursorImpl(w.conn.search(new SearchRequestImpl().setBase(baseDn).setFilter(w.options.importQuery).setScope(w.options.scope).addAttributes(new String[]{"*"}).setDerefAliases(w.options.derefMode)));){
                this.importUsers(w, (EntryCursor)cursor, domainId, print);
            }
        }
        catch (LdapAuthenticationException ae) {
            log.error("Not authenticated.", (Throwable)ae);
            throw OmException.BAD_CREDENTIALS;
        }
        catch (OmException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new OmException((Throwable)e);
        }
    }

    private void importUsers(LdapWorker w, EntryCursor cursor, Long domainId, boolean print) throws LdapException, CursorException, OmException, IOException {
        while (cursor.next()) {
            try {
                Entry e = (Entry)cursor.get();
                User u = this.userDao.getByLogin(LdapLoginManager.getLogin(w.config, e), User.Type.LDAP, domainId);
                u = w.getUser(e, u);
                if (print) {
                    log.info("Going to import user: {}", (Object)u);
                    continue;
                }
                this.userDao.update(u, null);
                log.info("User {}, was imported", (Object)u);
            }
            catch (CursorLdapReferralException cle) {
                log.warn(WARN_REFERRAL);
            }
        }
    }

    private class LdapWorker
    implements Closeable {
        final LdapConnection conn;
        final Properties config = new Properties();
        final LdapOptions options;
        final Long domainId;
        final LdapConfig ldapCfg;

        public LdapWorker(Long domainId) {
            this.domainId = domainId;
            this.ldapCfg = LdapLoginManager.this.ldapConfigDao.get(domainId);
            OmFileHelper.loadLdapConf((String)this.ldapCfg.getConfigFileName(), (Properties)this.config);
            this.options = new LdapOptions(this.config);
            this.conn = new LdapNetworkConnection(this.options.host, this.options.port, this.options.secure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private User updatePic(User inUser, InputStream is, StoredFile sf) {
            User u = inUser;
            Path tempImage = null;
            try {
                tempImage = Files.createTempFile("omLdap", "img", new FileAttribute[0]);
                FileUtils.copyToFile((InputStream)is, (File)tempImage.toFile());
                LdapLoginManager.this.imageConverter.convertImageUserProfile(tempImage.toFile(), inUser.getId());
                u = LdapLoginManager.this.userDao.get(inUser.getId());
            }
            catch (Exception e) {
                log.error("Unable to store binary image from LDAP", (Throwable)e);
            }
            finally {
                if (tempImage != null) {
                    try {
                        Files.deleteIfExists(tempImage);
                    }
                    catch (IOException e) {
                        log.error("Unexpected error while clean-up", (Throwable)e);
                    }
                }
            }
            return u;
        }

        public User setUserPicture(Entry entry, User inUser) {
            User user = Optional.ofNullable(LdapLoginManager.getAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_PICTURE, "")).map(Attribute::get).filter(val -> val != null && val.getBytes() != null).map(val -> {
                User u = inUser;
                ByteArrayInputStream is = new ByteArrayInputStream(val.getBytes());
                StoredFile sf = new StoredFile("picture", (InputStream)is);
                if (sf.isImage()) {
                    u = this.updatePic(inUser, is, sf);
                } else {
                    u.setPictureUri(val.getString());
                }
                return u;
            }).orElse(inUser);
            if (Strings.isEmpty((String)user.getPictureUri()) && !Strings.isEmpty((String)this.options.pictureUri)) {
                user.setPictureUri(this.options.pictureUri);
            }
            return LdapLoginManager.this.userDao.update(user, null);
        }

        private User create(Entry entry) throws LdapInvalidAttributeValueException {
            User u = UserDao.getNewUserInstance(null);
            u.setType(User.Type.LDAP);
            u.getRights().remove(User.Right.LOGIN);
            u.setDomainId(this.domainId);
            Group g = LdapLoginManager.this.groupDao.get(OpenmeetingsVariables.getDefaultGroup());
            if (g != null) {
                u.addGroup(g);
            }
            Object login = LdapLoginManager.getLogin(this.config, entry);
            if (this.ldapCfg.getAddDomainToUserName()) {
                login = (String)login + "@" + this.ldapCfg.getDomain();
            }
            if (this.options.useLowerCase) {
                login = ((String)login).toLowerCase(Locale.ROOT);
            }
            u.setLogin((String)login);
            u.setShowContactDataToContacts(true);
            u.setAddress(new Address());
            return u;
        }

        private List<Dn> getGroupDns(Entry entry, User u) throws IOException, LdapException, CursorException {
            ArrayList<Dn> groups = new ArrayList<Dn>();
            if (GroupMode.ATTRIBUTE == this.options.groupMode) {
                Attribute attr = LdapLoginManager.getAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_GROUP, LdapLoginManager.LDAP_KEY_GROUP);
                if (attr != null) {
                    for (Value v : attr) {
                        groups.add(new Dn(new String[]{v.getString()}));
                    }
                }
            } else if (GroupMode.QUERY == this.options.groupMode) {
                Dn baseDn = new Dn(new String[]{this.options.searchBase});
                String searchQ = String.format(this.options.groupQuery, u.getLogin());
                this.fillGroups(baseDn, searchQ, groups);
            }
            return groups;
        }

        public User getUser(Entry entry, User user) throws LdapException, CursorException, OmException, IOException {
            if (entry == null) {
                log.error("LDAP entry is null, search or lookup by Dn failed");
                throw OmException.BAD_CREDENTIALS;
            }
            User u = user == null ? this.create(entry) : user;
            u.setLastname(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_LASTNAME, LdapLoginManager.LDAP_KEY_LASTNAME));
            u.setFirstname(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_FIRSTNAME, LdapLoginManager.LDAP_KEY_FIRSTNAME));
            u.getAddress().setEmail(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_MAIL, LdapLoginManager.LDAP_KEY_MAIL));
            u.getAddress().setStreet(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_STREET, LdapLoginManager.LDAP_KEY_STREET));
            u.getAddress().setAdditionalname(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_ADDITIONAL_NAME, LdapLoginManager.LDAP_KEY_ADDITIONAL_NAME));
            u.getAddress().setFax(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_FAX, LdapLoginManager.LDAP_KEY_FAX));
            u.getAddress().setZip(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_ZIP, LdapLoginManager.LDAP_KEY_ZIP));
            u.getAddress().setCountry(LocaleHelper.validateCountry((String)LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_COUNTRY, LdapLoginManager.LDAP_KEY_COUNTRY)));
            u.getAddress().setTown(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_TOWN, LdapLoginManager.LDAP_KEY_TOWN));
            u.getAddress().setPhone(LdapLoginManager.getStringAttr(this.config, entry, LdapLoginManager.CONFIGKEY_LDAP_KEY_PHONE, LdapLoginManager.LDAP_KEY_PHONE));
            String tz = LdapLoginManager.getStringAttr(this.config, entry, "ldap_user_timezone", LdapLoginManager.LDAP_KEY_TIMEZONE);
            if (tz == null) {
                tz = this.options.tz;
            }
            u.setTimeZoneId(TimezoneUtil.getTimeZone((String)tz).getID());
            this.getGroupDns(entry, u).stream().map(Dn::getRdn).map(Rdn::getValue).filter(name -> !Strings.isEmpty((String)name)).forEach(name -> {
                Group o = LdapLoginManager.this.groupDao.get(name);
                boolean found = false;
                if (o == null) {
                    o = new Group();
                    o.setName(name);
                    o = LdapLoginManager.this.groupDao.update(o, u.getId());
                } else {
                    for (GroupUser ou : u.getGroupUsers()) {
                        if (!ou.getGroup().getName().equals(name)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    u.addGroup(o);
                    log.debug("Going to add user to group:: {}", name);
                }
            });
            return u;
        }

        private void fillGroups(Dn baseDn, String searchQ, List<Dn> groups) throws IOException, LdapException, CursorException {
            try (EntryCursorImpl cursor = new EntryCursorImpl(this.conn.search(new SearchRequestImpl().setBase(baseDn).setFilter(searchQ).setScope(SearchScope.SUBTREE).addAttributes(new String[]{"*"}).setDerefAliases(AliasDerefMode.DEREF_ALWAYS)));){
                while (cursor.next()) {
                    try {
                        Entry e = (Entry)cursor.get();
                        groups.add(e.getDn());
                    }
                    catch (CursorLdapReferralException cle) {
                        log.warn(LdapLoginManager.WARN_REFERRAL);
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    public static enum AuthType {
        NONE,
        SEARCHANDBIND,
        SIMPLEBIND;

    }

    public static enum Provisionning {
        NONE,
        AUTOUPDATE,
        AUTOCREATE;

    }

    public static enum GroupMode {
        NONE,
        ATTRIBUTE,
        QUERY;

    }
}

