/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.calendar;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.calendar.CalendarBehavior;
import com.googlecode.wicket.jquery.ui.calendar.CalendarModel;
import com.googlecode.wicket.jquery.ui.calendar.CalendarModelBehavior;
import com.googlecode.wicket.jquery.ui.calendar.CalendarView;
import com.googlecode.wicket.jquery.ui.calendar.EventSource;
import com.googlecode.wicket.jquery.ui.calendar.ICalendarListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public class Calendar
extends JQueryContainer
implements ICalendarListener {
    private static final long serialVersionUID = 1L;
    private List<EventSource> sources;
    private CalendarModelBehavior modelBehavior;
    protected final Options options;

    public Calendar(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public Calendar(String id, CalendarModel model) {
        this(id, model, new Options());
    }

    public Calendar(String id, CalendarModel model, Options options) {
        super(id, (IModel)model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public CalendarModel getModel() {
        return (CalendarModel)this.getDefaultModel();
    }

    public void addSource(EventSource source) {
        if (this.sources == null) {
            this.sources = Generics.newArrayList();
        }
        this.sources.add(source);
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('%s').fullCalendar('refetchEvents');", IJQueryWidget.JQueryWidget.getSelector((Component)this)));
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isDayClickEnabled() {
        return false;
    }

    @Override
    public boolean isEventClickEnabled() {
        return false;
    }

    @Override
    public boolean isEventDropEnabled() {
        return false;
    }

    @Override
    public boolean isEventResizeEnabled() {
        return false;
    }

    @Override
    public boolean isObjectDropEnabled() {
        return false;
    }

    @Override
    public boolean isViewRenderEnabled() {
        return false;
    }

    @Override
    public CharSequence getEventDropPrecondition() {
        return "";
    }

    @Override
    public CharSequence getEventResizePrecondition() {
        return "";
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newCalendarModelBehavior(this.getModel());
        this.add(new Behavior[]{this.modelBehavior});
    }

    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        StringBuilder sourceBuilder = new StringBuilder();
        sourceBuilder.append(String.format("{ url: '%s' }", this.modelBehavior.getCallbackUrl()));
        if (this.sources != null) {
            for (EventSource source : this.sources) {
                sourceBuilder.append(", ");
                sourceBuilder.append(source.toString());
            }
        }
        behavior.setOption("eventSources", (Object)String.format("[%s]", sourceBuilder.toString()));
    }

    @Override
    public void onSelect(AjaxRequestTarget target, CalendarView view, LocalDateTime start, LocalDateTime end, boolean allDay) {
    }

    @Override
    public void onDayClick(AjaxRequestTarget target, CalendarView view, LocalDateTime date, boolean allDay) {
    }

    @Override
    public void onEventClick(AjaxRequestTarget target, CalendarView view, String eventId) {
    }

    @Override
    public void onEventDrop(AjaxRequestTarget target, String eventId, long delta, boolean allDay) {
    }

    @Override
    public void onEventResize(AjaxRequestTarget target, String eventId, long delta) {
    }

    @Override
    public void onObjectDrop(AjaxRequestTarget target, String title, LocalDateTime date, boolean allDay) {
    }

    @Override
    public void onViewRender(AjaxRequestTarget target, CalendarView view, LocalDate start, LocalDate end) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new CalendarBehavior(selector, this.options, this);
    }

    protected CalendarModelBehavior newCalendarModelBehavior(CalendarModel model) {
        return new CalendarModelBehavior(model);
    }
}

