/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class BaseFileItemDao
implements IDataProviderDao<BaseFileItem> {
    private static final Logger log = LoggerFactory.getLogger(BaseFileItemDao.class);
    @PersistenceContext
    protected EntityManager em;
    @Autowired
    private RoomDao roomDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private UserDao userDao;

    public <T extends BaseFileItem> T get(String hash, Class<T> clazz) {
        return this.getAny("getFileByHash", hash, clazz);
    }

    public <T extends BaseFileItem> T getAny(String hash, Class<T> clazz) {
        return this.getAny("getAnyFileByHash", hash, clazz);
    }

    @Override
    public BaseFileItem get(Long id) {
        return this.getBase(id);
    }

    public BaseFileItem getBase(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        return (BaseFileItem)DaoHelper.single(this.em.createNamedQuery("getFileById", BaseFileItem.class).setParameter("id", (Object)id).getResultList());
    }

    public BaseFileItem getAny(Long id) {
        return (BaseFileItem)DaoHelper.single(this.em.createNamedQuery("getAnyFileById", BaseFileItem.class).setParameter("id", (Object)id).getResultList());
    }

    private <T extends BaseFileItem> T getAny(String query, String hash, Class<T> clazz) {
        log.debug("getAny[{}]() started", (Object)query);
        return (T)((BaseFileItem)DaoHelper.single(this.em.createNamedQuery(query, clazz).setParameter("hash", (Object)hash).getResultList()));
    }

    public void delete(BaseFileItem f) {
        if (f == null || f.getId() == null) {
            return;
        }
        f.setDeleted(true);
        this.updateBase(f);
    }

    public BaseFileItem updateBase(BaseFileItem f) {
        User u;
        Group g;
        Room r;
        f.setExternalType(null);
        BaseFileItem parent = this.get(f.getParentId());
        if (parent != null) {
            f.setExternalType(parent.getExternalType());
        }
        if (Strings.isEmpty((String)f.getExternalType()) && (r = this.roomDao.get(f.getRoomId())) != null) {
            f.setExternalType(r.externalType());
        }
        if (Strings.isEmpty((String)f.getExternalType()) && (g = this.groupDao.get(f.getGroupId())) != null && g.isExternal()) {
            f.setExternalType(g.getName());
        }
        if (Strings.isEmpty((String)f.getExternalType()) && (u = this.userDao.get(f.getOwnerId())) != null) {
            f.setExternalType(u.externalType());
        }
        if (Strings.isEmpty((String)f.getExternalType()) && (u = this.userDao.get(f.getInsertedBy())) != null) {
            f.setExternalType(u.externalType());
        }
        if (f.getId() == null) {
            this.em.persist((Object)f);
        } else {
            f = (BaseFileItem)this.em.merge((Object)f);
        }
        return f;
    }

    @Override
    public List<BaseFileItem> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<BaseFileItem> get(String search, long start, long count, SortParam<String> order) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public BaseFileItem update(BaseFileItem entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public void delete(BaseFileItem entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }
}

