/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.backup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.backup.BackupVersion;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.calendar.MeetingMemberDao;
import org.apache.openmeetings.db.dao.calendar.OmCalendarDao;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.room.ExtraMenuDao;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageFolderDao;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.installation.ImportInitvalues;
import org.apache.openmeetings.installation.InstallationConfig;
import org.apache.openmeetings.util.OmFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackupExport {
    private static final Logger log = LoggerFactory.getLogger(BackupExport.class);
    private static final String BACKUP_COMMENT = "###############################################\n This File is auto-generated by the Backup Tool\n you should use the BackupPanel to modify or change this file\n see https://openmeetings.apache.org/Upgrade.html for Details\n ###############################################\n";
    @Autowired
    private AppointmentDao appointmentDao;
    @Autowired
    private OmCalendarDao calendarDao;
    @Autowired
    private FileItemDao fileItemDao;
    @Autowired
    private RecordingDao recordingDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private MeetingMemberDao meetingMemberDao;
    @Autowired
    private LdapConfigDao ldapConfigDao;
    @Autowired
    private PrivateMessageDao privateMessageDao;
    @Autowired
    private PrivateMessageFolderDao privateMessageFolderDao;
    @Autowired
    private UserContactDao userContactDao;
    @Autowired
    private PollDao pollManager;
    @Autowired
    private ConfigurationDao configurationDao;
    @Autowired
    private ChatDao chatDao;
    @Autowired
    private OAuth2Dao auth2Dao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private RoomDao roomDao;
    @Autowired
    private ExtraMenuDao menuDao;

    public void performExport(File zip, boolean includeFiles, AtomicInteger progress) throws Exception {
        if (zip.getParentFile() != null && !zip.getParentFile().exists()) {
            zip.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(zip);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            progress.set(0);
            BackupExport.writeList(zos, "version.xml", "version", List.of(BackupVersion.get()));
            progress.set(2);
            this.exportGroups(zos);
            progress.set(5);
            this.exportUsers(zos);
            progress.set(10);
            this.exportRoom(zos);
            progress.set(15);
            this.exportRoomGroup(zos);
            progress.set(17);
            this.exportRoomFile(zos);
            progress.set(17);
            this.exportCalendar(zos);
            progress.set(22);
            this.exportAppointment(zos);
            progress.set(25);
            this.exportMeetingMember(zos);
            progress.set(30);
            this.exportLdap(zos);
            progress.set(35);
            this.exportOauth(zos);
            progress.set(45);
            this.exportPrivateMsg(zos);
            progress.set(50);
            this.exportPrivateMsgFolder(zos);
            progress.set(55);
            this.exportContacts(zos);
            progress.set(60);
            this.exportFile(zos);
            progress.set(65);
            this.exportRecording(zos);
            progress.set(70);
            this.exportPoll(zos);
            progress.set(75);
            this.exportConfig(zos);
            progress.set(80);
            this.exportChat(zos);
            progress.set(85);
            this.exportExtraMenus(zos);
            progress.set(87);
            if (includeFiles) {
                this.exportFiles(progress, zos);
            }
        }
        progress.set(100);
        log.debug("---Done");
    }

    private void exportFiles(AtomicInteger progress, ZipOutputStream zos) throws IOException {
        for (File file : OmFileHelper.getUploadDir().listFiles()) {
            String fName = file.getName();
            if (!file.isDirectory() || "import".equals(fName) || "backup".equals(fName)) continue;
            log.debug("### {}", (Object)file.getName());
            this.writeZipDir("roomFiles", file.getParentFile().toURI(), file, zos);
        }
        File recDir = OmFileHelper.getStreamsHibernateDir();
        this.writeZipDir("recordingFiles", recDir.toURI(), recDir, zos);
        progress.set(90);
        File customCss = OmFileHelper.getCustomCss();
        if (customCss != null && customCss.exists() && customCss.isFile()) {
            BackupExport.writeZip("css", customCss.getParentFile().toURI(), customCss, zos);
        }
    }

    private void exportGroups(ZipOutputStream zos) throws Exception {
        List list = this.groupDao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "organizations.xml", "organisations", list);
    }

    private void exportUsers(ZipOutputStream zos) throws Exception {
        List list = this.userDao.getAllBackupUsers();
        BackupExport.writeList(zos, "users.xml", "users", list);
    }

    private void exportRoom(ZipOutputStream zos) throws Exception {
        List list = this.roomDao.get();
        BackupExport.writeList(zos, "rooms.xml", "rooms", list);
    }

    private void exportRoomGroup(ZipOutputStream zos) throws Exception {
        BackupExport.writeList(zos, "rooms_organisation.xml", "room_organisations", this.roomDao.getGroups());
    }

    private void exportRoomFile(ZipOutputStream zos) throws Exception {
        BackupExport.writeList(zos, "roomFiles.xml", "RoomFiles", this.roomDao.getFiles());
    }

    private void exportCalendar(ZipOutputStream zos) throws Exception {
        List list = this.calendarDao.get();
        BackupExport.writeList(zos, "calendars.xml", "calendars", list);
    }

    private void exportAppointment(ZipOutputStream zos) throws Exception {
        List list = this.appointmentDao.get();
        BackupExport.writeList(zos, "appointements.xml", "appointments", list);
    }

    private void exportMeetingMember(ZipOutputStream zos) throws Exception {
        BackupExport.writeList(zos, "meetingmembers.xml", "meetingmembers", this.meetingMemberDao.get());
    }

    private void exportLdap(ZipOutputStream zos) throws Exception {
        List ldapList = this.ldapConfigDao.get();
        if (!ldapList.isEmpty()) {
            ldapList.remove(0);
        }
        BackupExport.writeList(zos, "ldapconfigs.xml", "ldapconfigs", ldapList);
    }

    private void exportOauth(ZipOutputStream zos) throws Exception {
        List list = this.auth2Dao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "oauth2servers.xml", "oauth2servers", list);
    }

    private void exportPrivateMsg(ZipOutputStream zos) throws Exception {
        List list = this.privateMessageDao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "privateMessages.xml", "privatemessages", list);
    }

    private void exportPrivateMsgFolder(ZipOutputStream zos) throws Exception {
        BackupExport.writeList(zos, "privateMessageFolder.xml", "privatemessagefolders", this.privateMessageFolderDao.get(0L, Integer.MAX_VALUE));
    }

    private void exportContacts(ZipOutputStream zos) throws Exception {
        BackupExport.writeList(zos, "userContacts.xml", "usercontacts", this.userContactDao.get());
    }

    private void exportFile(ZipOutputStream zos) throws Exception {
        List list = this.fileItemDao.get();
        BackupExport.writeList(zos, "fileExplorerItems.xml", "fileExplorerItems", list);
    }

    private void exportRecording(ZipOutputStream zos) throws Exception {
        List list = this.recordingDao.get();
        BackupExport.writeList(zos, "flvRecordings.xml", "flvrecordings", list);
    }

    private void exportPoll(ZipOutputStream zos) throws Exception {
        List list = this.pollManager.get();
        BackupExport.writeList(zos, "roompolls.xml", "roompolls", list);
    }

    private void exportConfig(ZipOutputStream zos) throws Exception {
        List list = this.configurationDao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "configs.xml", "configs", list);
    }

    private void exportChat(ZipOutputStream zos) throws Exception {
        List list = this.chatDao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "chat_messages.xml", "chat_messages", list);
    }

    private void exportExtraMenus(ZipOutputStream zos) throws Exception {
        List list = this.menuDao.get(0L, Integer.MAX_VALUE);
        BackupExport.writeList(zos, "extraMenus.xml", "ExtraMenus", list);
    }

    static <T> ByteArrayOutputStream stream(String listElement, List<T> list) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        BackupExport.writeList(baos, listElement, list);
        return baos;
    }

    private static <T> void writeList(ZipOutputStream zos, String fileName, String listElement, List<T> list) throws Exception {
        ZipEntry e = new ZipEntry(fileName);
        zos.putNextEntry(e);
        ByteArrayOutputStream baos = BackupExport.stream(listElement, list);
        zos.write(baos.toByteArray());
        zos.closeEntry();
    }

    private static <T> void writeList(OutputStream os, String listElement, List<T> list) throws Exception {
        try (OutputStreamWriter sw = new OutputStreamWriter(os);){
            sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sw.write("<!--");
            sw.write(BACKUP_COMMENT);
            sw.write("-->\n");
            sw.write("<root>\n");
            sw.write("<" + listElement + ">\n");
            if (list != null && !list.isEmpty()) {
                Class<?> eClazz = list.get(0).getClass();
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{eClazz});
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.fragment", (Object)true);
                for (T t : list) {
                    marshaller.marshal(t, (Writer)sw);
                    sw.write("\n");
                }
            }
            sw.write("</" + listElement + ">\n");
            sw.write("</root>\n");
        }
    }

    private static void writeZip(String prefix, URI base, File file, ZipOutputStream zos) throws IOException {
        String path = prefix + "/" + base.relativize(file.toURI()).toString();
        log.debug("Writing '{}' to zip file", (Object)path);
        ZipEntry zipEntry = new ZipEntry(path);
        zos.putNextEntry(zipEntry);
        FileUtils.copyFile((File)file, (OutputStream)zos);
        zos.closeEntry();
    }

    private void writeZipDir(String prefix, URI base, File dir, ZipOutputStream zos) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.writeZipDir(prefix, base, file, zos);
                continue;
            }
            BackupExport.writeZip(prefix, base, file, zos);
        }
    }

    public static void main(String[] args) throws Exception {
        List<Configuration> list = ImportInitvalues.initialCfgs(new InstallationConfig());
        ByteArrayOutputStream baos = BackupExport.stream("configs", list);
        File f = new File(args[0]);
        if (!f.exists() && !f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        Files.write(Paths.get(args[0], new String[0]), baos.toByteArray(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

