/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.RemoveOpSteps;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;

public enum RemoveIfSameOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            RemoveOpSteps.READ.runStep(state);
        }

        public RemoveIfSameOpSteps nextStep(State state) {
            return state.isRecordExistsInMemory() ? ON_LOAD : LOAD;
        }
    }
    ,
    LOAD{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Object oldValue = recordStore.loadValueOf(state.getKey());
            if (oldValue != null) {
                recordStore.getMapDataStore().remove(state.getKey(), state.getNow(), state.getTxnId());
                state.setOldValue(oldValue);
            } else {
                state.setResult(false);
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.getOldValue() == null ? UtilSteps.SEND_RESPONSE : ON_LOAD;
        }
    }
    ,
    ON_LOAD{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
            ValueComparator valueComparator = recordStore.getValueComparator();
            Object oldValue = state.getOldValue();
            if (valueComparator.isEqual(state.getExpect(), oldValue, serializationService)) {
                mapServiceContext.interceptRemove(mapContainer.getInterceptorRegistry(), oldValue);
            } else {
                state.setResult(false);
                state.setStopExecution(true);
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.isStopExecution() ? UtilSteps.SEND_RESPONSE : DELETE;
        }
    }
    ,
    DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            MapDataStore<Data, Object> mapDataStore = state.getRecordStore().getMapDataStore();
            mapDataStore.remove(state.getKey(), state.getNow(), state.getTxnId());
        }

        public RemoveIfSameOpSteps nextStep(State state) {
            return ON_DELETE;
        }
    }
    ,
    ON_DELETE{

        @Override
        public void runStep(State state) {
            if (state.isRecordExistsInMemory()) {
                DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
                Record record = recordStore.getRecord(state.getKey());
                recordStore.removeRecord0(state.getKey(), record, false);
                recordStore.onStore(record);
                recordStore.updateStatsOnRemove(state.getNow());
            }
            state.setResult(true);
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.SEND_RESPONSE;
        }
    };

}

