/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics;

import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum MetricTarget {
    MANAGEMENT_CENTER,
    JMX,
    DIAGNOSTICS,
    JET_JOB;

    public static final Collection<MetricTarget> ALL_TARGETS;
    public static final Collection<MetricTarget> NONE_OF;
    public static final Collection<MetricTarget> ALL_TARGETS_BUT_DIAGNOSTICS;
    static final Int2ObjectHashMap<Set<MetricTarget>> BITSET_TO_SET_CACHE;
    private static final int MASK_ALL_TARGETS;

    private static void generateCombinations(int[] ordinals, int start, int end, int index) {
        if (index == ordinals.length) {
            MetricTarget[] allTargets = MetricTarget.values();
            MetricTarget[] combination = new MetricTarget[ordinals.length];
            for (int i = 0; i < ordinals.length; ++i) {
                combination[i] = allTargets[ordinals[i]];
            }
            MetricTarget.putInSetCache(combination);
        } else if (start <= end) {
            ordinals[index] = start;
            MetricTarget.generateCombinations(ordinals, start + 1, end, index + 1);
            MetricTarget.generateCombinations(ordinals, start + 1, end, index);
        }
    }

    public static Set<MetricTarget> asSet(MetricTarget ... targets) {
        if (targets.length == 0) {
            return Collections.emptySet();
        }
        return BITSET_TO_SET_CACHE.get(MetricTarget.bitset(targets));
    }

    public static Set<MetricTarget> asSet(int bitset) {
        return BITSET_TO_SET_CACHE.get(bitset & MASK_ALL_TARGETS);
    }

    public static Set<MetricTarget> asSetWith(Collection<MetricTarget> targets, MetricTarget includedTarget) {
        int bitset = MetricTarget.bitset(targets) | MetricTarget.targetMask(includedTarget);
        return BITSET_TO_SET_CACHE.get(bitset);
    }

    public static Set<MetricTarget> asSetWithout(Collection<MetricTarget> targets, MetricTarget excludedTarget) {
        int bitset = MetricTarget.bitset(targets) ^ MetricTarget.targetMask(excludedTarget);
        return BITSET_TO_SET_CACHE.get(bitset);
    }

    public static Set<MetricTarget> union(Collection<MetricTarget> targets1, Collection<MetricTarget> targets2) {
        return MetricTarget.asSet(MetricTarget.bitset(targets1) | MetricTarget.bitset(targets2));
    }

    public static int bitset(Iterable<MetricTarget> targets) {
        int bitset = 0;
        for (MetricTarget target : targets) {
            bitset |= MetricTarget.targetMask(target);
        }
        return bitset;
    }

    private static int bitset(MetricTarget[] targets) {
        int bitset = 0;
        for (MetricTarget target : targets) {
            bitset |= MetricTarget.targetMask(target);
        }
        return bitset;
    }

    private static int targetMask(MetricTarget target) {
        return 1 << target.ordinal();
    }

    private static void putInSetCache(MetricTarget ... targets) {
        EnumSet<MetricTarget> targetsSet = EnumSet.noneOf(MetricTarget.class);
        Collections.addAll(targetsSet, targets);
        BITSET_TO_SET_CACHE.put(MetricTarget.bitset(targets), (Set<MetricTarget>)targetsSet);
    }

    static {
        ALL_TARGETS = EnumSet.copyOf(Arrays.asList(MetricTarget.values()));
        NONE_OF = EnumSet.noneOf(MetricTarget.class);
        BITSET_TO_SET_CACHE = new Int2ObjectHashMap();
        MASK_ALL_TARGETS = MetricTarget.bitset(MetricTarget.values());
        for (int i = 0; i <= MetricTarget.values().length; ++i) {
            MetricTarget.generateCombinations(new int[i], 0, MetricTarget.values().length - 1, 0);
        }
        ALL_TARGETS_BUT_DIAGNOSTICS = MetricTarget.asSetWithout(ALL_TARGETS, DIAGNOSTICS);
    }
}

