/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IndexIterationPointer
implements IdentifiedDataSerializable {
    private static final byte FLAG_DESCENDING = 1;
    private static final byte FLAG_FROM_INCLUSIVE = 2;
    private static final byte FLAG_TO_INCLUSIVE = 4;
    private static final byte FLAG_POINT_LOOKUP = 8;
    private byte flags;
    private Comparable<?> from;
    private Comparable<?> to;
    private Data lastEntryKeyData;

    public IndexIterationPointer() {
    }

    private IndexIterationPointer(byte flags, Comparable<?> from, Comparable<?> to, Data lastEntryKeyData) {
        this.flags = flags;
        this.from = from;
        this.to = to;
        this.lastEntryKeyData = lastEntryKeyData;
    }

    public static IndexIterationPointer create(Comparable<?> from, boolean fromInclusive, Comparable<?> to, boolean toInclusive, boolean descending, Data lastEntryKey) {
        return new IndexIterationPointer((byte)((descending ? 1 : 0) | (fromInclusive ? 2 : 0) | (toInclusive ? 4 : 0) | (from == to ? 8 : 0)), from, to, lastEntryKey);
    }

    public static IndexIterationPointer[] createFromIndexFilter(IndexFilter indexFilter, boolean descending, ExpressionEvalContext evalContext) {
        ArrayList<IndexIterationPointer> result = new ArrayList<IndexIterationPointer>();
        IndexIterationPointer.createFromIndexFilterInt(indexFilter, descending, evalContext, result);
        return result.toArray(new IndexIterationPointer[0]);
    }

    private static void createFromIndexFilterInt(IndexFilter indexFilter, boolean descending, ExpressionEvalContext evalContext, List<IndexIterationPointer> result) {
        if (indexFilter == null) {
            result.add(IndexIterationPointer.create(null, true, null, true, descending, null));
        }
        if (indexFilter instanceof IndexRangeFilter) {
            IndexRangeFilter rangeFilter = (IndexRangeFilter)indexFilter;
            Comparable from = null;
            if (rangeFilter.getFrom() != null) {
                Comparable fromValue = rangeFilter.getFrom().getValue(evalContext);
                if (fromValue == null) {
                    return;
                }
                from = fromValue;
            }
            Comparable to = null;
            if (rangeFilter.getTo() != null) {
                Comparable toValue = rangeFilter.getTo().getValue(evalContext);
                if (toValue == null) {
                    return;
                }
                to = toValue;
            }
            result.add(IndexIterationPointer.create(from, rangeFilter.isFromInclusive(), to, rangeFilter.isToInclusive(), descending, null));
        } else if (indexFilter instanceof IndexEqualsFilter) {
            IndexEqualsFilter equalsFilter = (IndexEqualsFilter)indexFilter;
            Comparable value = equalsFilter.getComparable(evalContext);
            result.add(IndexIterationPointer.create(value, true, value, true, descending, null));
        } else if (indexFilter instanceof IndexCompositeFilter) {
            IndexCompositeFilter inFilter = (IndexCompositeFilter)indexFilter;
            for (IndexFilter filter : inFilter.getFilters()) {
                IndexIterationPointer.createFromIndexFilterInt(filter, descending, evalContext, result);
            }
        }
    }

    public Comparable<?> getFrom() {
        return this.from;
    }

    public boolean isFromInclusive() {
        return (this.flags & 2) != 0;
    }

    public Comparable<?> getTo() {
        return this.to;
    }

    public boolean isToInclusive() {
        return (this.flags & 4) != 0;
    }

    public boolean isDescending() {
        return (this.flags & 1) != 0;
    }

    public Data getLastEntryKeyData() {
        return this.lastEntryKeyData;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.flags);
        out.writeObject(this.from);
        if ((this.flags & 8) == 0) {
            out.writeObject(this.to);
        }
        IOUtil.writeData(out, this.lastEntryKeyData);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.flags = in.readByte();
        this.from = (Comparable)in.readObject();
        this.to = (this.flags & 8) == 0 ? (Comparable<Object>)in.readObject() : this.from;
        this.lastEntryKeyData = IOUtil.readData(in);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 156;
    }
}

