/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.datastore;

import com.hazelcast.com.zaxxer.hikari.HikariConfig;
import com.hazelcast.com.zaxxer.hikari.HikariDataSource;
import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.spi.annotation.Beta;
import javax.sql.DataSource;

@Beta
public class JdbcDataStoreFactory
implements ExternalDataStoreFactory<DataSource> {
    private ExternalDataStoreConfig config;
    private DataSource shareDataSource;

    @Override
    public void init(ExternalDataStoreConfig config) {
        this.config = config;
        if (config.isShared()) {
            this.shareDataSource = this.createDataSource();
        }
    }

    @Override
    public DataSource getDataStore() {
        return this.config.isShared() ? this.shareDataSource : this.createDataSource();
    }

    private DataSource createDataSource() {
        HikariConfig dataSourceConfig = new HikariConfig(this.config.getProperties());
        return new HikariDataSource(dataSourceConfig);
    }
}

