/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.rooms;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.common.UserPanel;
import org.apache.openmeetings.web.user.rooms.RoomListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.io.IOUtils;

public class RoomsPanel
extends UserPanel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer clientsContainer = new WebMarkupContainer("clientsContainer");
    private final WebMarkupContainer details = new WebMarkupContainer("details");
    private final ListView<Client> clients;
    private final Label roomIdLbl = new Label("roomId", (IModel)Model.of((Serializable)null));
    private final Label roomNameLbl = new Label("roomName", (IModel)Model.of((Serializable)((Object)((String)null))));
    private final Label roomCommentLbl = new Label("roomComment", (IModel)Model.of((Serializable)((Object)((String)null))));
    private List<Client> clientsInRoom = null;
    private final List<Room> rooms;
    private Long roomId = 0L;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private RoomDao roomDao;

    public RoomsPanel(String id, List<Room> rooms) {
        super(id);
        this.rooms = rooms;
        this.clients = new ListView<Client>("clients", this.clientsInRoom){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Client> item) {
                Client client = (Client)item.getModelObject();
                final Long userId = client.getUserId();
                item.add(new Component[]{new Image("clientImage", (IResource)new ByteArrayResource("image/png"){
                    private static final long serialVersionUID = 1L;

                    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                        AbstractResource.ResourceResponse rr = super.newResourceResponse(attributes);
                        rr.disableCaching();
                        return rr;
                    }

                    protected byte[] getData(IResource.Attributes attributes) {
                        byte[] byArray;
                        String uri = null;
                        if (userId != null) {
                            uri = ((User)RoomsPanel.this.userDao.get(userId > 0L ? userId : -userId.longValue())).getPictureUri();
                        }
                        File img = OmFileHelper.getUserProfilePicture((Long)userId, uri);
                        FileInputStream is = new FileInputStream(img);
                        try {
                            byArray = IOUtils.toByteArray((InputStream)is);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                        ((InputStream)is).close();
                        return byArray;
                    }
                }, new IResource[0])});
                item.add(new Component[]{new Label("clientLogin", (Serializable)((Object)client.getUser().getLogin()))});
                item.add(new Component[]{new Label("from", (Serializable)client.getConnectedSince())});
            }
        };
    }

    protected void onInitialize() {
        this.add(new Component[]{new RoomListPanel("list", this.rooms, this.getString("lbl.enter")){
            private static final long serialVersionUID = 1L;

            @Override
            public void onContainerClick(AjaxRequestTarget target, Room r) {
                RoomsPanel.this.roomId = r.getId();
                RoomsPanel.this.updateRoomDetails(target);
            }

            @Override
            public void onRefreshClick(AjaxRequestTarget target, Room r) {
                super.onRefreshClick(target, r);
                RoomsPanel.this.roomId = r.getId();
                RoomsPanel.this.updateRoomDetails(target);
            }
        }});
        this.add(new Component[]{this.details.setOutputMarkupId(true).setVisible(!this.rooms.isEmpty())});
        this.details.add(new Component[]{this.roomIdLbl, this.roomNameLbl, this.roomCommentLbl});
        this.details.add(new Component[]{this.clientsContainer.add(new Component[]{this.clients.setOutputMarkupId(true)}).setOutputMarkupId(true)});
        super.onInitialize();
    }

    void updateRoomDetails(AjaxRequestTarget target) {
        this.clients.setDefaultModelObject(this.cm.streamByRoom(this.roomId).toList());
        Room room = this.roomDao.get(this.roomId);
        this.roomIdLbl.setDefaultModelObject((Object)room.getId());
        this.roomNameLbl.setDefaultModelObject((Object)room.getName());
        this.roomCommentLbl.setDefaultModelObject((Object)room.getComment());
        target.add(new Component[]{this.clientsContainer, this.details});
    }
}

