/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.user.dashboard.MyRoomsWidget;
import org.apache.openmeetings.web.user.dashboard.RssWidget;
import org.apache.openmeetings.web.user.dashboard.admin.AdminWidget;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetDescriptor;
import org.wicketstuff.dashboard.web.DashboardContext;

public class WidgetsPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ConfigurationDao cfgDao;

    public WidgetsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        boolean confShowMyRooms = this.cfgDao.getBool("dashboard.show.myrooms", false);
        boolean confShowRss = this.cfgDao.getBool("dashboard.show.rssfeed", false);
        ArrayList widgets = new ArrayList(Application.getDashboardContext().getWidgetRegistry().getWidgetDescriptors());
        Iterator i = widgets.iterator();
        while (i.hasNext()) {
            WidgetDescriptor wd = (WidgetDescriptor)i.next();
            if (!confShowMyRooms && MyRoomsWidget.class.getCanonicalName().equals(wd.getWidgetClassName())) {
                i.remove();
                continue;
            }
            if (!confShowRss && RssWidget.class.getCanonicalName().equals(wd.getWidgetClassName())) {
                i.remove();
                continue;
            }
            if (AuthLevelUtil.hasAdminLevel(WebSession.getRights()) || !AdminWidget.class.getCanonicalName().equals(wd.getWidgetClassName())) continue;
            i.remove();
        }
        this.add(new Component[]{new ListView<WidgetDescriptor>("widgets", widgets){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<WidgetDescriptor> item) {
                final WidgetDescriptor wd = (WidgetDescriptor)item.getModelObject();
                item.add(new Component[]{new Label("name", (Serializable)((Object)wd.getName()))});
                item.add(new Component[]{new Label("description", (Serializable)((Object)wd.getDescription()))});
                item.add(new Component[]{new AjaxCheckBox("display", (IModel)Model.of((Serializable)Boolean.valueOf(WidgetsPanel.isDisplayed(wd) != null))){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        Widget w = WidgetsPanel.isDisplayed(wd);
                        boolean b = (Boolean)this.getModelObject();
                        DashboardContext dashboardContext = Application.getDashboardContext();
                        Dashboard d = WebSession.getDashboard();
                        if (w != null && !b) {
                            d.deleteWidget(w.getId());
                        }
                        if (w == null && b) {
                            d.addWidget(dashboardContext.getWidgetFactory().createWidget(wd));
                        }
                        dashboardContext.getDashboardPersister().save(d);
                    }
                }});
            }
        }});
    }

    private static Widget isDisplayed(WidgetDescriptor wd) {
        for (Widget w : WebSession.getDashboard().getWidgets()) {
            if (!w.getClass().getName().equals(wd.getWidgetClassName())) continue;
            return w;
        }
        return null;
    }
}

