/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.PrivateMessageFolderDao;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.PrivateMessageFolder;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.entity.user.UserContact;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.openmeetings.web.user.MessageDialog;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.ContactsHelper;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class MessagesContactsPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private static final Long MOVE_CHOOSE = -1L;
    private static final String CSS_UNREAD = "unread";
    private static final String SELECT_CHOOSE = "1252";
    private static final String SELECT_ALL = "1239";
    private static final String SELECT_NONE = "1240";
    private static final String SELECT_UNREAD = "1241";
    private static final String SELECT_READ = "1242";
    private final WebMarkupContainer container = new WebMarkupContainer("container");
    private final WebMarkupContainer folders = new WebMarkupContainer("folders");
    private final Label unread = new Label("unread", (IModel)Model.of((Serializable)Long.valueOf(0L)));
    private final Label pendingContacts = new Label("pendingContacts", (IModel)Model.of((Serializable)Long.valueOf(0L)));
    private final Label allContacts = new Label("allContacts", (IModel)Model.of((Serializable)Long.valueOf(0L)));
    private final IModel<Long> selectedFolderModel = Model.of((Serializable)PrivateMessage.INBOX_FOLDER_ID);
    private final IModel<List<PrivateMessageFolder>> foldersModel = new ListModel(null);
    private final WebMarkupContainer inbox = new WebMarkupContainer("inbox");
    private final WebMarkupContainer sent = new WebMarkupContainer("sent");
    private final WebMarkupContainer trash = new WebMarkupContainer("trash");
    private final WebMarkupContainer selectedMessage = new WebMarkupContainer("selectedMessage");
    private final WebMarkupContainer roomContainer = new WebMarkupContainer("roomContainer");
    private final WebMarkupContainer buttons = new WebMarkupContainer("buttons");
    private final WebMarkupContainer contacts = new WebMarkupContainer("contacts");
    private final DataViewContainer<PrivateMessage> dataContainer;
    private final Set<Long> selectedMessages = new HashSet<Long>();
    private Long lastSelected = null;
    private final Set<Long> allMessages = new HashSet<Long>();
    private final Set<Long> readMessages = new HashSet<Long>();
    private final Set<Long> unreadMessages = new HashSet<Long>();
    private final Button toInboxBtn = new Button("toInboxBtn");
    private final Button deleteBtn = new Button("deleteBtn");
    private final Button replyBtn = new Button("replyBtn");
    private final Button readBtn = new Button("readBtn");
    private final Button unreadBtn = new Button("unreadBtn");
    private final DropDownChoice<String> selectDropDown = new DropDownChoice("msgSelect", (IModel)Model.of((Serializable)((Object)"1252")), List.of("1252", "1239", "1240", "1241", "1242"), (IChoiceRenderer)new ChoiceRenderer<String>(){
        private static final long serialVersionUID = 1L;

        public Object getDisplayValue(String object) {
            return Application.getString(object);
        }

        public String getIdValue(String object, int index) {
            return object;
        }
    });
    private final PrivateMessageFolder notMoveFolder = new PrivateMessageFolder();
    private final DropDownChoice<PrivateMessageFolder> moveDropDown = new DropDownChoice("msgMove", (IModel)Model.of((Serializable)this.notMoveFolder), List.of(this.notMoveFolder), (IChoiceRenderer)new ChoiceRenderer<PrivateMessageFolder>(){
        private static final long serialVersionUID = 1L;

        public Object getDisplayValue(PrivateMessageFolder object) {
            return object.getFolderName();
        }

        public String getIdValue(PrivateMessageFolder object, int index) {
            return "" + object.getId();
        }
    });
    private WebMarkupContainer selectedFolder;
    @SpringBean
    private PrivateMessageDao msgDao;
    @SpringBean
    private PrivateMessageFolderDao folderDao;
    @SpringBean
    private UserContactDao contactDao;
    @SpringBean
    private AppointmentDao apptDao;

    public MessagesContactsPanel(String id) {
        super(id);
        this.notMoveFolder.setId(MOVE_CHOOSE);
        this.notMoveFolder.setFolderName(Application.getString("1243"));
        this.foldersModel.setObject((Object)this.folderDao.get(0L, Integer.MAX_VALUE));
        this.updateMoveModel();
        final NameDialog addFolder = new NameDialog("addFolder"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                MessagesContactsPanel.this.folderDao.addPrivateMessageFolder((String)this.getModelObject(), WebSession.getUserId());
                MessagesContactsPanel.this.foldersModel.setObject((Object)MessagesContactsPanel.this.folderDao.get(0L, Integer.MAX_VALUE));
                MessagesContactsPanel.this.updateMoveModel();
                target.add(new Component[]{MessagesContactsPanel.this.folders, MessagesContactsPanel.this.moveDropDown});
            }
        };
        this.add(new Component[]{addFolder});
        this.folders.add(new Component[]{this.inbox.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.inbox, PrivateMessage.INBOX_FOLDER_ID, target);
            }
        }})});
        this.folders.add(new Component[]{this.sent.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.sent, PrivateMessage.SENT_FOLDER_ID, target);
            }
        }})});
        this.folders.add(new Component[]{this.trash.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.trash, PrivateMessage.TRASH_FOLDER_ID, target);
            }
        }})});
        this.folders.add(new Component[]{new WebMarkupContainer("newdir").add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                addFolder.show((IPartialPageRequestHandler)target);
            }
        }})});
        this.add(new Component[]{this.folders.add(new Component[]{new ListView<PrivateMessageFolder>("folder", this.foldersModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(final ListItem<PrivateMessageFolder> item) {
                item.add(new Component[]{new Label("name", (Serializable)((Object)((PrivateMessageFolder)item.getModelObject()).getFolderName())).setRenderBodyOnly(true)});
                BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("delete", Buttons.Type.Outline_Danger){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        MessagesContactsPanel.this.folderDao.delete((PrivateMessageFolder)item.getModelObject(), WebSession.getUserId());
                        MessagesContactsPanel.this.foldersModel.setObject((Object)MessagesContactsPanel.this.folderDao.get(0L, Integer.MAX_VALUE));
                        MessagesContactsPanel.this.updateMoveModel();
                        target.add(new Component[]{MessagesContactsPanel.this.folders, MessagesContactsPanel.this.moveDropDown});
                    }
                };
                del.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
                item.add(new Component[]{del});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> MessagesContactsPanel.this.selectFolder((WebMarkupContainer)item, ((PrivateMessageFolder)item.getModelObject()).getId(), (AjaxRequestTarget)target))});
                MessagesContactsPanel.this.setFolderClass(item);
            }
        }}).setOutputMarkupId(true)});
        SearchableDataProvider<PrivateMessage> sdp = new SearchableDataProvider<PrivateMessage>(PrivateMessageDao.class){
            private static final long serialVersionUID = 1L;

            protected PrivateMessageDao getDao() {
                return (PrivateMessageDao)super.getDao();
            }

            @Override
            public Iterator<? extends PrivateMessage> iterator(long first, long count) {
                MessagesContactsPanel.this.allMessages.clear();
                MessagesContactsPanel.this.readMessages.clear();
                MessagesContactsPanel.this.unreadMessages.clear();
                String sort = this.getSort() == null ? "" : "m." + (String)this.getSort().getProperty();
                boolean isAsc = this.getSort() == null || this.getSort().isAscending();
                return this.getDao().get(WebSession.getUserId(), (Long)MessagesContactsPanel.this.selectedFolderModel.getObject(), this.search, sort, isAsc, first, count).iterator();
            }

            @Override
            public long size() {
                return this.getDao().count(WebSession.getUserId(), (Long)MessagesContactsPanel.this.selectedFolderModel.getObject(), this.search);
            }
        };
        SearchableDataView<PrivateMessage> dv = new SearchableDataView<PrivateMessage>("messages", (SearchableDataProvider)sdp){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<PrivateMessage> item) {
                PrivateMessage m = (PrivateMessage)item.getModelObject();
                Long id = m.getId();
                MessagesContactsPanel.this.allMessages.add(id);
                if (m.getIsRead()) {
                    MessagesContactsPanel.this.readMessages.add(id);
                } else {
                    MessagesContactsPanel.this.unreadMessages.add(id);
                }
                item.add(new Component[]{new Label("id", (Serializable)id)});
                item.add(new Component[]{new Label("from", (Serializable)((Object)MessagesContactsPanel.getDisplayName(m.getFrom())))});
                item.add(new Component[]{new Label("subject", (Serializable)((Object)m.getSubject()))});
                item.add(new Component[]{new Label("send", (Serializable)((Object)WebSession.getDateFormat().format(m.getInserted())))});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    long selected = id;
                    if (MessagesContactsPanel.this.selectedMessages.contains(id)) {
                        MessagesContactsPanel.this.selectedMessages.remove(id);
                        selected = MessagesContactsPanel.this.selectedMessages.isEmpty() ? -1L : MessagesContactsPanel.this.selectedMessages.iterator().next();
                    } else {
                        MessagesContactsPanel.this.selectedMessages.add(id);
                    }
                    MessagesContactsPanel.this.selectMessage(selected, (AjaxRequestTarget)target);
                    target.add(new Component[]{MessagesContactsPanel.this.container});
                })});
                StringBuilder cssClass = new StringBuilder(m.getIsRead() ? "" : MessagesContactsPanel.CSS_UNREAD);
                if (MessagesContactsPanel.this.selectedMessages.contains(id)) {
                    cssClass.append(" selected");
                }
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)cssClass.toString()))});
            }
        };
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dv){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.emptySelection(target);
                target.add(new Component[]{MessagesContactsPanel.this.container});
            }
        };
        this.dataContainer = new DataViewContainer<PrivateMessage>(this.container, dv, navigator);
        this.dataContainer.addLink(new OmOrderByBorder<PrivateMessage>("orderById", "id", this.dataContainer)).addLink(new OmOrderByBorder<PrivateMessage>("orderByFrom", "from.lastname", this.dataContainer)).addLink(new OmOrderByBorder<PrivateMessage>("orderBySubject", "subject", this.dataContainer)).addLink(new OmOrderByBorder<PrivateMessage>("orderBySend", "inserted", this.dataContainer));
        this.add((Component[])this.dataContainer.getLinks());
        this.add(new Component[]{navigator});
        this.add(new Component[]{this.unread.setOutputMarkupId(true)});
        this.add(new Component[]{this.buttons.setOutputMarkupId(true)});
        this.buttons.add(new Component[]{this.toInboxBtn.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.msgDao.moveMailsToFolder(MessagesContactsPanel.this.selectedMessages, PrivateMessage.INBOX_FOLDER_ID);
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.selectedFolder, (Long)MessagesContactsPanel.this.selectedFolderModel.getObject(), target);
            }
        }})});
        this.buttons.add(new Component[]{this.replyBtn.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                PrivateMessage opm = MessagesContactsPanel.this.msgDao.get(MessagesContactsPanel.this.lastSelected);
                if (opm != null) {
                    MessageDialog newDlg = MessagesContactsPanel.this.getMainPanel().getMessageDialog();
                    PrivateMessage pm = (PrivateMessage)newDlg.reset(true).getModelObject();
                    pm.setTo(opm.getFrom());
                    pm.setSubject(String.format("%s %s", MessagesContactsPanel.this.getString("messages.subject.re"), opm.getSubject()));
                    pm.setMessage(String.format("<br/><blockquote class=\"quote\">%s</blockquote>", opm.getMessage()));
                    newDlg.show((IPartialPageRequestHandler)target);
                }
            }
        }})});
        this.buttons.add(new Component[]{this.deleteBtn.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                if (PrivateMessage.TRASH_FOLDER_ID.equals(MessagesContactsPanel.this.selectedFolderModel.getObject())) {
                    MessagesContactsPanel.this.msgDao.delete(MessagesContactsPanel.this.selectedMessages);
                } else {
                    MessagesContactsPanel.this.msgDao.moveMailsToFolder(MessagesContactsPanel.this.selectedMessages, PrivateMessage.TRASH_FOLDER_ID);
                }
                MessagesContactsPanel.this.emptySelection(target);
                target.add(new Component[]{MessagesContactsPanel.this.container});
            }
        }})});
        this.buttons.add(new Component[]{this.readBtn.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.msgDao.updateReadStatus(MessagesContactsPanel.this.selectedMessages, Boolean.valueOf(true));
                MessagesContactsPanel.this.emptySelection(target);
                target.add(new Component[]{MessagesContactsPanel.this.container, MessagesContactsPanel.this.unread});
            }
        }})});
        this.buttons.add(new Component[]{this.unreadBtn.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                MessagesContactsPanel.this.msgDao.updateReadStatus(MessagesContactsPanel.this.selectedMessages, Boolean.valueOf(false));
                MessagesContactsPanel.this.emptySelection(target);
                target.add(new Component[]{MessagesContactsPanel.this.container});
            }
        }})});
        this.buttons.add(new Component[]{this.selectDropDown.setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                switch ((String)MessagesContactsPanel.this.selectDropDown.getModelObject()) {
                    case "1252": {
                        break;
                    }
                    case "1239": {
                        MessagesContactsPanel.this.selectedMessages.clear();
                        MessagesContactsPanel.this.selectedMessages.addAll(MessagesContactsPanel.this.allMessages);
                        break;
                    }
                    case "1240": {
                        MessagesContactsPanel.this.selectedMessages.clear();
                        break;
                    }
                    case "1241": {
                        MessagesContactsPanel.this.selectedMessages.clear();
                        MessagesContactsPanel.this.selectedMessages.addAll(MessagesContactsPanel.this.unreadMessages);
                        break;
                    }
                    case "1242": {
                        MessagesContactsPanel.this.selectedMessages.clear();
                        MessagesContactsPanel.this.selectedMessages.addAll(MessagesContactsPanel.this.readMessages);
                        break;
                    }
                }
                target.add(new Component[]{MessagesContactsPanel.this.container});
            }
        }})});
        this.buttons.add(new Component[]{this.moveDropDown.setOutputMarkupId(true).add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                Long folderId = ((PrivateMessageFolder)MessagesContactsPanel.this.moveDropDown.getModelObject()).getId();
                if (!MOVE_CHOOSE.equals(folderId)) {
                    MessagesContactsPanel.this.msgDao.moveMailsToFolder(MessagesContactsPanel.this.selectedMessages, folderId);
                }
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.selectedFolder, (Long)MessagesContactsPanel.this.selectedFolderModel.getObject(), target);
            }
        }})});
        this.selectMessage(-1L, null);
        this.add(new Component[]{this.container.add(new Component[]{dv}).setOutputMarkupId(true)});
        this.add(new Component[]{this.selectedMessage.add(new Component[]{this.roomContainer.setVisible(false)}).setOutputMarkupId(true)});
        IDataProvider<UserContact> dp = new IDataProvider<UserContact>(){
            private static final long serialVersionUID = 1L;

            public Iterator<? extends UserContact> iterator(long first, long count) {
                return MessagesContactsPanel.this.contactDao.get(WebSession.getUserId().longValue(), first, count).iterator();
            }

            public long size() {
                return MessagesContactsPanel.this.contactDao.count(WebSession.getUserId().longValue());
            }

            public IModel<UserContact> model(UserContact object) {
                return Model.of((Serializable)object);
            }
        };
        DataView<UserContact> dw = new DataView<UserContact>("users", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            private String getName(UserContact uc) {
                return uc.getOwner().getDisplayName();
            }

            protected void populateItem(Item<UserContact> item) {
                UserContact uc = (UserContact)item.getModelObject();
                final Long contactId = uc.getId();
                Long userId = uc.getOwner().getId();
                if (uc.isPending()) {
                    item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)MessagesContactsPanel.CSS_UNREAD))});
                }
                item.add(new Component[]{new Label("name", (Serializable)((Object)this.getName(uc)))});
                item.add(new Component[]{new WebMarkupContainer("accept").add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    ContactsHelper.acceptUserContact(contactId);
                    MessagesContactsPanel.this.updateContacts((AjaxRequestTarget)target);
                })}).setVisible(uc.isPending())});
                item.add(new Component[]{new WebMarkupContainer("decline").add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    MessagesContactsPanel.this.contactDao.delete(contactId);
                    MessagesContactsPanel.this.updateContacts((AjaxRequestTarget)target);
                })}).setVisible(uc.isPending())});
                item.add(new Component[]{new WebMarkupContainer("view").add(new Behavior[]{AttributeModifier.append((String)"data-user-id", (Serializable)userId)})});
                item.add(new Component[]{new WebMarkupContainer("message").add(new Behavior[]{AttributeModifier.append((String)"data-user-id", (Serializable)userId)}).setVisible(!uc.isPending())});
                BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("delete", Buttons.Type.Outline_Danger){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        MessagesContactsPanel.this.contactDao.delete(contactId);
                        MessagesContactsPanel.this.updateContacts(target);
                    }
                };
                del.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
                item.add(new Component[]{del.setVisible(!uc.isPending())});
            }
        };
        this.updateContacts(null);
        this.add(new Component[]{this.contacts.add(new Component[]{dw, this.pendingContacts, this.allContacts}).setOutputMarkupId(true)});
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                MessagesContactsPanel.this.selectFolder(MessagesContactsPanel.this.inbox, PrivateMessage.INBOX_FOLDER_ID, target);
                MessagesContactsPanel.this.selectMessage(-1L, target);
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getCallbackScript()));
            }
        }});
    }

    private void setDefaultFolderClass() {
        this.inbox.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"email inbox clickable"))});
        this.sent.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"email sent clickable"))});
        this.trash.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"email trash clickable"))});
    }

    private static void selectFolder(WebMarkupContainer folder) {
        folder.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"selected"))});
    }

    private void setFolderClass(ListItem<PrivateMessageFolder> folder) {
        folder.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"email folder clickable"))});
        if (((PrivateMessageFolder)folder.getModelObject()).getId().equals(this.selectedFolderModel.getObject())) {
            MessagesContactsPanel.selectFolder(folder);
        }
    }

    private void updateControls(AjaxRequestTarget target) {
        this.deleteBtn.setEnabled(!this.selectedMessages.isEmpty());
        Long selFldr = (Long)this.selectedFolderModel.getObject();
        this.readBtn.setEnabled(!PrivateMessage.TRASH_FOLDER_ID.equals(selFldr) && !this.selectedMessages.isEmpty());
        this.unreadBtn.setEnabled(!PrivateMessage.TRASH_FOLDER_ID.equals(selFldr) && !this.selectedMessages.isEmpty());
        this.toInboxBtn.setVisible(!PrivateMessage.INBOX_FOLDER_ID.equals(selFldr) && !PrivateMessage.SENT_FOLDER_ID.equals(selFldr) && !this.selectedMessages.isEmpty());
        this.replyBtn.setEnabled(this.lastSelected != null);
        target.add(new Component[]{this.buttons});
    }

    private static String getDisplayName(User u) {
        return u == null ? "" : u.getDisplayName();
    }

    private void selectMessage(long id, AjaxRequestTarget target) {
        PrivateMessage msg = (PrivateMessage)this.msgDao.get(id);
        this.selectedMessage.addOrReplace(new Component[]{new Label("from", (Serializable)((Object)(msg == null ? "" : MessagesContactsPanel.getDisplayName(msg.getFrom()))))});
        this.selectedMessage.addOrReplace(new Component[]{new Label("to", (Serializable)((Object)(msg == null ? "" : MessagesContactsPanel.getDisplayName(msg.getTo()))))});
        this.selectedMessage.addOrReplace(new Component[]{new Label("subj", (Serializable)((Object)(msg == null ? "" : msg.getSubject())))});
        this.selectedMessage.addOrReplace(new Component[]{new Label("body", (Serializable)((Object)(msg == null ? "" : msg.getMessage()))).setEscapeModelStrings(false)});
        if (msg == null) {
            this.lastSelected = null;
        } else {
            this.lastSelected = id;
            Room r = msg.getRoom();
            if (r != null) {
                Appointment a = this.apptDao.getByRoom(r.getId());
                this.roomContainer.addOrReplace(new Component[]{new Label("start", (Serializable)((Object)(a == null ? "" : WebSession.getDateFormat().format(a.getStart()))))});
                this.roomContainer.addOrReplace(new Component[]{new Label("end", (Serializable)((Object)(a == null ? "" : WebSession.getDateFormat().format(a.getEnd()))))});
                this.roomContainer.addOrReplace(new Component[]{new Button("enter").add(new Behavior[]{new RoomEnterBehavior(r.getId())})});
            }
            this.roomContainer.setVisible(r != null);
        }
        if (target != null) {
            target.add(new Component[]{this.selectedMessage});
            this.updateControls(target);
        }
    }

    void updateTable(AjaxRequestTarget target) {
        if (target != null) {
            target.add(new Component[]{this.container});
        }
    }

    private void selectFolder(WebMarkupContainer folder, Long id, AjaxRequestTarget target) {
        this.selectedFolder = folder;
        this.selectedFolderModel.setObject((Object)id);
        this.setDefaultFolderClass();
        MessagesContactsPanel.selectFolder(folder);
        this.emptySelection(target);
        this.selectDropDown.setModelObject((Object)SELECT_CHOOSE);
        this.moveDropDown.setModelObject((Object)this.notMoveFolder);
        this.deleteBtn.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)((Object)Application.getString(PrivateMessage.TRASH_FOLDER_ID.equals(id) ? "1256" : "80")))});
        this.readBtn.setEnabled(false);
        this.unreadBtn.setEnabled(false);
        if (target != null) {
            this.updateTable(target);
            target.add(new Component[]{this.folders, this.unread, this.selectDropDown, this.moveDropDown});
            target.add(new Component[]{this.dataContainer.getContainer(), this.dataContainer.getNavigator()});
            target.add(this.dataContainer.getLinks());
        }
    }

    private void emptySelection(AjaxRequestTarget target) {
        this.selectedMessages.clear();
        this.selectMessage(-1L, target);
        this.unread.setDefaultModelObject((Object)this.msgDao.count(WebSession.getUserId(), (Long)this.selectedFolderModel.getObject(), null));
        if (target != null) {
            target.add(new Component[]{this.unread});
        }
    }

    private void updateMoveModel() {
        ArrayList<PrivateMessageFolder> list = new ArrayList<PrivateMessageFolder>();
        list.add(this.notMoveFolder);
        list.addAll((Collection)this.foldersModel.getObject());
        this.moveDropDown.setChoices(list);
    }

    private void updateContacts(AjaxRequestTarget target) {
        this.pendingContacts.setDefaultModelObject((Object)this.contactDao.getContactRequestsByUserAndStatus(WebSession.getUserId(), true).size());
        this.allContacts.setDefaultModelObject((Object)this.contactDao.getContactsByUserAndStatus(WebSession.getUserId(), false).size());
        if (target != null) {
            target.add(new Component[]{this.contacts});
            target.appendJavaScript(this.getContactClickHandlers());
        }
    }

    private CharSequence getContactClickHandlers() {
        return "$('.messages .user.om-icon.clickable').off().click(function() {showUserInfo($(this).data('user-id'));});$('.messages .new-email.om-icon.clickable').click(function() {privateMessage($(this).data('user-id'));});";
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('.email.new.btn').click(function() {privateMessage();});" + this.getContactClickHandlers())));
    }

    @Override
    public void onNewMessageClose(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this.container});
    }

    protected void onDetach() {
        this.foldersModel.detach();
        this.selectedFolderModel.detach();
        super.onDetach();
    }
}

