/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.util.DateLabel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class InvitationDetails
extends Form<Invitation> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer list;
    private AjaxLink<Void> delBtn;
    private final Label valid = new Label("valid", (IModel)Model.of((Serializable)((Object)"")));
    private final Label invitee = new Label("invitee", (IModel)Model.of((Serializable)((Object)"")));
    private final DateLabel from = new DateLabel("validFrom", (IModel<?>)Model.of((Serializable)null));
    private final DateLabel to = new DateLabel("validTo", (IModel<?>)Model.of((Serializable)null));
    @SpringBean
    private InvitationDao inviteDao;

    public InvitationDetails(String id, WebMarkupContainer list, Invitation i) {
        super(id, (IModel)new CompoundPropertyModel((Object)i));
        this.list = list;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("id")});
        this.add(new Component[]{this.valid});
        this.add(new Component[]{this.invitee});
        this.add(new Component[]{this.from});
        this.add(new Component[]{this.to});
        this.delBtn = new AjaxLink<Void>("ajax-cancel-button"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                InvitationDetails.this.inviteDao.delete((Invitation)InvitationDetails.this.getModelObject(), WebSession.getUserId());
                InvitationDetails.this.setModelObject(new Invitation());
                target.add(new Component[]{InvitationDetails.this.list, InvitationDetails.this});
            }
        };
        this.delBtn.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
        this.add(new Component[]{this.delBtn.setOutputMarkupId(true).setEnabled(false)});
    }

    protected void onModelChanged() {
        super.onModelChanged();
        Invitation i = (Invitation)this.getModelObject();
        Invitation.Valid v = i.getValid();
        this.valid.setDefaultModelObject((Object)v.name());
        this.invitee.setDefaultModelObject((Object)FormatHelper.formatUser((User)i.getInvitee()));
        this.from.setDefaultModelObject(Invitation.Valid.PERIOD == v ? i.getValidFrom() : null);
        this.to.setDefaultModelObject(Invitation.Valid.PERIOD == v ? i.getValidTo() : null);
        this.delBtn.setEnabled(i.getId() != null);
    }
}

