/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import com.github.openjson.JSONObject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload.FileItem;
import org.apache.openmeetings.core.data.file.FileProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.file.FileItemLogDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.upload.UploadResourceReference;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomFileUploadResourceReference
extends UploadResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RoomFileUploadResourceReference.class);
    private static final String PARAM_TO_WB_NAME = "room-upload-to-wb";
    private static final String PARAM_CLEAN_NAME = "room-upload-clean";
    public static final String PARAM_LAST_SELECTED_ID = "room-upload-last-selected-id";
    public static final String PARAM_LAST_SELECTED_ROOM = "room-upload-last-selected-room";
    public static final String PARAM_LAST_SELECTED_OWNER = "room-upload-last-selected-owner";
    public static final String PARAM_LAST_SELECTED_GROUP = "room-upload-last-selected-group";
    @SpringBean
    private FileProcessor processor;
    @SpringBean
    private FileItemLogDao fileLogDao;
    @SpringBean
    private FileItemDao fileDao;

    public RoomFileUploadResourceReference() {
        super(RoomFileUploadResourceReference.class, "room-file-upload");
        Injector.get().inject((Object)this);
    }

    @Override
    protected boolean isUploadAllowed(Client c) {
        return Optional.ofNullable(c).map(Client::getRoom).map(room -> Room.Type.INTERVIEW != room.getType() && !room.isHidden(Room.RoomElement.FILES) && c.hasRight(Room.Right.PRESENTER)).orElse(false);
    }

    @Override
    protected void processFiles(Client c, List<FileItem> fileItems, String uuid, MultipartServletWebRequest multiPartRequest) {
        boolean toWb = multiPartRequest.getPostParameters().getParameterValue(PARAM_TO_WB_NAME).toBoolean(false);
        boolean clean = multiPartRequest.getPostParameters().getParameterValue(PARAM_CLEAN_NAME).toBoolean(false);
        long lastSelectedId = multiPartRequest.getPostParameters().getParameterValue(PARAM_LAST_SELECTED_ID).toLong(-1L);
        long lastSelectedRoom = multiPartRequest.getPostParameters().getParameterValue(PARAM_LAST_SELECTED_ROOM).toLong(-1L);
        long lastSelectedOwner = multiPartRequest.getPostParameters().getParameterValue(PARAM_LAST_SELECTED_OWNER).toLong(-1L);
        long lastSelectedGroup = multiPartRequest.getPostParameters().getParameterValue(PARAM_LAST_SELECTED_GROUP).toLong(-1L);
        ThreadHelper.startRunnable(() -> this.convertAll(c, fileItems, uuid, toWb, clean, lastSelectedId, lastSelectedRoom, lastSelectedOwner, lastSelectedGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertAll(Client c, List<FileItem> files, String uuid, boolean toWb, boolean clean, long lastSelectedId, long lastSelectedRoom, long lastSelectedOwner, long lastSelectedGroup) {
        BaseFileItem parent = (BaseFileItem)this.fileDao.get(lastSelectedId);
        long langId = RoomFileUploadResourceReference.getLangId(c);
        long totalSize = files.stream().mapToLong(FileItem::getSize).sum();
        AtomicInteger progress = new AtomicInteger(0);
        long currentSize = 0L;
        for (FileItem curItem : files) {
            long size = curItem.getSize();
            try {
                org.apache.openmeetings.db.entity.file.FileItem f = new org.apache.openmeetings.db.entity.file.FileItem();
                f.setSize(Long.valueOf(size));
                f.setName(curItem.getName());
                if (parent == null || BaseFileItem.Type.RECORDING == parent.getType()) {
                    if (lastSelectedGroup > -1L) {
                        f.setGroupId(Long.valueOf(lastSelectedGroup));
                    } else if (lastSelectedRoom > -1L) {
                        f.setRoomId(Long.valueOf(lastSelectedRoom));
                    } else {
                        f.setOwnerId(Long.valueOf(lastSelectedOwner > -1L ? lastSelectedOwner : WebSession.getUserId()));
                    }
                } else {
                    f.setRoomId(parent.getRoomId());
                    f.setOwnerId(parent.getOwnerId());
                    f.setGroupId(parent.getGroupId());
                    if (parent.getId() != null) {
                        f.setParentId(BaseFileItem.Type.FOLDER == parent.getType() ? parent.getId() : parent.getParentId());
                    }
                }
                f.setInsertedBy(WebSession.getUserId());
                ProcessResultList logs = this.processor.processFile(f, curItem.getInputStream(), Optional.of(part -> this.sendProgress(c, uuid, progress, progress.get() + (int)(100.0 * part * (double)size / (double)totalSize))));
                for (ProcessResult res : logs.getJobs()) {
                    this.fileLogDao.add(res.getProcess(), (BaseFileItem)f, res);
                }
                if (logs.hasError()) {
                    this.sendError(c, uuid, Application.getString("convert.errors.file", langId));
                } else {
                    WebSocketHelper.sendClient((IWsClient)c, (RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.FILE_TREE_UPDATE, new JSONObject().put("fileId", (Object)f.getId()).toString()));
                    if (toWb) {
                        WebSocketHelper.sendClient((IWsClient)c, (RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.WB_PUT_FILE, new JSONObject().put("fileId", (Object)f.getId()).put("clean", clean).toString()));
                        clean = false;
                    }
                }
            }
            catch (Exception e) {
                log.error("Unexpected error while processing uploaded file", (Throwable)e);
                this.sendError(c, uuid, e.getMessage() == null ? "Unexpected error" : e.getMessage());
            }
            finally {
                curItem.delete();
            }
            this.sendProgress(c, uuid, progress, (int)(100L * (currentSize += size) / totalSize));
        }
        this.sendProgress(c, uuid, progress, 100);
    }
}

