/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import com.github.openjson.JSONException;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.TextContentModal;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.UserManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.pages.BaseInitedPage;
import org.apache.openmeetings.web.pages.auth.ForgetPasswordDialog;
import org.apache.openmeetings.web.pages.auth.OtpDialog;
import org.apache.openmeetings.web.pages.auth.RegisterDialog;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.openmeetings.web.room.IconTextModal;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignInPage
extends BaseInitedPage {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SignInPage.class);
    public static final String TOKEN_PARAM = "token";
    private SignInDialog signin;
    private final Modal<String> kick = new IconTextModal("kick"){
        private static final long serialVersionUID = 1L;
        {
            this.withLabel((IModel<String>)new ResourceModel("606"));
            this.withErrorIcon();
            this.setCloseOnEscapeKey(false);
            this.show(true);
            this.setUseCloseHandler(true);
            this.addButton((Component)OmModalCloseButton.of("54"));
        }

        protected void onClose(IPartialPageRequestHandler target) {
            WebSession.setKickedByAdmin(false);
            Application.get().restartResponseAtSignInPage();
        }
    };
    private final Modal<String> forgetInfoDialog = new TextContentModal("forgetInfo", (IModel)new ResourceModel("321")){
        private static final long serialVersionUID = 1L;

        protected void onClose(IPartialPageRequestHandler handler) {
            SignInPage.this.signin.show(handler);
        }
    };
    private final ForgetPasswordDialog forget = new ForgetPasswordDialog("forget");
    private final Modal<String> registerInfoDialog = new TextContentModal("registerInfo", (IModel)Model.of((Serializable)((Object)""))){
        private static final long serialVersionUID = 1L;

        protected void onInitialize() {
            super.onInitialize();
            this.setModelObject(this.getString("warn.notverified"));
            this.get("content").setOutputMarkupId(true);
        }

        public Modal<String> setModelObject(String obj) {
            super.setModelObject((Object)obj);
            this.get("content").setDefaultModelObject((Object)obj);
            return this;
        }

        protected void onClose(IPartialPageRequestHandler handler) {
            SignInPage.this.signin.show(handler);
        }
    };
    RegisterDialog r = new RegisterDialog("register");
    private final OtpDialog otpDialog = new OtpDialog("otpDialog", (IModel<User>)Model.of());
    @SpringBean
    private ConfigurationDao cfgDao;
    @SpringBean
    private UserManager userManager;
    @SpringBean
    private OAuth2Dao oauthDao;

    public SignInPage() throws InterruptedException {
        this(new PageParameters());
    }

    public SignInPage(PageParameters p) throws InterruptedException {
        StringValue oauthid;
        WebSession.get().checkToken(p.get(TOKEN_PARAM));
        if (WebSession.get().isSignedIn()) {
            this.setResponsePage(Application.get().getHomePage());
        }
        if (!(oauthid = p.get("oauthid")).isEmpty()) {
            try {
                long serverId = oauthid.toLong(-1L);
                OAuthServer server = (OAuthServer)this.oauthDao.get(serverId);
                log.debug("OAuthServer={}", (Object)server);
                if (server == null) {
                    log.warn("OAuth server id={} not found", (Object)serverId);
                    return;
                }
                User u = this.userManager.loginOAuth(p.get("code").toOptionalString(), server);
                if (u != null && WebSession.get().signIn(u)) {
                    this.setResponsePage(Application.get().getHomePage());
                } else {
                    log.error("Failed to login via OAuth2!");
                }
            }
            catch (JSONException | IOException | NoSuchAlgorithmException e) {
                log.error("OAuth2 login error", e);
            }
        }
        IRequestParameters pp = RequestCycle.get().getRequest().getPostParameters();
        StringValue login = pp.getParameterValue("login");
        StringValue password = pp.getParameterValue("password");
        if (!login.isEmpty() && !password.isEmpty()) {
            try {
                if (WebSession.get().signIn(login.toString(), password.toString(), User.Type.USER, null)) {
                    this.setResponsePage(Application.get().getHomePage());
                } else {
                    log.error("Failed to login using POST parameters passed");
                }
            }
            catch (OmException e) {
                log.error("Exception while login with POST parameters passed", (Throwable)e);
            }
        }
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.signin = new SignInDialog("signin");
        this.add(new Component[]{this.signin.setVisible(!WebSession.get().isKickedByAdmin()), this.r.setVisible(this.allowRegister()), this.forget, this.kick.setVisible(WebSession.get().isKickedByAdmin())});
        this.add(new Component[]{this.forgetInfoDialog.header((IModel)new ResourceModel("312")).addButton((Component)OmModalCloseButton.of("54")).setUseCloseHandler(true)});
        this.add(new Component[]{this.registerInfoDialog.header((IModel)new ResourceModel("235")).addButton((Component)OmModalCloseButton.of("54")).setUseCloseHandler(true)});
        this.add(new Component[]{this.otpDialog});
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('#signin-dialog, #register-dialog, #forget-dialog').on('shown.bs.modal', function () {\n\t$(this).find('.auto-focus').trigger('focus');\n})\n"));
    }

    boolean allowRegister() {
        return OpenmeetingsVariables.isAllowRegisterFrontend();
    }

    boolean allowOAuthLogin() {
        return !this.oauthDao.getActive().isEmpty();
    }

    protected void onParameterArrival(IRequestParameters params, AjaxRequestTarget arg1) {
        WebSession.get().setArea(this.getUrlFragment(params));
    }
}

