/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.LanguageDropDown;
import org.apache.openmeetings.web.common.datetime.AjaxOmDatePicker;
import org.apache.openmeetings.web.util.CountryDropDown;
import org.apache.openmeetings.web.util.RestrictiveChoiceProvider;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidator;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2MultiChoice;

public class GeneralUserForm
extends Form<User> {
    private static final long serialVersionUID = 1L;
    private final RequiredTextField<String> email = new RequiredTextField("address.email");
    private final List<GroupUser> grpUsers = new ArrayList<GroupUser>();
    private final AjaxOmDatePicker bday = new AjaxOmDatePicker("age");
    private final boolean isAdminForm;
    @SpringBean
    private GroupDao groupDao;
    @SpringBean
    private UserDao userDao;

    public GeneralUserForm(String id, IModel<User> model, boolean isAdminForm) {
        super(id, model);
        this.isAdminForm = isAdminForm;
        this.updateModelObject((User)this.getModelObject(), isAdminForm);
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.email});
        this.email.setLabel((IModel)new ResourceModel("119"));
        this.email.add((IValidator)RfcCompliantEmailAddressValidator.getInstance());
        this.add(new Component[]{new DropDownChoice("salutation", List.of(User.Salutation.values()), (IChoiceRenderer)new ChoiceRenderer<User.Salutation>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(User.Salutation object) {
                return GeneralUserForm.this.getString("user.salutation." + object.name());
            }

            public String getIdValue(User.Salutation object, int index) {
                return object.name();
            }
        })});
        this.add(new Component[]{new TextField("firstname")});
        this.add(new Component[]{new TextField("lastname")});
        this.add(new Component[]{new TextField("displayName").setEnabled(this.isAdminForm || OpenmeetingsVariables.isDisplayNameEditable())});
        this.add(new Component[]{new DropDownChoice("timeZoneId", WebSession.AVAILABLE_TIMEZONES)});
        this.add(new Component[]{new LanguageDropDown("languageId")});
        this.add(new Component[]{new TextField("address.phone")});
        this.add(new Component[]{this.bday});
        this.add(new Component[]{new TextField("address.street")});
        this.add(new Component[]{new TextField("address.additionalname")});
        this.add(new Component[]{new TextField("address.zip")});
        this.add(new Component[]{new TextField("address.town")});
        this.add(new Component[]{new CountryDropDown("address.country")});
        this.add(new Component[]{new TextArea("address.comment")});
        this.add(new Component[]{new Select2MultiChoice("groupUsers", null, (ChoiceProvider)new RestrictiveChoiceProvider<GroupUser>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(GroupUser choice) {
                return choice.getGroup().getName();
            }

            @Override
            public String toId(GroupUser choice) {
                Long id = choice.getGroup().getId();
                return id == null ? null : "" + id;
            }

            public void query(String term, int page, Response<GroupUser> response) {
                for (GroupUser ou : GeneralUserForm.this.grpUsers) {
                    if (!Strings.isEmpty((String)term) && !ou.getGroup().getName().contains(term)) continue;
                    response.add((Object)ou);
                }
            }

            @Override
            public GroupUser fromId(String inId) {
                Long id = Long.parseLong(inId);
                User u = (User)GeneralUserForm.this.getModelObject();
                Group g = GeneralUserForm.this.groupDao.get(id);
                GroupUser gu = new GroupUser(g, u);
                int idx = GeneralUserForm.this.grpUsers.indexOf(gu);
                return idx < 0 ? gu : GeneralUserForm.this.grpUsers.get(idx);
            }
        }).setLabel((IModel)new ResourceModel("161")).setRequired(this.isAdminForm && AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights())).setEnabled(this.isAdminForm)});
    }

    public void updateModelObject(User u, boolean isAdminForm) {
        this.grpUsers.clear();
        this.grpUsers.addAll(u.getGroupUsers());
        if (isAdminForm) {
            List grpList = AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights()) ? this.groupDao.adminGet(null, WebSession.getUserId(), 0L, Integer.MAX_VALUE, null) : this.groupDao.get(0L, Integer.MAX_VALUE);
            for (Group g : grpList) {
                GroupUser gu = new GroupUser(g, u);
                int idx = this.grpUsers.indexOf(gu);
                if (idx >= 0) continue;
                this.grpUsers.add(gu);
            }
        }
    }

    protected void onValidate() {
        User u = (User)this.getModelObject();
        if (!this.userDao.checkEmail((String)this.email.getConvertedInput(), u.getType(), u.getDomainId(), u.getId())) {
            this.error((Serializable)((Object)this.getString("error.email.inuse")));
        }
        super.onValidate();
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }
}

