/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.rooms;

import de.agilecoders.wicket.core.markup.html.bootstrap.badge.BootstrapBadge;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.room.RoomModerator;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.admin.AdminUserChoiceProvider;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.util.RestrictiveChoiceProvider;
import org.apache.openmeetings.web.util.RoomTypeDropDown;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2Choice;
import org.wicketstuff.select2.Select2MultiChoice;

public class RoomForm
extends AdminBaseForm<Room> {
    private static final long serialVersionUID = 1L;
    private static final List<Long> DROPDOWN_NUMBER_OF_PARTICIPANTS = List.of(2L, 4L, 6L, 8L, 10L, 12L, 14L, 16L, 20L, 25L, 32L, 50L, 100L, 150L, 200L, 500L, 1000L);
    private final WebMarkupContainer roomList;
    private final TextField<String> pin = new TextField("pin");
    private final WebMarkupContainer moderatorContainer = new WebMarkupContainer("moderatorContainer");
    private final WebMarkupContainer filesContainer = new WebMarkupContainer("filesContainer");
    private final WebMarkupContainer clientsContainer = new WebMarkupContainer("clientsContainer");
    private final ListView<Client> clients = new ListView<Client>("clients", new ArrayList()){
        private static final long serialVersionUID = 1L;

        protected void populateItem(final ListItem<Client> item) {
            Client c = (Client)item.getModelObject();
            BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("clientDelete", Buttons.Type.Outline_Danger){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Application.kickUser((Client)item.getModelObject());
                    RoomForm.this.updateClients(target);
                }
            };
            del.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
            item.add(new Component[]{new Label("clientId", (Serializable)((Object)("" + c.getUserId())))}).add(new Component[]{new Label("clientLogin", (Serializable)((Object)c.getUser().getLogin()))}).add(new Component[]{del});
        }
    };
    private IModel<User> moderator2add = Model.of((Serializable)((User)null));
    private IModel<Collection<BaseFileItem>> files2add = new CollectionModel(new ArrayList());
    private IModel<Long> wbIdx = Model.of((Serializable)Long.valueOf(0L));
    @SpringBean
    private GroupDao groupDao;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private FileItemDao fileDao;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private RoomDao roomDao;

    public RoomForm(String id, WebMarkupContainer roomList, Room room) {
        super(id, new CompoundPropertyModel((Object)(room == null ? RoomForm.newRoom() : room)));
        this.roomList = roomList;
        this.setOutputMarkupId(true);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        RequiredTextField name = new RequiredTextField("name");
        name.setLabel((IModel)new ResourceModel("165"));
        this.add(new Component[]{name});
        TextField tag = new TextField("tag");
        tag.add((IValidator)StringValidator.maximumLength((int)10));
        tag.setLabel((IModel)new ResourceModel("admin.group.form.tag"));
        this.add(new Component[]{tag});
        this.add(new Component[]{new DropDownChoice("capacity", DROPDOWN_NUMBER_OF_PARTICIPANTS, (IChoiceRenderer)new ChoiceRenderer<Long>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(Long id) {
                return id;
            }

            public String getIdValue(Long id, int index) {
                return "" + id;
            }
        })});
        this.add(new Component[]{new RoomTypeDropDown("type").setRequired(true).setLabel((IModel)new ResourceModel("45"))});
        this.add(new Component[]{new TextArea("comment")});
        boolean isGroupAdmin = AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights());
        this.add(new Component[]{new CheckBox("appointment").setEnabled(false)});
        this.add(new Component[]{new CheckBox("ispublic").setEnabled(!isGroupAdmin)});
        final List orgList = isGroupAdmin ? this.groupDao.adminGet(null, WebSession.getUserId(), 0L, Integer.MAX_VALUE, null) : this.groupDao.get(0L, Integer.MAX_VALUE);
        final ArrayList<RoomGroup> orgRooms = new ArrayList<RoomGroup>(orgList.size());
        for (Group org : orgList) {
            orgRooms.add(new RoomGroup(org, (Room)this.getModelObject()));
        }
        this.add(new Component[]{new Select2MultiChoice("groups", null, (ChoiceProvider)new RestrictiveChoiceProvider<RoomGroup>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(RoomGroup choice) {
                String name = choice.getGroup().getName();
                return name == null ? "" : name;
            }

            @Override
            public String toId(RoomGroup choice) {
                Long id = choice.getGroup().getId();
                return id == null ? null : "" + id;
            }

            public void query(String term, int page, Response<RoomGroup> response) {
                response.addAll(orgRooms.stream().filter(rg -> Strings.isEmpty((String)term) || rg.getGroup().getName().contains(term)).toList());
            }

            @Override
            public RoomGroup fromId(String inId) {
                Long id = Long.valueOf(inId);
                if (orgList.stream().noneMatch(g -> g.getId().equals(id))) {
                    return null;
                }
                Group g2 = RoomForm.this.groupDao.get(id);
                return new RoomGroup(g2, (Room)RoomForm.this.getModelObject());
            }
        }).setLabel((IModel)new ResourceModel("828")).setRequired(isGroupAdmin)});
        this.add(new Component[]{new CheckBox("isDemoRoom")});
        TextField demoTime = new TextField("demoTime");
        demoTime.setLabel((IModel)new Model((Serializable)((Object)this.getString("637"))));
        this.add(new Component[]{demoTime});
        this.add(new Component[]{new CheckBox("allowUserQuestions")});
        this.add(new Component[]{new CheckBox("audioOnly")});
        this.add(new Component[]{new CheckBox("closed")});
        this.add(new Component[]{new TextField("redirectURL")});
        this.add(new Component[]{new CheckBox("waitRecording")});
        this.add(new Component[]{new CheckBox("allowRecording").setEnabled(OpenmeetingsVariables.isRecordingsEnabled())});
        this.add(new Component[]{new CheckBox("chatModerated")});
        this.add(new Component[]{new Select2MultiChoice("hiddenElements", null, (ChoiceProvider)new ChoiceProvider<Room.RoomElement>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(Room.RoomElement choice) {
                return choice.name();
            }

            public String getIdValue(Room.RoomElement choice) {
                return choice.name();
            }

            public void query(String term, int page, Response<Room.RoomElement> response) {
                for (Room.RoomElement r : Room.RoomElement.values()) {
                    if (!Strings.isEmpty((String)term) && !r.name().contains(term)) continue;
                    response.add((Object)r);
                }
            }

            public Collection<Room.RoomElement> toChoices(Collection<String> ids) {
                ArrayList<Room.RoomElement> rights = new ArrayList<Room.RoomElement>(ids.size());
                for (String id : ids) {
                    rights.add(Room.RoomElement.valueOf((String)id));
                }
                return rights;
            }
        })});
        this.add(new Component[]{new CheckBox("chatOpened")});
        this.add(new Component[]{new CheckBox("filesOpened")});
        Select2Choice moderatorChoice = new Select2Choice("moderator2add", this.moderator2add, (ChoiceProvider)new AdminUserChoiceProvider(){
            private static final long serialVersionUID = 1L;

            @Override
            public void query(String term, int page, Response<User> response) {
                response.addAll((Collection)RoomForm.this.userDao.get(term, false, (long)page * 20L, 20L));
                response.setHasMore(Boolean.valueOf(20L == (long)response.getResults().size()));
            }

            public String getDisplayValue(User choice) {
                Address a = choice.getAddress();
                return String.format("\"%s\" <%s>", choice.getDisplayName(), a == null ? "" : a.getEmail());
            }
        });
        moderatorChoice.getSettings().setCloseOnSelect(true);
        this.add(new Component[]{moderatorChoice.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {
            Room r = (Room)this.getModelObject();
            User u = (User)this.moderator2add.getObject();
            boolean found = false;
            if (u != null) {
                if (r.getModerators() == null) {
                    r.setModerators(new ArrayList());
                }
                for (RoomModerator rm : r.getModerators()) {
                    if (!rm.getUser().getId().equals(u.getId())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    RoomModerator rm = new RoomModerator();
                    rm.setRoomId(r.getId());
                    rm.setUser(u);
                    r.getModerators().add(0, rm);
                    this.moderator2add.setObject(null);
                    target.add(new Component[]{this.moderatorContainer, moderatorChoice});
                }
            }
        })}).setOutputMarkupId(true)});
        this.add(new Component[]{this.moderatorContainer.add(new Component[]{new ListView<RoomModerator>("moderators"){
            private static final long serialVersionUID = 1L;

            protected void populateItem(final ListItem<RoomModerator> item) {
                RoomModerator moderator = (RoomModerator)item.getModelObject();
                Label name = new Label("uName", (Serializable)((Object)moderator.getUser().getDisplayName()));
                BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("delete", Buttons.Type.Outline_Danger){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        ((Room)RoomForm.this.getModelObject()).getModerators().remove(item.getIndex());
                        target.add(new Component[]{RoomForm.this.moderatorContainer});
                    }
                };
                del.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
                item.add(new Component[]{new CheckBox("superModerator", (IModel)new PropertyModel((Object)moderator, "superModerator"))}).add(new Component[]{new Label("userId", (Serializable)((Object)String.valueOf(moderator.getUser().getId())))}).add(new Component[]{name}).add(new Component[]{new Label("email", (Serializable)((Object)moderator.getUser().getAddress().getEmail()))}).add(new Component[]{del}).add(new Component[]{new BootstrapBadge("new", (IModel)new ResourceModel("lbl.new"), BackgroundColorBehavior.Color.Warning).setVisible(moderator.getId() == null)});
            }
        }}).setOutputMarkupId(true)});
        this.add(new Component[]{new CheckBox("moderated")});
        this.add(new Component[]{new CheckBox("waitModerator")});
        final Form filesForm = new Form("filesForm");
        this.add(new Component[]{filesForm.add(new Component[]{new Select2MultiChoice("files2add", this.files2add, (ChoiceProvider)new ChoiceProvider<BaseFileItem>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(BaseFileItem f) {
                return f.getName();
            }

            public String getIdValue(BaseFileItem f) {
                return "" + f.getId();
            }

            public void query(String term, int page, Response<BaseFileItem> response) {
                response.addAll((Collection)RoomForm.this.fileDao.getAllRoomFiles(term, (long)page * 20L, 20L, ((Room)RoomForm.this.getModelObject()).getId(), orgList));
                response.setHasMore(Boolean.valueOf(20L == (long)response.getResults().size()));
            }

            public Collection<BaseFileItem> toChoices(Collection<String> ids) {
                return RoomForm.this.fileDao.get(ids);
            }
        }).setLabel((IModel)new ResourceModel("245"))}).add(new Component[]{new TextField<Long>("wbidx", this.wbIdx){
            private static final long serialVersionUID = 1L;

            protected String[] getInputTypes() {
                return new String[]{"number"};
            }
        }}).add(new Component[]{new BootstrapAjaxButton("addFiles", (IModel)new ResourceModel("1261"), filesForm, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                Room r = (Room)RoomForm.this.getModelObject();
                if (r.getFiles() == null) {
                    r.setFiles(new ArrayList());
                }
                for (BaseFileItem f : (Collection)RoomForm.this.files2add.getObject()) {
                    r.getFiles().add(new RoomFile(r.getId(), f, ((Long)RoomForm.this.wbIdx.getObject()).longValue()));
                }
                target.add(new Component[]{RoomForm.this.filesContainer, filesForm});
            }
        }}).setOutputMarkupId(true)});
        this.add(new Component[]{this.filesContainer.add(new Component[]{new ListView<RoomFile>("files"){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<RoomFile> item) {
                final RoomFile rf = (RoomFile)item.getModelObject();
                BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("delete", Buttons.Type.Outline_Danger){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        Room r = (Room)RoomForm.this.getModelObject();
                        Iterator iter = r.getFiles().iterator();
                        while (iter.hasNext()) {
                            RoomFile curRf = (RoomFile)iter.next();
                            if (!curRf.getFile().getId().equals(rf.getFile().getId())) continue;
                            iter.remove();
                            break;
                        }
                        target.add(new Component[]{RoomForm.this.filesContainer});
                    }
                };
                del.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
                item.add(new Component[]{new Label("name", (IModel)new PropertyModel((Object)rf.getFile(), "name"))}).add(new Component[]{new Label("wbIdx", (IModel)new PropertyModel((Object)rf, "wbIdx"))}).add(new Component[]{del});
            }
        }}).setOutputMarkupId(true)});
        this.add(new Component[]{this.clientsContainer.add(new Component[]{this.clients.setOutputMarkupId(true)}).setOutputMarkupId(true)});
        this.add(new Component[]{new TextField("confno").setEnabled(false)});
        this.add(new Component[]{this.pin});
        this.pin.setEnabled(((Room)this.getModelObject()).isSipEnabled());
        this.add(new Component[]{new TextField("ownerId").setEnabled(false)});
        this.add(new Component[]{new AjaxCheckBox("sipEnabled"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                RoomForm.this.updateView(target);
            }
        }.setOutputMarkupId(true)});
    }

    void updateClients(AjaxRequestTarget target) {
        long roomId = ((Room)this.getModelObject()).getId() != null ? ((Room)this.getModelObject()).getId() : 0L;
        this.clients.setDefaultModelObject(this.cm.streamByRoom(roomId).toList());
        target.add(new Component[]{this.clientsContainer});
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        Room r = (Room)this.getModelObject();
        boolean newRoom = r.getId() == null;
        r = this.roomDao.update(r, WebSession.getUserId());
        if (newRoom) {
            for (RoomModerator rm : r.getModerators()) {
                rm.setRoomId(r.getId());
            }
            for (RoomFile rf : r.getFiles()) {
                rf.setRoomId(r.getId());
            }
            this.roomDao.update((Room)this.getModelObject(), WebSession.getUserId());
        }
        this.setNewRecordVisible(false);
        this.updateView(target);
    }

    private static Room newRoom() {
        Room r = new Room();
        r.hide(Room.RoomElement.MICROPHONE_STATUS);
        return r;
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(RoomForm.newRoom());
        this.updateView(target);
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        Room r = (Room)this.getModelObject();
        r = r.getId() != null ? this.roomDao.get(r.getId()) : RoomForm.newRoom();
        this.setModelObject(r);
        this.updateView(target);
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.roomDao.delete((Room)this.getModelObject(), WebSession.getUserId());
        target.add(new Component[]{this.roomList});
        this.setModelObject(RoomForm.newRoom());
        this.updateView(target);
    }

    public void updateView(AjaxRequestTarget target) {
        this.moderator2add.setObject(null);
        ((Collection)this.files2add.getObject()).clear();
        this.wbIdx.setObject((Object)0L);
        target.add(new Component[]{this});
        target.add(new Component[]{this.roomList});
        target.add(new Component[]{this.pin.setEnabled(((Room)this.getModelObject()).isSipEnabled())});
        this.updateClients(target);
    }

    protected void onDetach() {
        this.moderator2add.detach();
        this.files2add.detach();
        this.wbIdx.detach();
        super.onDetach();
    }
}

