/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.email;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.basic.MailMessageDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.util.DateLabel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class EmailForm
extends Form<MailMessage> {
    private static final long serialVersionUID = 1L;
    private final Label status = new Label("status", (IModel)Model.of((Serializable)((Object)"")));
    private BootstrapAjaxButton reset;
    private AjaxLink<Void> delBtn;
    private final WebMarkupContainer list;
    @SpringBean
    private MailMessageDao emailDao;

    public EmailForm(String id, WebMarkupContainer list, MailMessage m) {
        super(id, (IModel)new CompoundPropertyModel((Object)m));
        this.list = list;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.status});
        this.add(new Component[]{new Label("subject")});
        this.add(new Component[]{new Label("recipients")});
        this.add(new Component[]{new Label("body").setEscapeModelStrings(false)});
        this.add(new Component[]{new DateLabel("inserted")});
        this.add(new Component[]{new DateLabel("updated")});
        this.add(new Component[]{new Label("errorCount")});
        this.add(new Component[]{new Label("lastError")});
        Component[] componentArray = new Component[1];
        this.reset = new BootstrapAjaxButton("reset", (IModel)new ResourceModel("admin.email.reset.status"), Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                EmailForm.this.emailDao.resetSendingStatus(((MailMessage)EmailForm.this.getModelObject()).getId());
                target.add(new Component[]{EmailForm.this.list});
            }
        };
        componentArray[0] = this.reset;
        this.add(componentArray);
        this.reset.setEnabled(false);
        this.delBtn = new AjaxLink<Void>("btn-delete"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                EmailForm.this.emailDao.delete(((MailMessage)EmailForm.this.getModelObject()).getId());
                EmailForm.this.setModelObject(new MailMessage());
                target.add(new Component[]{EmailForm.this.list, EmailForm.this});
            }
        };
        this.delBtn.add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
        this.add(new Component[]{this.delBtn.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true).setVisible(false)});
    }

    protected void onModelChanged() {
        super.onModelChanged();
        MailMessage m = (MailMessage)this.getModelObject();
        this.delBtn.setVisible(m.getId() != null);
        this.status.setDefaultModelObject((Object)this.getString("admin.email.status." + m.getStatus().name()));
        this.reset.setEnabled(m.getId() != null && MailMessage.Status.ERROR == m.getStatus());
    }
}

