/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class DashboardSettings {
    private static final MetaDataKey<DashboardSettings> KEY = new MetaDataKey<DashboardSettings>(){};
    private ResourceReference javaScriptReference = new PackageResourceReference(DashboardSettings.class, "res/dashboard.js");
    private ResourceReference cssReference = new PackageResourceReference(DashboardSettings.class, "res/dashboard.css");
    private ResourceReference rtlCssReference = new PackageResourceReference(DashboardSettings.class, "res/dashboard-rtl.css");
    private ResourceReference jqueryUIReference = new PackageResourceReference(DashboardSettings.class, "res/jquery-ui-1.13.0.min.js");
    private ResourceReference jqueryJsonReference = new PackageResourceReference(DashboardSettings.class, "res/jquery.json-2.2.min.js");
    private boolean includeJQueryUI = true;
    @Deprecated(since="9.8.0", forRemoval=true)
    private boolean includeJQueryJson = false;
    private boolean includeJavaScript = true;
    private boolean includeCss = true;
    @Deprecated(since="9.8.0", forRemoval=true)
    private boolean rtl = false;

    private DashboardSettings() {
    }

    public boolean isIncludeJQueryUI() {
        return this.includeJQueryUI;
    }

    public DashboardSettings setIncludeJQueryUI(boolean includeJQueryUI) {
        this.includeJQueryUI = includeJQueryUI;
        return this;
    }

    @Deprecated(since="9.8.0", forRemoval=true)
    public boolean isIncludeJQueryJson() {
        return this.includeJQueryJson;
    }

    @Deprecated(since="9.8.0", forRemoval=true)
    public void setIncludeJQueryJson(boolean includeJQueryJson) {
        this.includeJQueryJson = includeJQueryJson;
    }

    public boolean isIncludeJavaScript() {
        return this.includeJavaScript;
    }

    public DashboardSettings setIncludeJavascript(boolean includeJavaScript) {
        this.includeJavaScript = includeJavaScript;
        return this;
    }

    public boolean isIncludeCss() {
        return this.includeCss;
    }

    public DashboardSettings setIncludeCss(boolean includeCss) {
        this.includeCss = includeCss;
        return this;
    }

    public ResourceReference getJQueryUIReference() {
        return this.jqueryUIReference;
    }

    public DashboardSettings setJQueryUIReference(ResourceReference jqueryUIReference) {
        this.jqueryUIReference = jqueryUIReference;
        return this;
    }

    public ResourceReference getJQueryJsonReference() {
        return this.jqueryJsonReference;
    }

    public DashboardSettings setJQueryJsonReference(ResourceReference jqueryJsonReference) {
        this.jqueryJsonReference = jqueryJsonReference;
        return this;
    }

    public ResourceReference getJavaScriptReference() {
        return this.javaScriptReference;
    }

    public DashboardSettings setJavaScriptReference(ResourceReference javaScriptReference) {
        this.javaScriptReference = javaScriptReference;
        return this;
    }

    public ResourceReference getCssReference() {
        return this.cssReference;
    }

    public DashboardSettings setCssReference(ResourceReference cssReference) {
        this.cssReference = cssReference;
        return this;
    }

    public ResourceReference getRtlCssReference() {
        return this.rtlCssReference;
    }

    public DashboardSettings setRtlCssReference(ResourceReference rtlCssReference) {
        this.rtlCssReference = rtlCssReference;
        return this;
    }

    @Deprecated(since="9.8.0", forRemoval=true)
    public boolean isRtl() {
        return this.rtl;
    }

    @Deprecated(since="9.8.0", forRemoval=true)
    public void setRtl(boolean rtl) {
        this.rtl = rtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DashboardSettings get() {
        Application application = Application.get();
        DashboardSettings settings = (DashboardSettings)application.getMetaData(KEY);
        if (settings == null) {
            Application application2 = application;
            synchronized (application2) {
                settings = (DashboardSettings)application.getMetaData(KEY);
                if (settings == null) {
                    settings = new DashboardSettings();
                    application.setMetaData(KEY, (Object)settings);
                }
            }
        }
        return (DashboardSettings)application.getMetaData(KEY);
    }
}

