/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.plugins.datepicker;

import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.event.IValueChangedListener;
import com.googlecode.wicket.jquery.core.utils.DateUtils;
import com.googlecode.wicket.jquery.ui.plugins.datepicker.DateRange;
import com.googlecode.wicket.jquery.ui.plugins.datepicker.RangeDatePicker;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;

@Deprecated
public class RangeDatePickerTextField
extends FormComponentPanel<DateRange>
implements IValueChangedListener {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = " - ";
    private TextField<DateRange> input;
    private RangeDatePicker datepicker;
    protected final Options options;

    public RangeDatePickerTextField(String id) {
        this(id, new Options("calendars", (Object)3));
    }

    public RangeDatePickerTextField(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public RangeDatePickerTextField(String id, IModel<DateRange> model) {
        this(id, model, new Options("calendars", (Object)3));
    }

    public RangeDatePickerTextField(String id, IModel<DateRange> model, Options options) {
        super(id, model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public void convertInput() {
        this.setConvertedInput((DateRange)this.input.getConvertedInput());
    }

    protected String getSeparator() {
        return SEPARATOR;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.input = this.newTextField("text", (IModel<DateRange>)this.getModel());
        this.input.setOutputMarkupId(true);
        this.input.add(new Behavior[]{this.newToggleBehavior()});
        this.add(new Component[]{this.input});
        this.datepicker = new RangeDatePicker("datepicker", this.getModel(), this.options){
            private static final long serialVersionUID = 1L;

            @Override
            public void onValueChanged(IPartialPageRequestHandler handler) {
                RangeDatePickerTextField.this.input.modelChanged();
                RangeDatePickerTextField.this.onValueChanged(handler);
                handler.add(new Component[]{RangeDatePickerTextField.this.input});
            }
        };
        this.add(new Component[]{this.datepicker});
    }

    public void onValueChanged(IPartialPageRequestHandler handler) {
    }

    protected DateFormat newDateFormat(Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy", locale);
        df.setTimeZone(DateUtils.UTC);
        return df;
    }

    protected DateRange newDateRange(Date start, Date end) {
        return DateRange.of(start.getTime(), end.getTime());
    }

    private TextField<DateRange> newTextField(String id, IModel<DateRange> model) {
        return new TextField<DateRange>(id, model, DateRange.class){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                if (DateRange.class.isAssignableFrom(type)) {
                    return RangeDatePickerTextField.this.newConverter();
                }
                return super.getConverter(type);
            }
        };
    }

    protected <C> IConverter<C> newConverter() {
        return new IConverter<DateRange>(){
            private static final long serialVersionUID = 1L;

            public DateRange convertToObject(String value, Locale locale) {
                DateFormat df = RangeDatePickerTextField.this.newDateFormat(locale);
                String[] dates = value.split(RangeDatePickerTextField.this.getSeparator());
                try {
                    return RangeDatePickerTextField.this.newDateRange(df.parse(dates[0]), df.parse(dates[1]));
                }
                catch (ParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(DateRange value, Locale locale) {
                DateFormat df = RangeDatePickerTextField.this.newDateFormat(locale);
                return String.format("%s%s%s", df.format(value.getStart()), RangeDatePickerTextField.this.getSeparator(), df.format(value.getEnd()));
            }
        };
    }

    private JQueryAbstractBehavior newToggleBehavior() {
        return new JQueryAbstractBehavior(){
            private static final long serialVersionUID = 1L;

            protected String $() {
                StringBuilder statements = new StringBuilder();
                statements.append("jQuery('#").append(RangeDatePickerTextField.this.input.getMarkupId()).append("').on('click', function() { ");
                statements.append("\t\tjQuery('#").append(RangeDatePickerTextField.this.datepicker.getMarkupId()).append("').DatePickerShow(); ");
                statements.append("} );");
                return statements.toString();
            }
        };
    }
}

