/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import com.github.openjson.JSONStringer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.RestrictiveChoiceProvider;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.Validatable;
import org.wicketstuff.select2.Response;

public class UserChoiceProvider
extends RestrictiveChoiceProvider<User> {
    private static final long serialVersionUID = 1L;
    private static final long PAGE_SIZE = 10L;
    private final Map<String, User> newContacts = new HashMap<String, User>();
    @SpringBean
    private UserDao userDao;

    public UserChoiceProvider() {
        Injector.get().inject((Object)this);
    }

    public User getUser(String value) {
        User u = null;
        if (!Strings.isEmpty((String)value)) {
            String email = null;
            String fName = null;
            String lName = null;
            int idx = value.indexOf(60);
            if (idx > -1) {
                int idx1 = value.indexOf(62, idx);
                if (idx1 > -1) {
                    email = value.substring(idx + 1, idx1);
                    String name = value.substring(0, idx).replace("\"", "");
                    int idx2 = name.indexOf(32);
                    if (idx2 > -1) {
                        fName = name.substring(0, idx2);
                        lName = name.substring(idx2 + 1);
                    } else {
                        fName = "";
                        lName = name;
                    }
                }
            } else {
                email = value;
            }
            if (!Strings.isEmpty((String)email)) {
                Validatable valEmail = new Validatable((Object)email);
                RfcCompliantEmailAddressValidator.getInstance().validate((IValidatable)valEmail);
                if (valEmail.isValid()) {
                    u = this.userDao.getContact(email, fName, lName, WebSession.getUserId());
                }
            }
        }
        return u;
    }

    @Override
    public String toId(User u) {
        Object id = "" + u.getId();
        if (u.getId() == null) {
            this.newContacts.put(u.getLogin(), u);
            id = u.getLogin();
        }
        return id;
    }

    public String getDisplayValue(User object) {
        return FormatHelper.formatUser((User)object, (boolean)true);
    }

    public void query(String term, int page, Response<User> response) {
        User c = this.getUser(term);
        if (c != null) {
            response.add((Object)c);
        }
        response.addAll((Collection)this.userDao.get(term, (long)page * 10L, 10L, null, true, WebSession.getUserId()));
        response.setHasMore(Boolean.valueOf((long)page < this.userDao.countUsers(term, WebSession.getUserId()) / 10L));
    }

    @Override
    public User fromId(String id) {
        User u = this.newContacts.containsKey(id) ? this.newContacts.get(id) : this.userDao.get(Long.valueOf(id));
        return u;
    }

    public void toJson(User choice, JSONStringer stringer) {
        super.toJson((Object)choice, stringer);
        stringer.key("contact").value(choice.getType() == User.Type.CONTACT);
    }
}

