/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.PagingNavigatorPanel;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserSearchPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_USER_ID = "data-user-id";
    private static final List<Integer> itemsPerPage = List.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(75), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(500), Integer.valueOf(1000), Integer.valueOf(2500), Integer.valueOf(5000));
    private static final SortParam<String> orderBy = new SortParam((Object)"firstname", true);
    private final TextField<String> text = new TextField("text", (IModel)Model.of((Serializable)((Object)"")));
    private final TextField<String> search = new TextField("search", (IModel)Model.of((Serializable)((Object)"")));
    private final TextField<String> offer = new TextField("offer", (IModel)Model.of((Serializable)((Object)"")));
    private boolean searched = false;
    private final WebMarkupContainer container = new WebMarkupContainer("container");
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private UserContactDao contactDao;
    @SpringBean
    private ClientManager cm;

    public UserSearchPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.container.add(new Component[]{new Form<Void>("form"){
            private static final long serialVersionUID = 1L;

            protected void onInitialize() {
                super.onInitialize();
                this.add(new Component[]{UserSearchPanel.this.text, UserSearchPanel.this.offer, UserSearchPanel.this.search});
                this.add(new Component[]{new BootstrapAjaxButton("submit", (IModel)new ResourceModel("714"), Buttons.Type.Outline_Primary){
                    private static final long serialVersionUID = 1L;

                    protected void onSubmit(AjaxRequestTarget target) {
                        UserSearchPanel.this.searched = true;
                        UserSearchPanel.this.refresh((IPartialPageRequestHandler)target);
                    }
                }});
            }
        }});
        IDataProvider<User> dp = new IDataProvider<User>(){
            private static final long serialVersionUID = 1L;

            public Iterator<? extends User> iterator(long first, long count) {
                return UserSearchPanel.this.searched ? UserSearchPanel.this.userDao.searchUserProfile(WebSession.getUserId(), (String)UserSearchPanel.this.text.getModelObject(), (String)UserSearchPanel.this.offer.getModelObject(), (String)UserSearchPanel.this.search.getModelObject(), orderBy, first, count).iterator() : Collections.emptyIterator();
            }

            public long size() {
                return UserSearchPanel.this.searched ? UserSearchPanel.this.userDao.searchCountUserProfile(WebSession.getUserId(), (String)UserSearchPanel.this.text.getModelObject(), (String)UserSearchPanel.this.offer.getModelObject(), (String)UserSearchPanel.this.search.getModelObject()) : 0L;
            }

            public IModel<User> model(User object) {
                return new CompoundPropertyModel((Object)object);
            }
        };
        DataView<User> dw = new DataView<User>("users", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<User> item) {
                User u = (User)item.getModelObject();
                long userId = u.getId();
                item.add(new Component[]{new WebMarkupContainer("status").add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)(UserSearchPanel.this.cm.isOnline(userId) ? "online" : "offline")))})});
                item.add(new Component[]{new Label("name", (Serializable)((Object)u.getDisplayName()))});
                item.add(new Component[]{new Label("tz", (Serializable)((Object)TimezoneUtil.getTimeZone((User)u).getID()))});
                item.add(new Component[]{new Label("offer", (Serializable)((Object)u.getUserOffers()))});
                item.add(new Component[]{new Label("search", (Serializable)((Object)u.getUserSearchs()))});
                item.add(new Component[]{new WebMarkupContainer("view").add(new Behavior[]{AttributeModifier.append((String)UserSearchPanel.ATTR_USER_ID, (Serializable)Long.valueOf(userId))})});
                item.add(new Component[]{new WebMarkupContainer("add").setVisible(userId != WebSession.getUserId() && !UserSearchPanel.this.contactDao.isContact(Long.valueOf(userId), WebSession.getUserId())).add(new Behavior[]{AttributeModifier.append((String)UserSearchPanel.ATTR_USER_ID, (Serializable)Long.valueOf(userId))})});
                item.add(new Component[]{new WebMarkupContainer("message").setVisible(userId != WebSession.getUserId()).add(new Behavior[]{AttributeModifier.append((String)UserSearchPanel.ATTR_USER_ID, (Serializable)Long.valueOf(userId))})});
                item.add(new Component[]{new WebMarkupContainer("invite").setVisible(userId != WebSession.getUserId()).add(new Behavior[]{AttributeModifier.append((String)UserSearchPanel.ATTR_USER_ID, (Serializable)Long.valueOf(userId))})});
            }
        };
        this.add(new Component[]{this.container.add(new Component[]{dw, new PagingNavigatorPanel("navigator", (DataView)dw, itemsPerPage, 100){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                UserSearchPanel.this.refresh((IPartialPageRequestHandler)target);
            }
        }}).setOutputMarkupId(true)});
    }

    private void refresh(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this.container});
        handler.appendJavaScript((CharSequence)"$('#searchUsersTable .contact-add.om-icon.clickable').off().click(function() {addContact($(this).data('user-id'));});");
        handler.appendJavaScript((CharSequence)"$('#searchUsersTable .new-msg.om-icon.clickable').off().click(function() {privateMessage($(this).data('user-id'));});");
        handler.appendJavaScript((CharSequence)"$('#searchUsersTable .profile.om-icon.clickable').off().click(function() {showUserInfo($(this).data('user-id'));});");
        handler.appendJavaScript((CharSequence)"$('#searchUsersTable .invite.om-icon.clickable').off().click(function() {inviteUser($(this).data('user-id'));});");
    }

    @Override
    public void onNewMessageClose(IPartialPageRequestHandler handler) {
        this.refresh(handler);
    }
}

