/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.db.dao.room.ExtraMenuDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.entity.room.ExtraMenu;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.web.common.menu.OmMenuItem;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ExtrasSubMenu
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RoomPanel room;
    private OmMenuItem extraMenu;
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private ExtraMenuDao menuDao;

    public ExtrasSubMenu(RoomPanel room) {
        this.room = room;
    }

    public void init() {
        Injector.get().inject((Object)this);
        this.extraMenu = new OmMenuItem(this.room.getString("menu.extras"), null, false);
        List<Long> groups = this.roomDao.get(this.room.getRoom().getId()).getGroups().stream().map(RoomGroup::getGroup).map(Group::getId).toList();
        for (final ExtraMenu em : this.menuDao.getByGroups(groups)) {
            this.extraMenu.add(new OmMenuItem(em.getName(), em.getDescription()){
                private static final long serialVersionUID = 1L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    target.appendJavaScript((CharSequence)String.format("window.open('%s', '_blank');", em.getLink()));
                }
            });
        }
        this.extraMenu.setVisible(this.extraMenu.hasItems());
    }

    OmMenuItem getMenu() {
        return this.extraMenu;
    }
}

