/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.users;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.server.LdapConfigDao;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.LdapConfig;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.service.mail.EmailManager;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.admin.users.PasswordDialog;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.CommunityUserForm;
import org.apache.openmeetings.web.common.GeneralUserForm;
import org.apache.openmeetings.web.common.UploadableProfileImagePanel;
import org.apache.openmeetings.web.util.DateLabel;
import org.apache.openmeetings.web.util.RestrictiveChoiceProvider;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2MultiChoice;

public class UserForm
extends AdminBaseForm<User> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UserForm.class);
    private final WebMarkupContainer mainContainer = new WebMarkupContainer("adminForm");
    private final WebMarkupContainer listContainer;
    private final WebMarkupContainer domain = new WebMarkupContainer("domain");
    private GeneralUserForm generalForm;
    private final RequiredTextField<String> login = new RequiredTextField("login");
    private StrongPasswordValidator passValidator;
    private final PasswordTextField password = new PasswordTextField("password", (IModel)new Model());
    private final Modal<String> warning;
    private final DropDownChoice<Long> domainId = new DropDownChoice("domainId");
    private final PasswordDialog adminPass;
    private final UploadableProfileImagePanel avatar = new UploadableProfileImagePanel("avatar", null);
    private final CheckBox otpEnabled = new CheckBox("otp-enabled", (IModel)Model.of((Serializable)Boolean.valueOf(false)));
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private EmailManager emainManager;
    @SpringBean
    private LdapConfigDao ldapDao;
    @SpringBean
    private OAuth2Dao oauthDao;

    public UserForm(String id, WebMarkupContainer listContainer, User user, PasswordDialog adminPass, Modal<String> warning) {
        super(id, new CompoundPropertyModel((Object)user));
        this.setOutputMarkupId(true);
        this.listContainer = listContainer;
        this.warning = warning;
        this.adminPass = adminPass;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.mainContainer});
        this.mainContainer.add(new Component[]{this.avatar.setOutputMarkupPlaceholderTag(true)});
        Component[] componentArray = new Component[1];
        this.generalForm = new GeneralUserForm("general", (IModel<User>)this.getModel(), true);
        componentArray[0] = this.generalForm;
        this.mainContainer.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.passValidator = new StrongPasswordValidator((User)this.getModelObject());
        componentArray2[0] = this.password.setResetPassword(false).setLabel((IModel)new ResourceModel("110")).setRequired(false).add((IValidator)this.passValidator);
        this.mainContainer.add(componentArray2);
        this.mainContainer.add(new Component[]{this.otpEnabled.setLabel((IModel)new ResourceModel("otp.enabled"))});
        this.login.setLabel((IModel)new ResourceModel("108"));
        this.mainContainer.add(new Component[]{this.login.add((IValidator)StringValidator.minimumLength((int)OpenmeetingsVariables.getMinLoginLength()))});
        this.mainContainer.add(new Component[]{new DropDownChoice("type", List.of(User.Type.values())).add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                UserForm.this.updateDomain(target);
            }
        }})});
        this.update(null);
        this.mainContainer.add(new Component[]{this.domain.add(new Component[]{this.domainId}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.mainContainer.add(new Component[]{new Label("ownerId")});
        this.mainContainer.add(new Component[]{new DateLabel("inserted")});
        this.mainContainer.add(new Component[]{new DateLabel("updated")});
        this.mainContainer.add(new Component[]{new Select2MultiChoice("rights", null, (ChoiceProvider)new RestrictiveChoiceProvider<User.Right>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(User.Right choice) {
                return choice.name();
            }

            @Override
            public String toId(User.Right choice) {
                return choice.name();
            }

            public void query(String term, int page, Response<User.Right> response) {
                boolean isGroupAdmin = AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights());
                for (User.Right r : User.Right.getAllowed((boolean)isGroupAdmin)) {
                    if (!Strings.isEmpty((String)term) && !r.name().contains(term)) continue;
                    response.add((Object)r);
                }
            }

            @Override
            public User.Right fromId(String id) {
                return User.Right.valueOf((String)id);
            }
        })});
        this.mainContainer.add(new Component[]{new CommunityUserForm("comunity", (IModel<User>)this.getModel())});
        this.remove(new Behavior[]{this.validationBehavior});
        this.setNewRecordVisible(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.onModelChanged();
    }

    protected void onModelChanged() {
        super.onModelChanged();
        User u = (User)this.getModelObject();
        boolean nd = !u.isDeleted();
        boolean isNew = u.getId() == null;
        this.mainContainer.setEnabled(nd);
        ((FormComponent)this.otpEnabled.setModelObject((Object)(u.getOtpSecret() != null ? 1 : 0))).setEnabled(OpenmeetingsVariables.isOtpEnabled() && u.getOtpSecret() != null);
        this.setSaveVisible(nd);
        this.setDelVisible(nd && !isNew);
        this.setRestoreVisible(!nd);
        this.setPurgeVisible(!isNew);
        this.password.setModelObject(null);
        this.generalForm.updateModelObject(u, true);
        this.passValidator.setUser(u);
    }

    @Override
    protected void onRestoreSubmit(AjaxRequestTarget target, Form<?> form) {
        User u = (User)this.getModelObject();
        u.setDeleted(false);
        if (!this.userDao.checkLogin(u.getLogin(), u.getType(), u.getDomainId(), u.getId())) {
            this.error((Serializable)((Object)this.getString("error.login.inuse")));
        }
        if (u.getAddress() != null && !this.userDao.checkEmail(u.getAddress().getEmail(), u.getType(), u.getDomainId(), u.getId())) {
            this.error((Serializable)((Object)this.getString("error.email.inuse")));
        }
        if (this.hasError()) {
            u.setDeleted(true);
            target.add(new Component[]{this});
        } else {
            this.onSaveSubmit(target, form);
        }
    }

    @Override
    protected void onPurgeSubmit(AjaxRequestTarget target, Form<?> form) {
        if (this.isAdminPassRequired()) {
            this.adminPass.setAction((SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::purgeUser));
            this.adminPass.show((IPartialPageRequestHandler)target);
        } else {
            this.purgeUser(target);
        }
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        if (this.isAdminPassRequired()) {
            this.adminPass.setAction((SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)t -> this.saveUser((AjaxRequestTarget)t, (String)this.password.getModelObject()));
            this.adminPass.show((IPartialPageRequestHandler)target);
        } else {
            this.saveUser(target, (String)this.password.getConvertedInput());
        }
    }

    private static boolean checkLevel(Set<User.Right> rights) {
        return AuthLevelUtil.hasAdminLevel(rights) || AuthLevelUtil.hasWebServiceLevel(rights);
    }

    boolean isAdminPassRequired() {
        User u = (User)this.getModelObject();
        User ou = this.userDao.get(u.getId());
        return UserForm.checkLevel(u.getRights()) || ou != null && UserForm.checkLevel(ou.getRights());
    }

    private void purgeUser(AjaxRequestTarget target) {
        this.userDao.purge((User)this.getModelObject(), WebSession.getUserId());
        this.updateForm(target);
    }

    private void saveUser(AjaxRequestTarget target, String pass) {
        User u = (User)this.getModelObject();
        boolean isNew = u.getId() == null;
        boolean sendEmailAtRegister = OpenmeetingsVariables.isSendRegisterEmail();
        if (isNew && sendEmailAtRegister) {
            u.setActivatehash(UUID.randomUUID().toString());
        }
        if (isNew && "N/A".equals(u.getDisplayName())) {
            u.resetDisplayName();
        }
        if (Boolean.FALSE.equals(this.otpEnabled.getModelObject())) {
            u.setOtpSecret(null);
            u.setOtpRecoveryCodes(null);
        }
        try {
            u = this.userDao.update(u, pass, WebSession.getUserId());
        }
        catch (Exception e) {
            log.error("[onSaveSubmit]: ", (Throwable)e);
        }
        if (isNew && sendEmailAtRegister) {
            String email = u.getAddress().getEmail();
            this.emainManager.sendMail(this.login.getValue(), email, u.getActivatehash(), false, null);
        }
        this.updateForm(target);
        if (u.getGroupUsers().isEmpty()) {
            this.warning.show((IPartialPageRequestHandler)target);
        }
    }

    private void updateForm(AjaxRequestTarget target) {
        this.setModelObject(this.userDao.get(((User)this.getModelObject()).getId()));
        this.setNewRecordVisible(false);
        target.add(new Component[]{this, this.listContainer});
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(UserDao.getNewUserInstance((User)this.userDao.get(WebSession.getUserId())));
        this.update(target);
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        User user = (User)this.getModelObject();
        user = user.getId() != null ? this.userDao.get(user.getId()) : UserDao.getNewUserInstance(null);
        this.setModelObject(user);
        this.update(target);
    }

    private void deleteUser(AjaxRequestTarget target) {
        this.userDao.delete((User)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(UserDao.getNewUserInstance((User)this.userDao.get(WebSession.getUserId())));
        this.update(target);
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        if (this.isAdminPassRequired()) {
            this.adminPass.setAction((SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::deleteUser));
            this.adminPass.show((IPartialPageRequestHandler)target);
        } else {
            this.deleteUser(target);
        }
    }

    public void updateDomain(AjaxRequestTarget target) {
        User u = (User)this.getModelObject();
        final HashMap<Long, String> values = new HashMap<Long, String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (u.getType() == User.Type.LDAP) {
            for (LdapConfig c : this.ldapDao.getActive()) {
                ids.add(c.getId());
                values.put(c.getId(), c.getName());
            }
        }
        if (u.getType() == User.Type.OAUTH) {
            for (OAuthServer s : this.oauthDao.getActive()) {
                ids.add(s.getId());
                values.put(s.getId(), s.getName());
            }
        }
        this.domainId.setChoices(ids);
        this.domainId.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer<Long>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(Long object) {
                return values.get(object);
            }

            public String getIdValue(Long object, int index) {
                return "" + object;
            }
        });
        this.domain.setVisible(u.getType() == User.Type.LDAP || u.getType() == User.Type.OAUTH);
        if (target != null) {
            target.add(new Component[]{this.domain});
        }
    }

    public void update(AjaxRequestTarget target) {
        this.updateDomain(target);
        this.avatar.setUserId(((User)this.getModelObject()).getId());
        this.avatar.update();
        if (target != null) {
            target.add(new Component[]{this, this.listContainer});
        }
    }

    protected void onValidate() {
        User u = (User)this.getModelObject();
        if (!this.userDao.checkLogin((String)this.login.getConvertedInput(), u.getType(), u.getDomainId(), u.getId())) {
            this.error((Serializable)((Object)this.getString("error.login.inuse")));
        }
        super.onValidate();
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }
}

