/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.configurations;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.basic.Configuration;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.DateLabel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.StringValidator;

public class ConfigForm
extends AdminBaseForm<Configuration> {
    private static final long serialVersionUID = 1L;
    private static final Set<String> PATHS = Set.of("path.ffmpeg", "path.imagemagick", "path.office", "path.sox");
    private final WebMarkupContainer listContainer;
    private final WebMarkupContainer stringBox = new WebMarkupContainer("string-box");
    private final WebMarkupContainer numberBox = new WebMarkupContainer("number-box");
    private final WebMarkupContainer booleanBox = new WebMarkupContainer("boolean-box");
    private final WebMarkupContainer hotkeyBox = new WebMarkupContainer("hotkey-box");
    private final TextArea<String> valueS = new TextArea("valueS");
    private final TextField<Long> valueN = new TextField<Long>("valueN"){
        private static final long serialVersionUID = 1L;

        protected String[] getInputTypes() {
            return new String[]{"number"};
        }
    };
    private final CheckBox valueB = new CheckBox("valueB");
    private final TextField<String> valueH = new TextField("value");
    @SpringBean
    private ConfigurationDao cfgDao;

    public ConfigForm(String id, WebMarkupContainer listContainer, Configuration configuration) {
        super(id, new CompoundPropertyModel((Object)configuration));
        this.setOutputMarkupId(true);
        this.listContainer = listContainer;
    }

    private void refresh(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    private void update(AjaxRequestTarget target) {
        Configuration c = (Configuration)this.getModelObject();
        this.stringBox.setVisible(Configuration.Type.PATH == c.getType() || Configuration.Type.STRING == c.getType());
        this.numberBox.setVisible(Configuration.Type.NUMBER == c.getType());
        this.booleanBox.setVisible(Configuration.Type.BOOL == c.getType());
        this.hotkeyBox.setVisible(Configuration.Type.HOTKEY == c.getType());
        if (target != null) {
            target.add(new Component[]{this.stringBox, this.numberBox, this.booleanBox, this.hotkeyBox});
            if (Configuration.Type.HOTKEY == c.getType()) {
                target.appendJavaScript((CharSequence)"addOmAdminConfigHandlers()");
            }
        }
    }

    protected void onModelChanged() {
        super.onModelChanged();
        this.update(null);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new DateLabel("updated")});
        this.add(new Component[]{new Label("user.login")});
        this.add(new Component[]{new TextArea("comment")});
        this.update(null);
        this.add(new Component[]{new DropDownChoice("type", List.of(Configuration.Type.values()), (IChoiceRenderer)new IChoiceRenderer<Configuration.Type>(){
            private static final long serialVersionUID = 1L;

            public String getIdValue(Configuration.Type rt, int index) {
                return rt.name();
            }

            public Object getDisplayValue(Configuration.Type rt) {
                return rt.name();
            }

            public Configuration.Type getObject(String id, IModel<? extends List<? extends Configuration.Type>> choices) {
                for (Configuration.Type rt : (List)choices.getObject()) {
                    if (!rt.name().equals(id)) continue;
                    return rt;
                }
                return null;
            }
        }).setLabel((IModel)new ResourceModel("45")).add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", this::update)})});
        this.add(new Component[]{new RequiredTextField("key").setLabel((IModel)new ResourceModel("265")).add((IValidator)new IValidator<String>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<String> validatable) {
                Configuration c = ConfigForm.this.cfgDao.forceGet((String)validatable.getValue());
                if (c != null && !c.isDeleted() && !c.getId().equals(((Configuration)ConfigForm.this.getModelObject()).getId())) {
                    validatable.error((IValidationError)new ValidationError(ConfigForm.this.getString("error.cfg.exist")));
                }
            }
        }).add((IValidator)StringValidator.maximumLength((int)255))});
        this.valueS.add((IValidator)StringValidator.maximumLength((int)255));
        this.valueS.add((IValidator)new IValidator<String>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<String> validatable) {
                Configuration c = ConfigForm.this.getModelFixType();
                if (Configuration.Type.PATH == c.getType()) {
                    try {
                        Path.of((String)validatable.getValue(), new String[0]);
                    }
                    catch (InvalidPathException e) {
                        validatable.error((IValidationError)new ValidationError(e.getMessage()));
                    }
                }
            }
        });
        this.stringBox.add(new Component[]{this.valueS.setLabel((IModel)new ResourceModel("271"))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.numberBox.add(new Component[]{this.valueN.setLabel((IModel)new ResourceModel("271"))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.booleanBox.add(new Component[]{this.valueB.setLabel((IModel)new ResourceModel("271"))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.hotkeyBox.add(new Component[]{this.valueH.setLabel((IModel)new ResourceModel("271"))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.stringBox, this.numberBox, this.booleanBox, this.hotkeyBox});
        this.setNewRecordVisible(true);
    }

    private Configuration getModelFixType() {
        Configuration c = (Configuration)this.getModelObject();
        if (c.getKey() != null && PATHS.contains(c.getKey())) {
            c.setType(Configuration.Type.PATH);
        }
        return c;
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        Configuration c = this.cfgDao.forceGet(((Configuration)this.getModelObject()).getKey());
        if (c != null && c.isDeleted() && !c.getId().equals(((Configuration)this.getModelObject()).getId())) {
            ((Configuration)this.getModelObject()).setId(c.getId());
        }
        this.setModelObject(this.cfgDao.update(this.getModelFixType(), WebSession.getUserId()));
        this.setNewRecordVisible(false);
        target.add(new Component[]{this.listContainer});
        this.refresh(target);
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(new Configuration());
        this.refresh(target);
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        Configuration conf = (Configuration)this.getModelObject();
        conf = conf.getId() != null ? this.cfgDao.get(conf.getId()) : new Configuration();
        this.setModelObject(conf);
        this.refresh(target);
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.cfgDao.delete((Configuration)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(new Configuration());
        target.add(new Component[]{this.listContainer});
        this.refresh(target);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(ConfigForm.class, "admin-config.js")));
    }
}

