/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import java.io.IOException;
import org.apache.wicket.util.lang.Args;

@JsonSerialize(using=RemoteSerializer.class)
public class Remote
extends AbstractConfig {
    public static final String DEFAULT_WILDCARD = "%QUERY";
    private static final IKey<CharSequence> Url = Remote.newKey((String)"url", null);
    private static final IKey<String> Wildcard = Remote.newKey((String)"wildcard", (Object)"%QUERY");
    private static final IKey<RateLimit> RateLimitBy = Remote.newKey((String)"rateLimitBy", (Object)((Object)RateLimit.DEBOUNCE));
    private static final IKey<Integer> RateLimitWait = Remote.newKey((String)"rateLimitWait", (Object)300);
    private static final IKey<Json.RawValue> Filter = Remote.newKey((String)"filter", null);
    private static final IKey<Json.RawValue> Replace = Remote.newKey((String)"replace", null);
    private static final IKey<AbstractConfig> Ajax = Remote.newKey((String)"ajax", null);

    public Remote(CharSequence url) {
        Args.notEmpty((CharSequence)url, (String)"url");
        this.put(Url, url);
    }

    public Remote() {
    }

    public Remote withUrl(CharSequence url) {
        Args.notEmpty((CharSequence)url, (String)"url");
        this.put(Url, url);
        return this;
    }

    public Remote withAjax(AbstractConfig ajax) {
        Args.notNull((Object)ajax, (String)"ajax");
        this.put(Ajax, ajax);
        return this;
    }

    public Remote withFilter(Json.RawValue filter) {
        Args.notNull((Object)filter, (String)"filter");
        this.put(Filter, filter);
        return this;
    }

    public Remote withReplace(Json.RawValue replace) {
        Args.notNull((Object)replace, (String)"replace");
        this.put(Replace, replace);
        return this;
    }

    public Remote withRateLimitBy(RateLimit limit) {
        this.put(RateLimitBy, (Object)limit);
        return this;
    }

    public Remote withRateLimitWait(int wait) {
        this.put(RateLimitWait, wait);
        return this;
    }

    public Remote withWildcard(String wildcard) {
        Args.notEmpty((String)wildcard, (String)"wildcard");
        this.put(Wildcard, wildcard);
        return this;
    }

    public boolean isSimple() {
        return this.all().size() == 1;
    }

    public String getWildcard() {
        return (String)this.get(Wildcard);
    }

    public static Remote of(CharSequence url) {
        return new Remote(url);
    }

    public static class RateLimitBySerializer
    extends JsonSerializer<RateLimit> {
        public void serialize(RateLimit rateLimitBy, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(rateLimitBy.name().toLowerCase());
        }
    }

    public static class RemoteSerializer
    extends JsonSerializer<Remote> {
        public void serialize(Remote remote, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (remote.isSimple()) {
                jsonGenerator.writeString(remote.getString(Url));
            } else {
                jsonGenerator.writeRawValue(remote.toJsonString());
            }
        }
    }

    @JsonSerialize(using=RateLimitBySerializer.class)
    public static enum RateLimit {
        DEBOUNCE,
        THROTTLE;

    }
}

