/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeSettings;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;

public abstract class AbstractDateTimePickerWithIcon<T>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    private DatetimePickerConfig config;
    private FormComponent<T> dateInput;

    public AbstractDateTimePickerWithIcon(String markupId, DatetimePickerConfig config) {
        this(markupId, null, config);
    }

    public AbstractDateTimePickerWithIcon(String markupId, IModel<T> model, DatetimePickerConfig config) {
        super(markupId, model);
        this.setRenderBodyOnly(true);
        this.config = config;
    }

    private FormComponent<T> getDateInput() {
        if (this.dateInput == null) {
            this.dateInput = this.newInput("date", this.config.getFormat());
            this.dateInput.setModel(this.getModel());
            this.dateInput.add(new Behavior[]{new DatetimePickerBehavior(this.config)});
        }
        return this.dateInput;
    }

    public void convertInput() {
        this.setConvertedInput(this.getDateInput().getConvertedInput());
    }

    protected void onInitialize() {
        super.onInitialize();
        FormComponent<T> input = this.getDateInput();
        if (this.config.getMaskInput()) {
            input.add(new Behavior[]{this.config.newMaskBehavior()});
        }
        Component iconContainer = this.newIconContainer("iconContainer").add(new Component[]{this.newIcon("icon")}).add(new Behavior[]{new AttributeAppender("data-target", (Serializable)((Object)("#" + input.getMarkupId())))});
        this.add(new Component[]{new WebMarkupContainer("dateWrapper").add(new Component[]{input, iconContainer})});
    }

    public AbstractDateTimePickerWithIcon<T> with(DatetimePickerConfig config) {
        this.config = config;
        return this;
    }

    public DatetimePickerConfig getConfig() {
        return this.config;
    }

    protected abstract FormComponent<T> newInput(String var1, String var2);

    protected MarkupContainer newIconContainer(String wicketId) {
        return new WebMarkupContainer(wicketId);
    }

    protected Component newIcon(String wicketId) {
        return new Icon(wicketId, this.newIconType());
    }

    protected IconType newIconType() {
        return FontAwesomeSettings.get(Application.get()).getIconType(FontAwesomeSettings.IconKey.CALENDAR);
    }

    public FormComponent<T> setLabel(IModel<String> labelModel) {
        this.getDateInput().setLabel(labelModel);
        return super.setLabel(labelModel);
    }
}

