/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.AbstractDateTextFieldConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerLangJsReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.BootstrapDatepickerReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.json.JSONFunction;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractDateTextField<T, P extends TextField<T>, I, C extends AbstractDateTextFieldConfig<C, I>, F extends AbstractDateTextField<T, P, I, C, F>>
extends TextField<T>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final String EVENT_PARAM = "datePickerEvent";
    private static final String DATE = "date";
    private final P converterDelegate;
    private final Class<T> dateTextFieldClass;
    private C config;
    private final Map<Event, AbstractEventHandler> eventMap = new HashMap<Event, AbstractEventHandler>();

    protected AbstractDateTextField(P wicketTextField, Class<T> implementingDateTextFieldClass, C config) {
        super(wicketTextField.getId(), wicketTextField.getModel());
        this.setType(wicketTextField.getType());
        this.setEscapeModelStrings(false);
        this.converterDelegate = wicketTextField;
        this.dateTextFieldClass = implementingDateTextFieldClass;
        this.config = (AbstractDateTextFieldConfig)((Object)Args.notNull(config, (String)"config"));
    }

    public C getConfig() {
        return this.config;
    }

    public F with(C config) {
        if (config != null) {
            this.config = config;
        }
        return (F)((Object)this);
    }

    public String getTextFormat() {
        return ((AbstractTextComponent.ITextFormatProvider)this.converterDelegate).getTextFormat();
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        return this.converterDelegate.getConverter(type);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
        super.onComponentTag(tag);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)BootstrapDatepickerReference.INSTANCE));
        if (!((AbstractDateTextFieldConfig)((Object)this.getConfig())).isDefaultLanguageSet()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new BootstrapDatepickerLangJsReference(((AbstractDateTextFieldConfig)((Object)this.getConfig())).getLanguage())));
        } else {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapDatepickerJsReference.INSTANCE));
        }
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.getConfig())));
    }

    protected CharSequence createScript(C config) {
        String script = JQuery.$((Component)this).chain((CharSequence)"datepicker", config, new Config[0]).get();
        if (this.eventMap.isEmpty()) {
            return script;
        }
        StringBuilder sb = new StringBuilder(script.subSequence(0, script.length() - 1));
        for (Event type : this.eventMap.keySet()) {
            sb.append(".on('").append((Object)type).append("',").append(this.eventMap.get((Object)type).getFunction()).append(')');
        }
        sb.append(';');
        return sb;
    }

    public F addEvent(Event type, AbstractEventHandler handler) {
        this.eventMap.put(type, handler);
        return (F)((Object)this);
    }

    public F addAjaxEvent(Event type, IParentAjaxEventHandler evenHandler) {
        this.addAjaxEvent(type, evenHandler, false);
        return (F)((Object)this);
    }

    public F addAjaxEvent(Event type, IParentAjaxEventHandler evenHandler, boolean updateModel) {
        DatePickerAbstractDefaultAjaxBehavior datePickerAbstractDefaultAjaxBehavior = new DatePickerAbstractDefaultAjaxBehavior(type, evenHandler, updateModel);
        this.add(new Behavior[]{datePickerAbstractDefaultAjaxBehavior});
        this.addEvent(type, datePickerAbstractDefaultAjaxBehavior.abstractAjaxEvent);
        return (F)((Object)this);
    }

    public F removeEvent(Event type) {
        this.eventMap.remove((Object)type);
        return (F)((Object)this);
    }

    public String getDestroyScript() {
        return "$('#" + this.getMarkupId() + "').datepicker('destroy');";
    }

    private class DatePickerAbstractDefaultAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final AbstractAjaxEvent abstractAjaxEvent;

        public DatePickerAbstractDefaultAjaxBehavior(Event event, IParentAjaxEventHandler handler, boolean updateModel) {
            Args.notNull((Object)((Object)event), (String)"event");
            Args.notNull((Object)handler, (String)"handler");
            this.abstractAjaxEvent = this.createNew(event, handler, updateModel);
        }

        protected AbstractAjaxEvent createNew(Event event, IParentAjaxEventHandler handler, boolean updateModel) {
            return new AbstractAjaxEvent(event, handler, updateModel){
                private static final long serialVersionUID = 1L;

                @Override
                protected CharSequence getBody() {
                    return DatePickerAbstractDefaultAjaxBehavior.this.getCallbackScript().toString();
                }
            };
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            this.abstractAjaxEvent.updateAjaxAttributes(attributes);
        }

        protected void respond(AjaxRequestTarget target) {
            this.abstractAjaxEvent.onAjaxEvent(target);
        }
    }

    private abstract class AbstractAjaxEvent
    extends AbstractEventHandler {
        private static final long serialVersionUID = 1L;
        private final Event event;
        private final IParentAjaxEventHandler handler;
        private final boolean updateModel;

        public AbstractAjaxEvent(Event event, IParentAjaxEventHandler handler, boolean updateModel) {
            this.event = event;
            this.handler = handler;
            this.updateModel = updateModel;
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            attributes.getExtraParameters().put(AbstractDateTextField.EVENT_PARAM, this.event.name());
            attributes.getExtraParameters().put(AbstractDateTextField.DATE, new JSONFunction((CharSequence)"e.format()"));
        }

        protected void onAjaxEvent(AjaxRequestTarget target) {
            Object date;
            String dateStr = RequestCycle.get().getRequest().getRequestParameters().getParameterValue(AbstractDateTextField.DATE).toString(null);
            Object object = date = !Strings.isEmpty((String)dateStr) ? AbstractDateTextField.this.converterDelegate.getConverter(AbstractDateTextField.this.dateTextFieldClass).convertToObject(dateStr, RequestCycle.get().getRequest().getLocale()) : null;
            if (this.updateModel) {
                AbstractDateTextField.this.setDefaultModelObject(date);
            }
            this.handler.onAjaxEvent(target, date, this.event);
        }
    }

    static interface IParentAjaxEventHandler<T>
    extends Serializable {
        public void onAjaxEvent(AjaxRequestTarget var1, T var2, Event var3);
    }

    public static abstract class AbstractEventHandler
    implements Serializable {
        protected abstract CharSequence getBody();

        protected String getFunction() {
            StringBuilder sb = new StringBuilder("function(e) {\n");
            sb.append(this.getBody());
            sb.append("\n}");
            return sb.toString();
        }
    }

    public static enum Event {
        show,
        hide,
        clearDate,
        changeDate,
        changeMonth,
        changeYear,
        changeDecade,
        changeCentury;

    }
}

