/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.server.SessiondataDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(BaseWebService.class);
    @Autowired
    protected SessiondataDao sessionDao;
    @Autowired
    protected UserDao userDao;
    @Autowired
    protected RoomDao roomDao;
    @Autowired
    protected FileItemDao fileDao;

    Sessiondata check(String sid) {
        try {
            return this.sessionDao.check(sid);
        }
        catch (Exception e) {
            log.debug("Exception while checking sid", (Throwable)e);
            return new Sessiondata();
        }
    }

    Set<User.Right> getRights(String sid) {
        Sessiondata sd = this.check(sid);
        return this.getRights(sd.getUserId());
    }

    Set<User.Right> getRights(Long id) {
        try {
            return this.userDao.getRights(id);
        }
        catch (Exception e) {
            log.debug("Exception while getting rights", (Throwable)e);
            return new HashSet<User.Right>();
        }
    }

    <T> T performCall(String sid, User.Right level, Function<Sessiondata, T> action) throws ServiceException {
        return this.performCall(sid, (Sessiondata sd) -> AuthLevelUtil.check(this.getRights(sd.getUserId()), (User.Right)level), action);
    }

    <T> T performCall(String sid, Predicate<Sessiondata> allowed, Function<Sessiondata, T> action) throws ServiceException {
        try {
            Sessiondata sd = this.check(sid);
            if (allowed.test(sd)) {
                return action.apply(sd);
            }
            throw ServiceException.NO_PERMISSION;
        }
        catch (ServiceException err) {
            throw err;
        }
        catch (Exception err) {
            log.error("[performCall]", (Throwable)err);
            throw new ServiceException(err.getMessage());
        }
    }
}

