/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestProcessorSupplierContext;
import com.hazelcast.jet.impl.execution.init.Contexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ExpressionEvalContext {
    public static final String SQL_ARGUMENTS_KEY_NAME = "__sql.arguments";
    private final List<Object> arguments;
    private final InternalSerializationService serializationService;

    public ExpressionEvalContext(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
    }

    public static ExpressionEvalContext from(ProcessorSupplier.Context ctx) {
        ArrayList<Object> arguments = (ArrayList<Object>)ctx.jobConfig().getArgument(SQL_ARGUMENTS_KEY_NAME);
        if (ctx instanceof TestProcessorSupplierContext) {
            if (arguments == null) {
                arguments = new ArrayList<Object>();
            }
            return new ExpressionEvalContext(arguments, new DefaultSerializationServiceBuilder().build());
        }
        return new ExpressionEvalContext(Objects.requireNonNull(arguments), ((Contexts.ProcSupplierCtx)ctx).serializationService());
    }

    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }
}

