/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class OsHelper {
    public static final String OS = StringUtil.lowerCaseInternal(System.getProperty("os.name"));

    private OsHelper() {
    }

    public static boolean isLinux() {
        return OS.contains("nux");
    }

    public static boolean isUnixFamily() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isMac() {
        return OS.contains("mac") || OS.contains("darwin");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isArmMac() {
        if (!OsHelper.isMac()) {
            return false;
        }
        try {
            Process process = new ProcessBuilder("sysctl", "-n", "hw.optional.arm64").redirectErrorStream(true).start();
            process.waitFor();
            try (InputStream is = process.getInputStream();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                boolean bl = line.equals("1");
                return bl;
            }
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }
}

