/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.sip;

import java.util.BitSet;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.openmeetings.core.sip.ISipCallbacks;
import org.apache.openmeetings.core.sip.SipStackProcessor;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.ISipManager;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.asteriskjava.manager.DefaultManagerConnection;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.action.ConfbridgeListAction;
import org.asteriskjava.manager.action.DbDelAction;
import org.asteriskjava.manager.action.DbDelTreeAction;
import org.asteriskjava.manager.action.DbGetAction;
import org.asteriskjava.manager.action.DbPutAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.HangupAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.event.ConfbridgeListEvent;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SipManager
implements ISipManager {
    private static final Logger log = LoggerFactory.getLogger(SipManager.class);
    public static final String ASTERISK_OM_FAMILY = "openmeetings";
    public static final String ASTERISK_OM_KEY = "rooms";
    public static final String SIP_FIRST_NAME = "SIP Transport";
    public static final String SIP_USER_NAME = "--SIP--";
    @Value(value="${sip.hostname}")
    private String sipHostname;
    @Value(value="${sip.manager.port}")
    private int managerPort;
    @Value(value="${sip.manager.user}")
    private String managerUser;
    @Value(value="${sip.manager.password}")
    private String managerPass;
    @Value(value="${sip.manager.timeout}")
    private long managerTimeout;
    @Value(value="${sip.ws.remote.port}")
    private int wsPort;
    @Value(value="${sip.ws.remote.user}")
    private String omSipUser;
    @Value(value="${sip.ws.remote.password}")
    private String omSipPasswd;
    @Value(value="${sip.ws.local.host}")
    private String localWsHost;
    @Value(value="${sip.ws.local.port.min}")
    private int minLocalWsPort = 6666;
    @Value(value="${sip.ws.local.port.max}")
    private int maxLocalWsPort = 7666;
    private ManagerConnectionFactory factory;
    private ManagerConnection con;
    private String sipUserPicture;
    private BitSet ports;

    @PostConstruct
    public void init() {
        if (!Strings.isEmpty((String)this.sipHostname)) {
            this.factory = new ManagerConnectionFactory(this.sipHostname, this.managerPort, this.managerUser, this.managerPass);
            this.ports = new BitSet(this.maxLocalWsPort - this.minLocalWsPort);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.con != null) {
            this.con.logoff();
        }
    }

    private void connectManager() throws Exception {
        if (this.con == null || ManagerConnectionState.CONNECTED != this.con.getState()) {
            DefaultManagerConnection defCon = (DefaultManagerConnection)this.factory.createManagerConnection();
            defCon.setDefaultEventTimeout(this.managerTimeout);
            defCon.setDefaultResponseTimeout(this.managerTimeout);
            defCon.setSocketReadTimeout((int)this.managerTimeout);
            defCon.setSocketTimeout((int)this.managerTimeout);
            this.con = defCon;
            this.con.login("on");
        }
    }

    private ManagerResponse exec(ManagerAction action) {
        if (this.factory == null) {
            log.warn("There is no Asterisk configured");
            return null;
        }
        try {
            this.connectManager();
            ManagerResponse r = this.con.sendAction(action);
            if (r != null) {
                log.debug("{}", (Object)r);
            }
            return r instanceof ManagerError ? null : r;
        }
        catch (Exception e) {
            log.error("Error while executing ManagerAction: {}", (Object)action, (Object)e);
            return null;
        }
    }

    private ResponseEvents execEvent(EventGeneratingAction action) {
        if (this.factory == null) {
            log.warn("There is no Asterisk configured");
            return null;
        }
        try {
            this.connectManager();
            ResponseEvents r = this.con.sendEventGeneratingAction(action);
            if (r != null) {
                log.trace("{}", (Object)r.getResponse());
            }
            return r == null || r.getResponse() instanceof ManagerError ? null : r;
        }
        catch (Exception e) {
            log.error("Error while executing EventGeneratingAction: {}", (Object)action, (Object)e);
            return null;
        }
    }

    private static String getKey(String confno) {
        return "rooms/" + confno;
    }

    static String getSipNumber(Room r) {
        return r != null && r.getConfno() != null ? r.getConfno() : null;
    }

    public String get(String confno) {
        String pin = null;
        DbGetAction da = new DbGetAction(ASTERISK_OM_FAMILY, SipManager.getKey(confno));
        ManagerResponse r = this.exec((ManagerAction)da);
        if (r != null) {
            pin = r.getResponse();
        }
        return pin;
    }

    public void update(String confno, String pin) {
        this.delete(confno);
        DbPutAction da = new DbPutAction(ASTERISK_OM_FAMILY, SipManager.getKey(confno), pin);
        this.exec((ManagerAction)da);
    }

    public void delete() {
        DbDelTreeAction da = new DbDelTreeAction(ASTERISK_OM_FAMILY, ASTERISK_OM_KEY);
        this.exec((ManagerAction)da);
    }

    public void delete(String confno) {
        DbDelAction da = new DbDelAction(ASTERISK_OM_FAMILY, SipManager.getKey(confno));
        this.exec((ManagerAction)da);
    }

    public long countUsers(String confno) {
        ConfbridgeListAction da;
        ResponseEvents r;
        if (confno != null && (r = this.execEvent((EventGeneratingAction)(da = new ConfbridgeListAction(confno)))) != null) {
            long count = r.getEvents().stream().filter(ConfbridgeListEvent.class::isInstance).filter(evt -> !this.omSipUser.equals(evt.getCallerIdName())).count();
            log.trace("SipManager::countUsers == {}", (Object)count);
            return count;
        }
        return 0L;
    }

    public void callExternalNumber(String number, Room r) {
        String sipNumber = SipManager.getSipNumber(r);
        if (sipNumber == null) {
            log.warn("Failed to get SIP number for room: {}", (Object)r);
            return;
        }
        OriginateAction oa = new OriginateAction();
        oa.setChannel(String.format("Local/%s@rooms-originate", sipNumber));
        oa.setContext("rooms-out");
        oa.setExten(number);
        oa.setPriority(Integer.valueOf(1));
        oa.setTimeout(Long.valueOf(this.managerTimeout));
        this.exec((ManagerAction)oa);
    }

    public void hangup(Room r) {
        String sipNumber = SipManager.getSipNumber(r);
        if (sipNumber == null) {
            log.warn("Failed to get SIP number for room: {}", (Object)r);
            return;
        }
        HangupAction ha = new HangupAction(String.format("/^Local/%s@rooms-originate-.*$/", sipNumber), 16);
        this.exec((ManagerAction)ha);
    }

    public void setUserPicture(Function<User, String> pictureCreator) {
        User u = new User();
        u.setId(OmFileHelper.SIP_USER_ID);
        this.sipUserPicture = pictureCreator.apply(u);
    }

    public User getSipUser(Room r) {
        if (this.factory == null || !OpenmeetingsVariables.isSipEnabled() || !r.isSipEnabled()) {
            return null;
        }
        User u = new User();
        u.setId(OmFileHelper.SIP_USER_ID);
        u.setFirstname(SIP_FIRST_NAME);
        u.setLogin(SIP_USER_NAME);
        u.setPictureUri(this.sipUserPicture);
        return u;
    }

    String getSipHostname() {
        return this.sipHostname;
    }

    int getWsPort() {
        return this.wsPort;
    }

    String getOmSipUser() {
        return this.omSipUser;
    }

    String getOmSipPasswd() {
        return this.omSipPasswd;
    }

    String getLocalWsHost() {
        return this.localWsHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SipStackProcessor> createSipStackProcessor(String name, Room r, ISipCallbacks callbacks) throws Exception {
        int port;
        if (this.factory == null || !OpenmeetingsVariables.isSipEnabled() || !r.isSipEnabled()) {
            log.warn("Asterisk is not configured or denied in room #{}", (Object)r.getId());
            return Optional.empty();
        }
        BitSet bitSet = this.ports;
        synchronized (bitSet) {
            int free = this.ports.nextClearBit(0);
            this.ports.flip(free);
            port = this.minLocalWsPort + free;
        }
        return Optional.of(new SipStackProcessor(this, name, port, callbacks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freePort(int port) {
        BitSet bitSet = this.ports;
        synchronized (bitSet) {
            this.ports.clear(port - this.minLocalWsPort);
        }
    }
}

