/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.openmeetings.db.dao.basic.MailMessageDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.mail.ByteArrayDataSource;
import org.apache.openmeetings.util.mail.MailUtil;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="mailHandler")
public class MailHandler {
    private static final Logger log = LoggerFactory.getLogger(MailHandler.class);
    private static final int MAIL_SEND_TIMEOUT = 3600000;
    private static final int MAXIMUM_ERROR_COUNT = 5;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private MailMessageDao mailMessageDao;

    protected MimeMessage appendIcsBody(MimeMessage msg, MailMessage m) throws Exception {
        log.debug("setMessageBody for iCal message");
        MimeMultipart multipart = new MimeMultipart();
        MimeMultipart multiBody = new MimeMultipart("alternative");
        MimeBodyPart html = new MimeBodyPart();
        html.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(m.getBody(), "text/html; charset=UTF-8")));
        multiBody.addBodyPart((BodyPart)html);
        MimeBodyPart iCalContent = new MimeBodyPart();
        iCalContent.addHeader("content-class", "urn:content-classes:calendarmessage");
        iCalContent.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((InputStream)new ByteArrayInputStream(m.getIcs()), "text/calendar; charset=UTF-8; method=" + m.getIcsMethod())));
        multiBody.addBodyPart((BodyPart)iCalContent);
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Multipart)multiBody);
        multipart.addBodyPart((BodyPart)body);
        MimeBodyPart iCalAttachment = new MimeBodyPart();
        iCalAttachment.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((InputStream)new ByteArrayInputStream(m.getIcs()), "application/ics")));
        iCalAttachment.removeHeader("Content-Transfer-Encoding");
        iCalAttachment.addHeader("Content-Transfer-Encoding", "base64");
        iCalAttachment.removeHeader("Content-Type");
        iCalAttachment.addHeader("Content-Type", "application/ics");
        iCalAttachment.setFileName("invite.ics");
        multipart.addBodyPart((BodyPart)iCalAttachment);
        msg.setContent((Multipart)multipart);
        return msg;
    }

    private MimeMessage appendBody(MimeMessage msg, MailMessage m) throws MessagingException {
        return this.appendBody(msg, m.getBody());
    }

    public MimeMessage appendBody(MimeMessage msg, String body) throws MessagingException {
        msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html; charset=\"utf-8\"")));
        msg.setHeader("X-Mailer", "XML-Mail");
        msg.setSentDate(new Date());
        return msg;
    }

    public MimeMessage getBasicMimeMessage() throws Exception {
        Session session;
        log.debug("getBasicMimeMessage");
        if (OpenmeetingsVariables.getSmtpServer() == null) {
            throw new IllegalStateException("SMTP settings were not provided");
        }
        Properties props = new Properties(System.getProperties());
        props.put("mail.smtp.host", OpenmeetingsVariables.getSmtpServer());
        props.put("mail.smtp.port", (Object)OpenmeetingsVariables.getSmtpPort());
        if (OpenmeetingsVariables.isSmtpUseTls() || OpenmeetingsVariables.isSmtpUseSsl()) {
            props.put("mail.smtp.ssl.trust", OpenmeetingsVariables.getSmtpServer());
        }
        if (OpenmeetingsVariables.isSmtpUseTls() && OpenmeetingsVariables.isSmtpUseSsl()) {
            log.warn("Both SSL and TLS are enabled, TLS will be started");
        }
        props.put("mail.smtp.starttls.enable", (Object)OpenmeetingsVariables.isSmtpUseTls());
        props.put("mail.smtp.ssl.enable", (Object)OpenmeetingsVariables.isSmtpUseSsl());
        props.put("mail.smtp.connectiontimeout", (Object)OpenmeetingsVariables.getSmtpConnectionTimeOut());
        props.put("mail.smtp.timeout", (Object)OpenmeetingsVariables.getSmtpTimeOut());
        if (!Strings.isEmpty((String)OpenmeetingsVariables.getSmtpUser()) && !Strings.isEmpty((String)OpenmeetingsVariables.getSmtpPass())) {
            props.put("mail.smtp.auth", (Object)true);
            session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(OpenmeetingsVariables.getSmtpUser(), OpenmeetingsVariables.getSmtpPass());
                }
            });
        } else {
            session = Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(OpenmeetingsVariables.getMailFrom()));
        return msg;
    }

    private MimeMessage getMimeMessage(MailMessage m) throws Exception {
        log.debug("getMimeMessage");
        MimeMessage msg = this.getBasicMimeMessage();
        msg.setSubject(m.getSubject(), StandardCharsets.UTF_8.name());
        String replyTo = m.getReplyTo();
        if (replyTo != null && OpenmeetingsVariables.isMailAddReplyTo()) {
            log.debug("setReplyTo {}", (Object)replyTo);
            if (MailUtil.isValid((String)replyTo)) {
                msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
            }
        }
        msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)m.getRecipients(), (boolean)false));
        return m.getIcs() == null ? this.appendBody(msg, m) : this.appendIcsBody(msg, m);
    }

    public void send(String toEmail, String subj, String message) {
        this.send(toEmail, null, subj, message);
    }

    public void send(String toEmail, String replyTo, String subj, String message) {
        this.send(new MailMessage(toEmail, replyTo, subj, message));
    }

    public void send(MailMessage m) {
        this.send(m, false);
    }

    public void send(MailMessage m, boolean send) {
        if (send) {
            if (m.getId() != null) {
                m.setStatus(MailMessage.Status.SENDING);
                this.mailMessageDao.update(m, null);
            }
            this.taskExecutor.execute(() -> {
                log.debug("Message sending in progress");
                log.debug("  To: {}", (Object)m.getRecipients());
                log.debug("  Subject: {}", (Object)m.getSubject());
                try {
                    Transport.send((Message)this.getMimeMessage(m));
                    m.setLastError("");
                    m.setStatus(MailMessage.Status.DONE);
                }
                catch (Exception e) {
                    log.error("Error while sending message", (Throwable)e);
                    m.setErrorCount(m.getErrorCount() + 1);
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    m.setLastError(sw.getBuffer().toString());
                    m.setStatus(m.getErrorCount() < 5 ? MailMessage.Status.NONE : MailMessage.Status.ERROR);
                }
                if (m.getId() != null) {
                    this.mailMessageDao.update(m, null);
                }
            });
        } else {
            m.setStatus(MailMessage.Status.NONE);
            this.mailMessageDao.update(m, null);
        }
    }

    public void resetSendingStatus() {
        log.trace("resetSendingStatus enter ...");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.add(14, -3600000);
        this.mailMessageDao.resetSendingStatus(c);
        log.trace("... resetSendingStatus done.");
    }

    public void sendMails() {
        log.trace("sendMails enter ...");
        List list = this.mailMessageDao.get(0L, 1L, MailMessage.Status.NONE);
        if (!list.isEmpty()) {
            log.debug("Number of emails in init queue {}", (Object)list.size());
            while (!list.isEmpty()) {
                this.send((MailMessage)list.get(0), true);
                list = this.mailMessageDao.get(0L, 1L, MailMessage.Status.NONE);
            }
            log.debug("... sendMails done.");
        }
    }
}

