/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.util.process.ProcessHelper;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.ImageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class ImageConverter
extends BaseConverter {
    private static final Logger log = LoggerFactory.getLogger(ImageConverter.class);
    private static final String PAGE_TMPLT = "page-%04d.png";
    @Autowired
    private UserDao userDao;

    public ProcessResultList convertImage(BaseFileItem f, StoredFile sf, Optional<DoubleConsumer> progress) throws IOException {
        return this.convertImage(f, sf, new ProcessResultList(), progress);
    }

    public ProcessResultList convertImage(BaseFileItem f, StoredFile sf, ProcessResultList logs, Optional<DoubleConsumer> progress) throws IOException {
        File png = f.getFile("png");
        if (!sf.isPng()) {
            File img = f.getFile(sf.getExt());
            log.debug("##### convertImage destinationFile: {}", (Object)png);
            logs.add(this.convertSinglePng(img, png));
        } else if (!png.exists()) {
            FileUtils.copyFile((File)f.getFile(sf.getExt()), (File)png);
        }
        progress.ifPresent(theProgress -> theProgress.accept(0.5));
        logs.add(ImageConverter.initSize(f, png, "image/png"));
        progress.ifPresent(theProgress -> theProgress.accept(0.5));
        return logs;
    }

    public ProcessResultList convertImageUserProfile(File file, Long userId, boolean skipConvertion) throws Exception {
        ProcessResultList returnMap = new ProcessResultList();
        File[] files = OmFileHelper.getUploadProfilesUserDir((Long)userId).listFiles(fi -> fi.getName().endsWith("png"));
        if (files != null) {
            for (File f : files) {
                FileUtils.deleteQuietly((File)f);
            }
        }
        File destinationFile = OmFileHelper.getNewFile((File)OmFileHelper.getUploadProfilesUserDir((Long)userId), (String)"profile", (String)"png");
        if (!skipConvertion) {
            returnMap.add(this.convertSinglePng(file, destinationFile));
        } else {
            FileUtils.copyFile((File)file, (File)destinationFile);
        }
        if (!skipConvertion) {
            Files.deleteIfExists(file.toPath());
        }
        String img = destinationFile.getName();
        User us = this.userDao.get(userId);
        us.setPictureUri(img);
        this.userDao.update(us, userId);
        return returnMap;
    }

    private String getDpi() {
        return this.cfgDao.getString("document.dpi", "150");
    }

    private String getQuality() {
        return this.cfgDao.getString("document.quality", "90");
    }

    private static ProcessResult initSize(BaseFileItem f, File img, String mime) {
        ProcessResult res = new ProcessResult();
        res.setProcess("get image dimensions :: " + f.getId());
        ImageParser parser = new ImageParser();
        try (FileInputStream is = new FileInputStream(img);){
            Metadata metadata = new Metadata();
            metadata.set("Content-Type", mime);
            parser.parse((InputStream)is, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
            f.setWidth(Integer.valueOf(metadata.get(TIFF.IMAGE_WIDTH)));
            f.setHeight(Integer.valueOf(metadata.get(TIFF.IMAGE_LENGTH)));
            res.setExitCode(ProcessResult.ZERO);
        }
        catch (Exception e) {
            log.error("Error while getting dimensions", (Throwable)e);
            res.setError("Error while getting dimensions");
            res.setException(e.getMessage());
            res.setExitCode(Integer.valueOf(-1));
        }
        return res;
    }

    private ProcessResult convertSinglePng(File in, File out) throws IOException {
        List<String> argv = List.of(this.getPathToConvert(), in.getCanonicalPath(), out.getCanonicalPath());
        return ProcessHelper.exec((String)"convertSinglePng", argv);
    }

    public ProcessResult resize(File in, File out, Integer width, Integer height) throws IOException {
        List<String> argv = List.of(this.getPathToConvert(), "-resize", (Serializable)(width == null ? "" : width) + (String)(height == null ? "" : "x" + height), in.getCanonicalPath(), out.getCanonicalPath());
        return ProcessHelper.exec((String)"resize", argv);
    }

    public ProcessResultList convertDocument(FileItem f, File pdf, ProcessResultList logs, Optional<DoubleConsumer> progress) throws IOException {
        log.debug("convertDocument");
        List<String> argv = List.of(this.getPathToConvert(), "-density", this.getDpi(), "-define", "pdf:use-cropbox=true", pdf.getCanonicalPath(), "+profile", "'*'", "-quality", this.getQuality(), new File(pdf.getParentFile(), PAGE_TMPLT).getCanonicalPath());
        ProcessResult res = ProcessHelper.exec((String)"convert PDF to images", argv);
        logs.add(res);
        progress.ifPresent(theProgress -> theProgress.accept(0.25));
        if (res.isOk()) {
            File[] pages = pdf.getParentFile().listFiles(fi -> fi.isFile() && fi.getName().startsWith("page") && fi.getName().endsWith("png"));
            if (pages == null || pages.length == 0) {
                f.setCount(0);
            } else {
                f.setCount(pages.length);
                logs.add(ImageConverter.initSize((BaseFileItem)f, pages[0], "image/png"));
            }
        }
        progress.ifPresent(theProgress -> theProgress.accept(0.25));
        return logs;
    }
}

