/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.HandlerStrategies;
import org.apache.openjpa.jdbc.meta.strats.MapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;

public class HandlerRelationMapTableFieldStrategy
extends MapTableFieldStrategy {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(HandlerRelationMapTableFieldStrategy.class);
    private Column[] _kcols = null;
    private ColumnIO _kio = null;
    private boolean _kload = false;

    @Override
    public Column[] getKeyColumns(ClassMapping cls) {
        return this._kcols;
    }

    public ColumnIO getKeyColumnIO() {
        return this._kio;
    }

    @Override
    public Column[] getValueColumns(ClassMapping cls) {
        return this.field.getElementMapping().getColumns();
    }

    @Override
    public void selectKey(Select sel, ClassMapping key, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) {
        sel.select(this._kcols, joins);
    }

    @Override
    public void selectValue(Select sel, ClassMapping val, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) {
        sel.select(val, this.field.getElementMapping().getSelectSubclasses(), store, fetch, 0, joins);
    }

    @Override
    public Result[] getResults(final OpenJPAStateManager sm, final JDBCStore store, final JDBCFetchConfiguration fetch, final int eagerMode, final Joins[] resJoins, boolean lrs) throws SQLException {
        ValueMapping elem = this.field.getElementMapping();
        final ClassMapping[] vals = elem.getIndependentTypeMappings();
        Union union = store.getSQLFactory().newUnion(vals.length);
        if (fetch.getSubclassFetchMode(elem.getTypeMapping()) != 1) {
            union.abortUnion();
        }
        union.setLRS(lrs);
        union.select(new Union.Selector(){

            @Override
            public void select(Select sel, int idx) {
                sel.select(HandlerRelationMapTableFieldStrategy.this._kcols);
                if (HandlerRelationMapTableFieldStrategy.this.field.isUni1ToMFK()) {
                    sel.whereForeignKey(HandlerRelationMapTableFieldStrategy.this.field.getElementMapping().getForeignKey(), sm.getObjectId(), HandlerRelationMapTableFieldStrategy.this.field.getElementMapping().getDeclaredTypeMapping(), store);
                    sel.select(vals[idx], HandlerRelationMapTableFieldStrategy.this.field.getElementMapping().getSelectSubclasses(), store, fetch, eagerMode, null);
                } else {
                    sel.whereForeignKey(HandlerRelationMapTableFieldStrategy.this.field.getJoinForeignKey(), sm.getObjectId(), HandlerRelationMapTableFieldStrategy.this.field.getDefiningMapping(), store);
                    Joins joins = HandlerRelationMapTableFieldStrategy.this.joinValueRelation(sel.newJoins(), vals[idx]);
                    sel.select(vals[idx], HandlerRelationMapTableFieldStrategy.this.field.getElementMapping().getSelectSubclasses(), store, fetch, eagerMode, joins);
                    if (idx == 0) {
                        resJoins[1] = joins;
                    }
                }
            }
        });
        Result res = union.execute(store, fetch);
        return new Result[]{res, res};
    }

    @Override
    public Object loadKey(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        return HandlerStrategies.loadObject(this.field.getKeyMapping(), sm, store, fetch, res, joins, this._kcols, this._kload);
    }

    @Override
    public Object loadValue(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        ClassMapping val = res.getBaseMapping();
        if (val == null) {
            val = this.field.getElementMapping().getIndependentTypeMappings()[0];
        }
        return res.load(val, store, fetch, joins);
    }

    @Override
    public Joins joinValueRelation(Joins joins, ClassMapping val) {
        ValueMapping vm = this.field.getElementMapping();
        ForeignKey fk = vm.getForeignKey(val);
        if (fk == null) {
            return joins;
        }
        return joins.joinRelation(this.field.getName(), fk, val, vm.getSelectSubclasses(), false, false);
    }

    @Override
    public void map(boolean adapt) {
        super.map(adapt);
        ValueMapping key = this.field.getKeyMapping();
        if (key.getHandler() == null) {
            throw new MetaDataException(_loc.get("no-handler", key));
        }
        ValueMapping val = this.field.getElementMapping();
        if (val.getTypeCode() != 15 || val.isEmbeddedPC()) {
            throw new MetaDataException(_loc.get("not-relation", val));
        }
        FieldMapping mapped = this.field.getMappedByMapping();
        if (this.field.isUni1ToMFK() || !this.field.isBiMTo1JT() && mapped != null) {
            this.handleMappedByForeignKey(adapt);
        } else if (this.field.isBiMTo1JT() || mapped == null) {
            this.field.mapJoin(adapt, true);
            if (val.getTypeMapping().isMapped()) {
                ValueMappingInfo vinfo = val.getValueInfo();
                ForeignKey fk = vinfo.getTypeJoin(val, "value", false, adapt);
                val.setForeignKey(fk);
                val.setColumnIO(vinfo.getColumnIO());
            } else {
                RelationStrategies.mapRelationToUnmappedPC(val, "value", adapt);
            }
            val.mapConstraints("value", adapt);
        }
        this._kio = new ColumnIO();
        DBDictionary dict = this.field.getMappingRepository().getDBDictionary();
        this._kcols = HandlerStrategies.map(key, dict.getValidColumnName(DBIdentifier.newColumn("key"), this.field.getTable()).getName(), this._kio, adapt);
        this.field.mapPrimaryKey(adapt);
    }

    @Override
    public void initialize() {
        this._kload = this.field.getKeyMapping().getHandler().objectValueRequiresLoad(this.field.getKeyMapping());
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.insert(sm, store, rm, (Map)sm.fetchObject(this.field.getIndex()));
    }

    private void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (!this.field.isBiMTo1JT() && this.field.getMappedBy() != null) {
            return;
        }
        Row row = null;
        if (!this.field.isUni1ToMFK()) {
            row = rm.getSecondaryRow(this.field.getTable(), 1);
            row.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
        }
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        StoreContext ctx = store.getContext();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            OpenJPAStateManager valsm = RelationStrategies.getStateManager(entry.getValue(), ctx);
            if (this.field.isUni1ToMFK()) {
                row = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                row.wherePrimaryKey(valsm);
                val.setForeignKey(row, sm);
            } else {
                val.setForeignKey(row, valsm);
            }
            HandlerStrategies.set(key, entry.getKey(), store, row, this._kcols, this._kio, true);
            PersistenceCapable obj = sm.getPersistenceCapable();
            if (this.populateKey(row, valsm, obj, ctx, rm, store) || this.field.isUni1ToMFK()) continue;
            rm.flushSecondaryRow(row);
        }
    }

    public void setKey(Object keyObj, JDBCStore store, Row row) throws SQLException {
        ValueMapping key = this.field.getKeyMapping();
        HandlerStrategies.set(key, keyObj, store, row, this._kcols, this._kio, true);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Collection add;
        Collection rem;
        OpenJPAStateManager valsm;
        Iterator mkey;
        Proxy proxy2;
        if (this.field.getMappedBy() != null && !this.field.isBiMTo1JT()) {
            return;
        }
        Map map = (Map)sm.fetchObject(this.field.getIndex());
        ChangeTracker ct = null;
        if (map instanceof Proxy && Proxies.isOwner(proxy2 = (Proxy)((Object)map), sm, this.field.getIndex())) {
            ct = proxy2.getChangeTracker();
        }
        if (ct == null || !ct.isTracking()) {
            this.delete(sm, store, rm);
            this.insert(sm, store, rm, map);
            return;
        }
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        StoreContext ctx = store.getContext();
        Collection change = ct.getChanged();
        boolean canChange = val.getForeignKey().isLogical();
        if (canChange && !change.isEmpty()) {
            Row changeRow = null;
            if (!this.field.isUni1ToMFK()) {
                changeRow = rm.getSecondaryRow(this.field.getTable(), 0);
                changeRow.whereForeignKey(this.field.getJoinForeignKey(), sm);
            }
            for (Iterator o : change) {
                mkey = o;
                valsm = RelationStrategies.getStateManager(map.get(mkey), ctx);
                if (this.field.isUni1ToMFK()) {
                    changeRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                    changeRow.wherePrimaryKey(valsm);
                    val.setForeignKey(changeRow, sm);
                } else {
                    val.setForeignKey(changeRow, valsm);
                }
                HandlerStrategies.where(key, mkey, store, changeRow, this._kcols);
                if (this.field.isUni1ToMFK()) continue;
                rm.flushSecondaryRow(changeRow);
            }
        }
        if (!(rem = ct.getRemoved()).isEmpty() || !canChange && !change.isEmpty()) {
            Row delRow = null;
            if (!this.field.isUni1ToMFK()) {
                delRow = rm.getSecondaryRow(this.field.getTable(), 2);
                delRow.whereForeignKey(this.field.getJoinForeignKey(), sm);
            }
            for (Object value : rem) {
                mkey = value;
                if (this.field.isUni1ToMFK()) {
                    this.updateSetNull(sm, mkey, store, rm);
                    continue;
                }
                HandlerStrategies.where(key, mkey, store, delRow, this._kcols);
                rm.flushSecondaryRow(delRow);
            }
            if (!canChange && !change.isEmpty()) {
                for (Object o : change) {
                    mkey = o;
                    if (this.field.isUni1ToMFK()) {
                        this.updateSetNull(sm, mkey, store, rm);
                        continue;
                    }
                    HandlerStrategies.where(key, mkey, store, delRow, this._kcols);
                    rm.flushSecondaryRow(delRow);
                }
            }
        }
        if (!(add = ct.getAdded()).isEmpty() || !canChange && !change.isEmpty()) {
            Row addRow = null;
            if (!this.field.isUni1ToMFK()) {
                addRow = rm.getSecondaryRow(this.field.getTable(), 1);
                addRow.setForeignKey(this.field.getJoinForeignKey(), this.field.getJoinColumnIO(), sm);
            }
            for (Object value : add) {
                mkey = value;
                valsm = RelationStrategies.getStateManager(map.get(mkey), ctx);
                if (this.field.isUni1ToMFK()) {
                    addRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                    addRow.wherePrimaryKey(valsm);
                    val.setForeignKey(addRow, sm);
                } else {
                    val.setForeignKey(addRow, valsm);
                }
                HandlerStrategies.set(key, mkey, store, addRow, this._kcols, this._kio, true);
                if (this.field.isUni1ToMFK()) continue;
                rm.flushSecondaryRow(addRow);
            }
            if (!canChange && !change.isEmpty()) {
                for (Object o : change) {
                    mkey = o;
                    valsm = RelationStrategies.getStateManager(map.get(mkey), ctx);
                    if (this.field.isUni1ToMFK()) {
                        addRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, valsm, true);
                        addRow.wherePrimaryKey(valsm);
                        val.setForeignKey(addRow, sm);
                    } else {
                        val.setForeignKey(addRow, valsm);
                    }
                    HandlerStrategies.set(key, mkey, store, addRow, this._kcols, this._kio, true);
                    if (this.field.isUni1ToMFK()) continue;
                    rm.flushSecondaryRow(addRow);
                }
            }
        }
    }

    @Override
    public Joins joinRelation(Joins joins, boolean forceOuter, boolean traverse) {
        ValueMapping val = this.field.getElementMapping();
        ClassMapping[] clss = val.getIndependentTypeMappings();
        if (clss.length != 1) {
            if (traverse) {
                throw RelationStrategies.unjoinable(val);
            }
            return joins;
        }
        ForeignKey fk = val.getForeignKey(clss[0]);
        if (fk == null) {
            return joins;
        }
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), fk, clss[0], val.getSelectSubclasses(), false, false);
        }
        return joins.joinRelation(this.field.getName(), fk, clss[0], val.getSelectSubclasses(), false, false);
    }

    @Override
    public Joins joinKeyRelation(Joins joins, boolean forceOuter, boolean traverse) {
        if (traverse) {
            HandlerStrategies.assertJoinable(this.field.getKeyMapping());
        }
        return joins;
    }

    @Override
    public Object toDataStoreValue(Object val, JDBCStore store) {
        return RelationStrategies.toDataStoreValue(this.field.getElementMapping(), val, store);
    }

    @Override
    public Object toKeyDataStoreValue(Object val, JDBCStore store) {
        return HandlerStrategies.toDataStoreValue(this.field.getKeyMapping(), val, this._kcols, store);
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.getMappedBy() != null && !this.field.isBiMTo1JT()) {
            return;
        }
        if (this.field.isUni1ToMFK()) {
            Map mapObj = (Map)sm.fetchObject(this.field.getIndex());
            this.updateSetNull(sm, store, rm, mapObj.keySet());
            return;
        }
        super.delete(sm, store, rm);
    }

    private void updateSetNull(OpenJPAStateManager sm, JDBCStore store, RowManager rm, Set rem) throws SQLException {
        for (Object mkey : rem) {
            this.updateSetNull(sm, mkey, store, rm);
        }
    }

    private void updateSetNull(OpenJPAStateManager sm, Object mkey, JDBCStore store, RowManager rm) throws SQLException {
        ValueMapping key = this.field.getKeyMapping();
        ValueMapping val = this.field.getElementMapping();
        StoreContext ctx = store.getContext();
        ValueMappingInfo vinfo = this.field.getElementMapping().getValueInfo();
        Table table = vinfo.getTable(val);
        ForeignKey joinFK = this.field.getMappingInfo().getJoinForeignKey(this.field, table, true);
        Row delRow = rm.getRow(this.field.getElementMapping().getDeclaredTypeMapping().getTable(), 0, sm, true);
        delRow.whereForeignKey(joinFK, sm);
        val.setForeignKey(delRow, null);
        HandlerStrategies.set(key, null, store, delRow, this._kcols, this._kio, true);
        HandlerStrategies.where(key, mkey, store, delRow, this._kcols);
    }
}

