/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.transport.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.kurento.client.internal.server.ProtocolException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.Props;

public class JsonResponseUtils {
    public static <E> E convertFromResult(JsonElement result, Type type) {
        if (type == Void.class || type == Void.TYPE) {
            return null;
        }
        JsonElement extractResult = JsonResponseUtils.extractValueFromResponse(result, type);
        return (E)JsonUtils.fromJson((JsonElement)extractResult, (Type)type);
    }

    private static JsonElement extractValueFromResponse(JsonElement result, Type type) {
        if (result == null) {
            return null;
        }
        if (result instanceof JsonNull) {
            return null;
        }
        if (JsonResponseUtils.isPrimitiveClass(type) || JsonResponseUtils.isEnum(type)) {
            if (result instanceof JsonPrimitive) {
                return result;
            }
            if (result instanceof JsonArray) {
                throw new ProtocolException("Json array '" + result + " cannot be converted to " + JsonResponseUtils.getTypeName(type));
            }
            if (result instanceof JsonObject) {
                return JsonResponseUtils.extractSimpleValueFromJsonObject((JsonObject)result, type);
            }
            throw new ProtocolException("Unrecognized json element: " + result);
        }
        if (JsonResponseUtils.isComplexType(type)) {
            if (result instanceof JsonObject && ((JsonObject)result).has("value")) {
                return ((JsonObject)result).get("value");
            }
            return result;
        }
        if (JsonResponseUtils.isList(type)) {
            if (result instanceof JsonArray) {
                return result;
            }
            return JsonResponseUtils.extractSimpleValueFromJsonObject((JsonObject)result, type);
        }
        return result;
    }

    private static JsonElement extractSimpleValueFromJsonObject(JsonObject result, Type type) {
        if (!result.has("value")) {
            throw new ProtocolException("Json object " + result + " cannot be converted to " + JsonResponseUtils.getTypeName(type) + " without a 'value' property");
        }
        return result.get("value");
    }

    private static boolean isEnum(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isEnum();
        }
        return false;
    }

    private static boolean isComplexType(Type type) {
        return type == Props.class;
    }

    private static boolean isPrimitiveClass(Type type) {
        return type == String.class || type == Void.class || type == Void.TYPE || type == Boolean.class || type == Boolean.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE;
    }

    private static boolean isList(Type type) {
        ParameterizedType paramType;
        if (type == List.class) {
            return true;
        }
        if (type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getRawType() instanceof Class) {
            return ((Class)paramType.getRawType()).isAssignableFrom(List.class);
        }
        return false;
    }

    private static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            StringBuilder sb = new StringBuilder();
            ParameterizedType paramType = (ParameterizedType)type;
            Class rawClass = (Class)paramType.getRawType();
            sb.append(rawClass.getSimpleName());
            Type[] arguments = paramType.getActualTypeArguments();
            if (arguments.length > 0) {
                sb.append('<');
                for (Type argType : arguments) {
                    sb.append(JsonResponseUtils.getTypeName(argType));
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append('>');
            }
            return sb.toString();
        }
        return type.toString();
    }
}

