/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ProcessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHelper {
    public static final Logger log = LoggerFactory.getLogger(ProcessHelper.class);

    private ProcessHelper() {
    }

    private static String getCommand(List<String> argv) {
        return String.join((CharSequence)" ", argv);
    }

    private static void debugCommandStart(String desc, List<String> argv) {
        if (log.isDebugEnabled()) {
            log.debug("START {} ################# ", (Object)desc);
            log.debug(ProcessHelper.getCommand(argv));
        }
    }

    private static void debugCommandEnd(String desc) {
        if (log.isDebugEnabled()) {
            log.debug("END {} ################# ", (Object)desc);
        }
    }

    public static ProcessResult exec(String process, List<String> argv) {
        return ProcessHelper.exec(process, argv, false);
    }

    public static ProcessResult exec(String process, List<String> argv, boolean optional) {
        return ProcessHelper.exec(process, argv, Map.of(), optional);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessResult exec(String process, List<String> argv, Map<? extends String, ? extends String> env, boolean optional) {
        ProcessResult res = new ProcessResult().setProcess(process).setOptional(optional);
        ProcessHelper.debugCommandStart(process, argv);
        Process proc = null;
        StreamWatcher errorWatcher = null;
        StreamWatcher inputWatcher = null;
        long start = System.currentTimeMillis();
        try {
            res.setCommand(ProcessHelper.getCommand(argv)).setOut("");
            ProcessBuilder pb = new ProcessBuilder(argv);
            pb.environment().putAll(env);
            proc = pb.start();
            errorWatcher = new StreamWatcher(proc.getErrorStream());
            inputWatcher = new StreamWatcher(proc.getInputStream());
            errorWatcher.start();
            inputWatcher.start();
            proc.waitFor(OpenmeetingsVariables.getExtProcessTtl(), TimeUnit.MINUTES);
            res.setExitCode(proc.exitValue()).setOut(inputWatcher.toString()).setError(errorWatcher.toString());
        }
        catch (InterruptedException e) {
            ProcessHelper.onException(e, start, res);
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            ProcessHelper.onException(t, start, res);
        }
        finally {
            if (proc != null) {
                errorWatcher.finish();
                inputWatcher.finish();
                proc.destroy();
            }
        }
        ProcessHelper.debugCommandEnd(process);
        return res;
    }

    private static void onException(Throwable t, long start, ProcessResult res) {
        log.error("executeScript", t);
        res.setExitCode(-1).setError("Exception after " + CalendarHelper.formatMillis(System.currentTimeMillis() - start) + " of work; " + t.getMessage()).setException(t.toString());
    }

    private static class StreamWatcher
    extends Thread {
        public final StringBuilder output = new StringBuilder();
        private final InputStream is;
        private boolean run = true;

        private StreamWatcher(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));){
                String line = br.readLine();
                while (this.run && line != null) {
                    this.output.append(line).append('\n');
                    line = br.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void finish() {
            this.run = false;
        }

        @Override
        public String toString() {
            return this.output.toString();
        }
    }
}

