/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.logging;

import io.prometheus.client.Histogram;
import org.apache.openmeetings.util.logging.PrometheusUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PrometheusAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object logExecutionTime(ProceedingJoinPoint joinPoint, String logType) throws Throwable {
        String className = joinPoint.getSignature().getDeclaringType().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        Histogram.Timer timer = ((Histogram.Child)PrometheusUtil.getHistogram().labels(new String[]{className, methodName, logType, "default"})).startTimer();
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            timer.observeDuration();
        }
    }

    @Around(value="@annotation(TimedDatabase)")
    public Object logExecutionTime(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logExecutionTime(joinPoint, "database");
    }

    @Around(value="@annotation(TimedApplication)")
    public Object logExecutionTimedApplication(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logExecutionTime(joinPoint, "application");
    }
}

