/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.boxes.HandlerBox;
import com.drew.metadata.mp4.media.Mp4HintHandler;
import com.drew.metadata.mp4.media.Mp4MetaHandler;
import com.drew.metadata.mp4.media.Mp4SoundHandler;
import com.drew.metadata.mp4.media.Mp4TextHandler;
import com.drew.metadata.mp4.media.Mp4VideoHandler;

public class Mp4HandlerFactory {
    private static final String HANDLER_SOUND_MEDIA = "soun";
    private static final String HANDLER_VIDEO_MEDIA = "vide";
    private static final String HANDLER_HINT_MEDIA = "hint";
    private static final String HANDLER_TEXT_MEDIA = "text";
    private static final String HANDLER_META_MEDIA = "meta";
    private Mp4Handler<?> caller;

    public Mp4HandlerFactory(Mp4Handler<?> caller) {
        this.caller = caller;
    }

    public Mp4Handler<?> getHandler(HandlerBox box, Metadata metadata, Mp4Context context) {
        String type = box.getHandlerType();
        if (type.equals(HANDLER_SOUND_MEDIA)) {
            return new Mp4SoundHandler(metadata, context);
        }
        if (type.equals(HANDLER_VIDEO_MEDIA)) {
            return new Mp4VideoHandler(metadata, context);
        }
        if (type.equals(HANDLER_HINT_MEDIA)) {
            return new Mp4HintHandler(metadata, context);
        }
        if (type.equals(HANDLER_TEXT_MEDIA)) {
            return new Mp4TextHandler(metadata, context);
        }
        if (type.equals(HANDLER_META_MEDIA)) {
            return new Mp4MetaHandler(metadata, context);
        }
        return this.caller;
    }
}

