/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IAnnotation;
import org.aspectj.org.eclipse.jdt.core.IField;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryMember;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavadocContents;
import org.aspectj.org.eclipse.jdt.internal.core.ResolvedBinaryField;
import org.eclipse.core.runtime.IProgressMonitor;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryField)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        IBinaryAnnotation[] binaryAnnotations = info.getAnnotations();
        return this.getAnnotations(binaryAnnotations, info.getTagBits());
    }

    @Override
    public Object getConstant() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return BinaryField.convertConstant(info.getConstant());
    }

    @Override
    public int getFlags() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    public int getElementType() {
        return 8;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '^';
    }

    @Override
    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    @Override
    public String getTypeSignature() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature != null) {
            return new String(ClassFile.translatedName(genericSignature));
        }
        return new String(ClassFile.translatedName(info.getTypeName()));
    }

    @Override
    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedBinaryField resolvedHandle = new ResolvedBinaryField(this.getParent(), this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        JavadocContents javadocContents = ((BinaryType)this.getDeclaringType()).getJavadocContents(monitor);
        if (javadocContents == null) {
            return null;
        }
        return javadocContents.getFieldDoc(this);
    }

    @Override
    public boolean isRecordComponent() throws JavaModelException {
        return false;
    }
}

